// ignore_for_file: camel_case_types, prefer_typing_uninitialized_variables

import 'package:absenkuv3/Bloc/Kpi/KpiSaya/SimpanDraftPengajuanKpiSayaBloc.dart';
import 'package:absenkuv3/Repository/Model/Kpi/KpiTeam/mDataPengajuanKpi.dart';
import 'package:absenkuv3/UI/Modul/Kpi/KpiSaya/komponen/Komponenplaning.dart';
import 'package:absenkuv3/UI/Modul/Kpi/KpiTeam/komponen/KomponenKpiPengajuanTeam.dart';
import 'package:flutter/material.dart';
import 'package:flutter_bloc/flutter_bloc.dart';

class KomponenFinalPerfomanceIndicator extends StatefulWidget {
  final List<DataPengajuan> data;
  final ParsingModelKaryawan karyawan;

  KomponenFinalPerfomanceIndicator(this.data, this.karyawan);

  @override
  State<KomponenFinalPerfomanceIndicator> createState() =>
      _KomponenFinalPerfomanceIndicatorState();
}

class _KomponenFinalPerfomanceIndicatorState
    extends State<KomponenFinalPerfomanceIndicator> {
  final List<TextEditingController> controllers = [];

  @override
  void initState() {
    super.initState();
    _initializeControllers();
  }

  void _initializeControllers() {
    for (var obj in widget.data) {
      var listItems = obj.listItem;
      if (listItems != null) {
        for (var item in listItems) {
          controllers.add(TextEditingController(text: item.actualBukti));
        }
      }
    }
  }

  @override
  Widget build(BuildContext context) {
    return Stack(
      children: [
        SingleChildScrollView(
          child: Column(
            crossAxisAlignment: CrossAxisAlignment.start,
            children: [
              // _buildHeader(),
              // Divider(thickness: 15),
              _buildDataList(),
              // _buildActionButtons(context),
            ],
          ),
        ),
      ],
    );
  }

  Widget _buildDataList() {
    return ListView.builder(
      padding: EdgeInsets.only(top: 10),
      shrinkWrap: true,
      physics: NeverScrollableScrollPhysics(),
      itemCount: widget.data.length,
      itemBuilder: (context, index) {
        return _buildDataItem(widget.data[index], index);
      },
    );
  }

  Widget _buildDataItem(DataPengajuan obj, int index) {
    var listItems = obj.listItem;
    return Column(
      crossAxisAlignment: CrossAxisAlignment.start,
      children: [
        Padding(
          padding: const EdgeInsets.all(8.0),
          child: Text(
            obj.nmObject.toString(),
            style: TextStyle(fontSize: 20, fontWeight: FontWeight.bold),
          ),
        ),
        Divider(),
        if (listItems != null && listItems.isNotEmpty)
          ...listItems.map((item) => _buildListItem(item)).toList(),
        Divider(thickness: 10),
      ],
    );
  }

  Widget _buildListItem(var item) {
    return Container(
      decoration: BoxDecoration(
        borderRadius: BorderRadius.circular(15),
        color: Color(0xffF2f2f7),
      ),
      margin: EdgeInsets.symmetric(vertical: 10, horizontal: 15),
      padding: EdgeInsets.all(11),
      child: Column(
        crossAxisAlignment: CrossAxisAlignment.start,
        children: [
          _buildPerformanceIndicator(item),
          SizedBox(height: 15),
          _buildTargetAndWeight(item),
          SizedBox(height: 10),
          _buildScoreRows(item),
          SizedBox(height: 10),
        ],
      ),
    );
  }

  Widget _buildPerformanceIndicator(var item) {
    return Column(
      crossAxisAlignment: CrossAxisAlignment.start,
      children: [
        Row(children: [Text('Aspek Kinerja')]),
        Text(item.nmIndikator.toString(),
            style: TextStyle(fontSize: 15, fontWeight: FontWeight.w500)),
      ],
    );
  }

  Widget _buildTargetAndWeight(var item) {
    return Row(
      crossAxisAlignment: CrossAxisAlignment.start,
      children: [
        Expanded(
            child: TextSub(label: 'Target', value: item.target.toString())),
        Expanded(child: TextSub(label: 'Bobot', value: item.bobot.toString())),
        Expanded(child: Container()), // Placeholder
      ],
    );
  }

  Widget _buildScoreRows(var item) {
    return Column(
      children: [
        Row(
          crossAxisAlignment: CrossAxisAlignment.start,
          children: [
            Expanded(
                child: TextSub(label: 'Skor 1', value: item.poin1.toString())),
            Expanded(
                child: TextSub(label: 'Skor 2', value: item.poin2.toString())),
            Expanded(
                child: TextSub(label: 'Skor 3', value: item.poin3.toString())),
          ],
        ),
        SizedBox(height: 10),
        Row(
          crossAxisAlignment: CrossAxisAlignment.start,
          children: [
            Expanded(
                child: TextSub(label: 'Skor 4', value: item.poin4.toString())),
            Expanded(
                child: TextSub(label: 'Skor 5', value: item.poin5.toString())),
            Expanded(child: Container()), // Placeholder
          ],
        ),
        SizedBox(height: 10),
        Row(
          crossAxisAlignment: CrossAxisAlignment.start,
          children: [
            Expanded(
                child: TextSub(
                    label: 'Actual', value: item.actualPoin.toString())),
            Expanded(
                child: TextSub(
                    label: 'Bukti Actual', value: item.actualBukti.toString())),
            Expanded(child: Container()), // Placeholder
          ],
        ),
        SizedBox(height: 10),
        Row(
          crossAxisAlignment: CrossAxisAlignment.start,
          children: [
            Expanded(
                child: TextSub(
                    label: 'Actual Approval',
                    value: item.actualPoinApproval.toString())),
            Expanded(child: Container()), // Placeholder

            Expanded(child: Container()), // Placeholder
          ],
        ),
      ],
    );
  }
}
