import 'package:absenkuv3/Bloc/Kpi/KpiApproval/GetDataPengajuanNilaiIndividuBloc.dart';
import 'package:absenkuv3/Repository/Model/Kpi/KpiTeam/mDataPengajuanKpi.dart';
import 'package:absenkuv3/Setting/value_image.dart';
import 'package:absenkuv3/UI/Modul/Kpi/KpiApprovalTeam/HalamanPengajuanApprovalKpiTeam/PengajuanNilaiIndividu/komponen/KomponenPengajuanNilaiIndividu.dart';
import 'package:flutter/material.dart';
import 'package:flutter_bloc/flutter_bloc.dart';

class FinalNilaiIndividu extends StatefulWidget {
  var data;
  FinalNilaiIndividu(this.data);

  @override
  State<FinalNilaiIndividu> createState() => _FinalNilaiIndividuState();
}

class _FinalNilaiIndividuState extends State<FinalNilaiIndividu> {
  final TextEditingController _roleController = TextEditingController();
  final TextEditingController _carrerController = TextEditingController();

  @override
  void initState() {
    BlocProvider.of<GetDataPengajuanNilaiIndividuBloc>(context).add(
        GetDataNilaiIndividu(
            context,
            ParsingModelKaryawan(
                id_karyawan: widget.data[0],
                id_company: widget.data[1],
                bulan: widget.data[2],
                tahun: widget.data[3])));
    super.initState();
  }

  @override
  Widget build(BuildContext context) {
    return Scaffold(
      body: Column(
        children: [
          Expanded(
            child: BlocBuilder<GetDataPengajuanNilaiIndividuBloc,
                GetDataPengajuanNilaiIndividuState>(
              builder: (BuildContext context,
                  GetDataPengajuanNilaiIndividuState state) {
                if (state is GetDataNilaiIndividuSuccessState) {
                  return Column(
                    children: [
                      Expanded(
                        child: SingleChildScrollView(
                          child: Column(
                            crossAxisAlignment: CrossAxisAlignment.start,
                            children: [
                              KomponenTabelNilai(state.data!.informasiSkor!),
                              KomponenGrade(
                                data: state.data!.informasiGrade!,
                              ),
                              state.data!.informasiCtt != null
                                  ? KomponenCatatan(state.data!.informasiCtt!)
                                  : Container()
                            ],
                          ),
                        ),
                      ),
                    ],
                  );
                } else if (state is DataPengajuanNilaiIndividuProgressState) {
                  return Center(
                    child: CircularProgressIndicator(
                      strokeWidth: 8,
                    ),
                  );
                } else {
                  return Center(
                    child: Image.asset(
                      ValueImage.noData,
                      height: 250,
                    ),
                  );
                }
              },
            ),
          ),
        ],
      ),
    );
  }
}
