import 'package:absenkuv3/Bloc/Kpi/KpiSaya/SimpanDraftPengajuanKpiSayaBloc.dart';
import 'package:absenkuv3/Repository/Model/Kpi/KpiTeam/mDataPengajuanKpi.dart';
import 'package:absenkuv3/UI/Modul/Kpi/KpiTeam/komponen/KomponenKpiPengajuanTeam.dart';
import 'package:absenkuv3/UI/Template/style.dart';
import 'package:flutter/material.dart';
import 'package:flutter_bloc/flutter_bloc.dart';

class KomponenPengajuanAspekKinerja extends StatefulWidget {
  List<DataPengajuan> data;
  ParsingModelKaryawan parsingKaryawan;

  KomponenPengajuanAspekKinerja(this.data, this.parsingKaryawan);

  @override
  State<KomponenPengajuanAspekKinerja> createState() =>
      _KomponenPengajuanAspekKinerjaState();
}

class _KomponenPengajuanAspekKinerjaState
    extends State<KomponenPengajuanAspekKinerja> {
  void initState() {
    super.initState();
  }

  void ColectData() {
    List<Map<String, dynamic>> newData = [];
    int index = 0;
    for (var obj in widget.data) {
      var listItems = obj.listItem; // Use dot notation to access listItem
      if (listItems != null) {
        for (var item in listItems) {
          newData.add({
            "id_pi_trx": item.idPiTrx, // Use dot notation to access properties
            "actual_poin_approval": item.actualPoinApproval,
          });
          index++;
        }
      }
    }
    showDialog(
      context: context,
      builder: (context) {
        return AlertDialog(
          title: Text('Data Baru'),
          content: SingleChildScrollView(
            child: Text(newData.toString()),
          ),
          actions: [
            TextButton(
              onPressed: () => {
                BlocProvider.of<SimpanDraftPengajuanKpiSayaBloc>(context).add(
                    SimpanDraftPengajuanApproval(
                        newData, widget.parsingKaryawan, context))
              },
              child: Text('OK'),
            ),
          ],
        );
      },
    );
  }

  @override
  Widget build(BuildContext context) {
    return SingleChildScrollView(
      child: Column(
        children: [
          ListView.builder(
            padding: EdgeInsets.only(top: 10),
            shrinkWrap: true,
            physics: NeverScrollableScrollPhysics(),
            itemCount: widget.data.length,
            itemBuilder: (context, index) {
              var obj = widget.data[index];
              var listItems = obj.listItem;
              return Column(
                crossAxisAlignment: CrossAxisAlignment.start,
                children: [
                  Padding(
                    padding: const EdgeInsets.all(8.0),
                    child: Text(
                      obj.nmObject.toString(),
                      style:
                          TextStyle(fontSize: 20, fontWeight: FontWeight.bold),
                    ),
                  ),
                  Divider(),
                  if (listItems != null && listItems.isNotEmpty)
                    Column(
                      children: [
                        ListView.builder(
                          physics: NeverScrollableScrollPhysics(),
                          shrinkWrap: true,
                          itemCount: listItems.length,
                          itemBuilder: (context, itemIndex) {
                            final item = listItems[itemIndex];
                            return Container(
                              decoration: BoxDecoration(
                                borderRadius: BorderRadius.circular(15),
                                color: Color(0xffF2f2f7),
                              ),
                              margin: EdgeInsets.symmetric(
                                  vertical: 10, horizontal: 15),
                              padding: EdgeInsets.all(11),
                              child: Column(
                                crossAxisAlignment: CrossAxisAlignment.start,
                                children: [
                                  Column(
                                    crossAxisAlignment:
                                        CrossAxisAlignment.start,
                                    children: [
                                      Row(
                                        children: [Text('Aspek Kinerja')],
                                      ),
                                      Text(item.nmIndikator.toString(),
                                          style: TextStyle(
                                              fontSize: 15,
                                              fontWeight: FontWeight.w500)),
                                    ],
                                  ),
                                  SizedBox(height: 15),
                                  Row(
                                    crossAxisAlignment:
                                        CrossAxisAlignment.start,
                                    children: [
                                      Expanded(
                                        child: TextSub(
                                          label: 'Target',
                                          value: item.target.toString(),
                                        ),
                                      ),
                                      Expanded(
                                        child: TextSub(
                                          label: 'Bobot',
                                          value: item.bobot.toString(),
                                        ),
                                      ),
                                      Expanded(child: Container()), // Bagian 3
                                    ],
                                  ),
                                  SizedBox(height: 10),
                                  Row(
                                    crossAxisAlignment:
                                        CrossAxisAlignment.start,
                                    children: [
                                      Expanded(
                                        child: TextSub(
                                          label: 'Skor 1',
                                          value: item.poin1.toString(),
                                        ),
                                      ),
                                      Expanded(
                                        child: TextSub(
                                          label: 'Skor 2',
                                          value: item.poin2.toString(),
                                        ),
                                      ),
                                      Expanded(
                                        child: TextSub(
                                          label: 'Skor 3',
                                          value: item.poin3.toString(),
                                        ),
                                      ),
                                    ],
                                  ),
                                  SizedBox(height: 10),
                                  Row(
                                    crossAxisAlignment:
                                        CrossAxisAlignment.start,
                                    children: [
                                      Expanded(
                                        child: TextSub(
                                          label: 'Skor 4',
                                          value: item.poin4.toString(),
                                        ),
                                      ),
                                      Expanded(
                                        child: TextSub(
                                          label: 'Skor 5',
                                          value: item.poin5.toString(),
                                        ),
                                      ),
                                      Expanded(child: Container()), // Bagian 3
                                    ],
                                  ),
                                  SizedBox(
                                    height: 10,
                                  ),
                                  Row(
                                    crossAxisAlignment:
                                        CrossAxisAlignment.start,
                                    children: [
                                      Expanded(
                                        child: TextSub(
                                          label: 'Actual',
                                          value: item.actualPoin.toString(),
                                        ),
                                      ),
                                      Expanded(
                                        child: TextSub(
                                          label: 'Bukti Actual',
                                          value: item.actualBukti.toString(),
                                        ),
                                      ),
                                      Expanded(child: Container()), // Bagian 3
                                    ],
                                  ),
                                  SizedBox(
                                    height: 10,
                                  ),
                                  Container(
                                    child: Center(
                                      child: Text("Approval",
                                          style: TextStyle(
                                              fontSize: 15,
                                              fontWeight: FontWeight.w500)),
                                    ),
                                  ),
                                  SizedBox(
                                    height: 10,
                                  ),
                                  Container(
                                    decoration: BoxDecoration(
                                      borderRadius: BorderRadius.circular(10),
                                      color: Colors.white,
                                    ),
                                    child: Center(
                                      child: Wrap(
                                        spacing: 8.0,
                                        children: List<Widget>.generate(5, (i) {
                                          int radioValue = i + 1;
                                          return Row(
                                            mainAxisSize: MainAxisSize.min,
                                            children: [
                                              Radio<int>(
                                                value: radioValue,
                                                groupValue:
                                                    item.actualPoinApproval == 0
                                                        ? null
                                                        : item
                                                            .actualPoinApproval,
                                                onChanged: (value) {
                                                  setState(() {
                                                    item.actualPoinApproval =
                                                        value!;
                                                  });
                                                },
                                              ),
                                              Text(radioValue.toString()),
                                            ],
                                          );
                                        }),
                                      ),
                                    ),
                                  ),
                                  SizedBox(
                                    height: 10,
                                  )
                                ],
                              ),
                            );
                          },
                        ),
                        Divider(
                          thickness: 10,
                        )
                      ],
                    )
                  else
                    Container(),
                ],
              );
            },
          ),
          Container(
            width: MediaQuery.of(context).size.width,
            margin: EdgeInsets.symmetric(vertical: 5, horizontal: 5),
            child: ElevatedButton(
              style: ElevatedButton.styleFrom(
                backgroundColor: CustomStyle.color1,
                foregroundColor: Colors.white,
                shape: RoundedRectangleBorder(
                  borderRadius: BorderRadius.circular(
                      20), // Adjust this value to change the roundness
                ),
              ),
              onPressed: () {
                List<Map<String, dynamic>> newData = [];
                int index = 0;
                for (var obj in widget.data) {
                  var listItems =
                      obj.listItem; // Use dot notation to access listItem
                  if (listItems != null) {
                    for (var item in listItems) {
                      newData.add({
                        "id_pi_trx": item
                            .idPiTrx, // Use dot notation to access properties
                        "actual_poin_approval": item.actualPoinApproval,
                      });
                      index++;
                    }
                  }
                }
                BlocProvider.of<SimpanDraftPengajuanKpiSayaBloc>(context).add(
                    SimpanDraftPengajuanApproval(
                        newData, widget.parsingKaryawan, context));
              },
              child: const Text("Simpan"),
            ),
          ),
        ],
      ),
    );
  }
}
