// ignore_for_file: camel_case_types, prefer_typing_uninitialized_variables

import 'package:absenkuv3/Bloc/Kpi/KpiTeam/GetListKpiTeamBloc.dart';
import 'package:absenkuv3/Repository/Model/Kpi/Core/mFilterKpi.dart';
import 'package:absenkuv3/Setting/value_image.dart';
import 'package:absenkuv3/UI/Modul/Kpi/KpiTeam/komponen/KomponenKpiTeam.dart';
import 'package:absenkuv3/UI/Template/CupertinoPicker/Bloc/date_pick_bloc.dart';
import 'package:absenkuv3/UI/Template/CupertinoPicker/UI/TemplateMonthYearPicker.dart';
import 'package:absenkuv3/UI/Template/style.dart';
import 'package:flutter/material.dart';
import 'package:flutter_bloc/flutter_bloc.dart';

class HalamanListDiterimaKpiTeam extends StatefulWidget {
  const HalamanListDiterimaKpiTeam({Key? key}) : super(key: key);

  @override
  State<HalamanListDiterimaKpiTeam> createState() =>
      _HalamanListDiterimaKpiTeamState();
}

class _HalamanListDiterimaKpiTeamState
    extends State<HalamanListDiterimaKpiTeam> {
  ScrollController _scrollController = new ScrollController();
  TextEditingController _searchController = TextEditingController();
  String _searchQuery = '';
  @override
  void initState() {
    BlocProvider.of<DatePickBloc>(context)
        .add(PickStartDateEvent(DateTime.now()));
    super.initState();
  }

  @override
  void dispose() {
    _searchController.dispose();
    super.dispose();
  }

  void _onSearchButtonPressed() {
    setState(() {
      _searchQuery = _searchController.text.toLowerCase();
    });
  }

  @override
  Widget build(BuildContext context) {
    return Stack(
      children: [
        Column(
          children: [
            Padding(
              padding: const EdgeInsets.all(15.0),
              child: Row(
                children: [
                  Expanded(
                    child: TextField(
                      controller: _searchController,
                      decoration: InputDecoration(
                        isDense: true,
                        hintText: 'Search...',
                        prefixIcon: Icon(Icons.search),
                        border: OutlineInputBorder(
                          borderRadius: BorderRadius.circular(8.0),
                        ),
                      ),
                    ),
                  ),
                  SizedBox(width: 8),
                  Container(
                    decoration: BoxDecoration(
                      borderRadius: BorderRadius.circular(25),
                      color: CustomStyle.color1,
                    ),
                    child: IconButton(
                      iconSize: 30,
                      onPressed: _onSearchButtonPressed,
                      icon: Icon(Icons.search_rounded, color: Colors.white),
                    ),
                  ),
                ],
              ),
            ),
            Divider(
              height: 10,
              thickness: 10,
            ),
            Expanded(
              child: BlocBuilder<GetListkpiTeamBloc, DataListKpiTeamState>(
                  builder: (BuildContext context, DataListKpiTeamState state) {
                if (state is GetListKpiTeamSuccessState) {
                  var filteredData = state.data!.where((item) {
                    return item.namaLengkap!
                        .toLowerCase()
                        .contains(_searchQuery);
                  }).toList();
                  if (filteredData.isEmpty) {
                    return Center(
                      child: Image.asset(
                        ValueImage.noData,
                        height: 250,
                      ),
                    );
                  }
                  return ListView.builder(
                    physics: AlwaysScrollableScrollPhysics(),
                    controller: _scrollController,
                    itemCount: filteredData.length,
                    itemBuilder: (BuildContext context, index) {
                      return CardListKpiTeam(filteredData[index], 'approved');
                    },
                  );
                } else if (state is DataListKpiTeamProgressState)
                  return Center(
                    child: CircularProgressIndicator(
                      strokeWidth: 8,
                    ),
                  );
                else
                  return Center(
                    child: Image.asset(
                      ValueImage.noData,
                      height: 250,
                    ),
                  );
              }),
            ),
          ],
        ),
        Positioned(
          bottom: 16,
          right: 14,
          child: BlocListener<DatePickBloc, DatePickState>(
              listener: (BuildContext context, DatePickState state) {
                if (state is DateSelected) {
                  BlocProvider.of<GetListkpiTeamBloc>(context).add(
                      GetDataListKpiTeam(ModelFilterKpi(
                          status: '9', monthYear: state.startDate)));
                }
              },
              child: TemplateMonthYearPicker()),
        ),
      ],
    );
  }
}
