import 'package:absenkuv3/Bloc/AuthBloc.dart';
import 'package:absenkuv3/Bloc/NavigatorBloc.dart';
import 'package:absenkuv3/Repository/Model/PageModel/mIzinPage.dart';
import 'package:absenkuv3/Repository/Model/mLogin.dart';
import 'package:absenkuv3/Setting/PengaturanBahasa.dart';
import 'package:absenkuv3/Setting/value_image.dart';
import 'package:absenkuv3/UI/Modul/Izin/HalamanListIzinSaya.dart';
import 'package:absenkuv3/UI/Modul/Izin/HalamanListIzinPegawai.dart';
import 'package:absenkuv3/UI/Template/style.dart';
import 'package:flutter/material.dart';
import 'package:flutter_bloc/flutter_bloc.dart';

class ParentTabIzin extends StatefulWidget {
  @override
  State<ParentTabIzin> createState() => _ParentTabIzinState();
}

class _ParentTabIzinState extends State<ParentTabIzin> {
  final int tabLength = 2;

  Future<bool> keluar() async {
    BlocProvider.of<NavigatorBloc>(context).add(NavigateRemoveToDashboard(context));
    return false;
  }

  @override
  Widget build(BuildContext context) {
    return FutureBuilder<PageIzinModel>(
        future: PengaturanBahasa().izin(),
        builder: (context, snapshot){
          if(snapshot.connectionState == ConnectionState.done){
            return BlocBuilder<AuthBloc, LoginRespon>(
                builder: (BuildContext context, LoginRespon loginRespon) {
                  return WillPopScope(
                    onWillPop: keluar,
                    child: DefaultTabController(
                      length: tabLength,
                      child: Scaffold(
                        appBar: AppBar(
                          centerTitle: true,
                          flexibleSpace: Image(
                            image: AssetImage(ValueImage.headerBiruDashboard),
                            fit: BoxFit.cover,
                          ),
                          backgroundColor: Colors.transparent,
                          title: Text(
                            snapshot.data!.menuIzin!.title!.parentTitle!,
                            style: TextStyle(fontSize: CustomStyle.fontSizeTitle),
                          ),
                          bottom: loginRespon.dataLogin!.level != 3
                              ? TabBar(
                            labelPadding: EdgeInsets.all(0),
                            indicatorSize: TabBarIndicatorSize.tab,
                            indicatorWeight: 4,
                            isScrollable: true,
                            tabs: [
                              Container(
                                width: MediaQuery.of(context).size.width / tabLength,
                                child: Tab(
                                  text: snapshot.data!.menuIzin!.title!.tabSaya!,
                                ),
                              ),
                              Container(
                                width: MediaQuery.of(context).size.width / tabLength,
                                child: Tab(
                                  text: snapshot.data!.menuIzin!.title!.tabKaryawan!,
                                ),
                              ),
                            ],
                          )
                              : null,
                          actions: [
                            GestureDetector(
                              onTap: () => BlocProvider.of<NavigatorBloc>(context)
                                  .add(NavigateToPengajuanIzin(context)),
                              child: Container(
                                  margin: EdgeInsets.only(right: 14),
                                  child: Icon(
                                    Icons.add,
                                    size: 26,
                                  )),
                            ),
                          ],
                        ),
                        body: TabBarView(
                          physics: NeverScrollableScrollPhysics(),
                          children: [
                            HalamanListIzinSaya(snapshot.data),
                            HalamanListIzinPegawai(snapshot.data),
                          ],
                        ),
                      ),
                    ),
                  );
                });
          }else{
            return CircularProgressIndicator(strokeWidth: 8);
          }
        }
    );


  }
}
