import 'package:absenkuv3/Bloc/Izin/RekapIzinSayaBloc.dart';
import 'package:absenkuv3/Repository/Model/PageModel/mIzinPage.dart';
import 'package:absenkuv3/Repository/Model/mFilter.dart';
import 'package:absenkuv3/Setting/value_image.dart';
import 'package:absenkuv3/UI/Template/DateRangePicker/Bloc/DateRangePickerBloc.dart';
import 'package:absenkuv3/UI/Template/DateRangePicker/UI/templateDateRangePicker.dart';
import 'package:absenkuv3/UI/Template/FilterToggle/UI/templateFilterTogle.dart';
import 'package:flutter/material.dart';
import 'package:flutter_bloc/flutter_bloc.dart';
import 'KomponenIzin.dart';

class HalamanListRekapIzinSaya extends StatefulWidget {
  PageIzinModel? redaksional;
  HalamanListRekapIzinSaya(this.redaksional);

  @override
  _HalamanListRekapIzinSayaState createState() =>
      _HalamanListRekapIzinSayaState();
}

class _HalamanListRekapIzinSayaState extends State<HalamanListRekapIzinSaya> {
  final GlobalKey<ScaffoldState> scaffoldKey = GlobalKey<ScaffoldState>();
  ScrollController _scrollController = new ScrollController();

  @override
  void initState() {
    super.initState();
    BlocProvider.of<DateRangePickerBloc>(context).add(InitialDate());
    BlocProvider.of<RekapIzinSayaBloc>(context)
        .add(getListRekapIzinEvent(context, null));
    _scrollController.addListener(() =>
        BlocProvider.of<RekapIzinSayaBloc>(context)
            .add(loadMoreEvent(context, scaffoldKey, _scrollController)));
  }

  @override
  Widget build(BuildContext context) {
    return Scaffold(
      key: scaffoldKey,
      body: Stack(
        children: [
          BlocBuilder<RekapIzinSayaBloc, RekapIzinSayaState>(
              builder: (BuildContext context, RekapIzinSayaState state) {
            if (state is getListRekapIzinSuccessState ||
                state is LoadMoreProgressState)
              return Stack(
                children: <Widget>[
                  ListView.builder(
                      physics: AlwaysScrollableScrollPhysics(),
                      controller: _scrollController,
                      itemCount: state.data!.length,
                      itemBuilder: (BuildContext context, index) {
                        return CardIzin(
                            state.data![index], 'rekapSaya', scaffoldKey, widget.redaksional!);
                      }),
                  state is LoadMoreProgressState
                      ? Positioned(
                          bottom: 16,
                          child: Container(
                              width: MediaQuery.of(context).size.width,
                              child: Center(
                                  child: CircularProgressIndicator(
                                strokeWidth: 8,
                              ))))
                      : Container(),
                ],
              );
            else if (state is RekapIzinProgressState)
              return Center(
                child: CircularProgressIndicator(
                  strokeWidth: 8,
                ),
              );
            else
              return Center(
                child: Image.asset(
                  ValueImage.noData,
                  height: 250,
                ),
              );
          }),
          Positioned(
            bottom: 16,
            right: 14,
            child: BlocListener<DateRangePickerBloc, DateRangePickerState>(
              listener: (BuildContext context,
                  DateRangePickerState dateRangePickerState) {
                if (dateRangePickerState is DateAvailable)
                  BlocProvider.of<RekapIzinSayaBloc>(context).add(
                      getListRekapIzinEvent(context,
                          ModelFilter(dateRange: dateRangePickerState.date)));
              },
              child: TemplateFilterToggle(),
            ),
          ),
        ],
      ),
    );
  }
}
