import 'package:absenkuv3/Bloc/FilterBottomSheetBloc.dart';
import 'package:absenkuv3/Bloc/Izin/RekapIzinPegawaiBloc.dart';
import 'package:absenkuv3/Repository/Model/PageModel/mIzinPage.dart';
import 'package:absenkuv3/Repository/Model/mFilter.dart';
import 'package:absenkuv3/Setting/value_image.dart';
import 'package:absenkuv3/UI/Template/DateRangePicker/Bloc/DateRangePickerBloc.dart';
import 'package:absenkuv3/UI/Template/FilterBottomSheet.dart';
import 'package:absenkuv3/UI/Template/FilterHeaderSheet.dart';
import 'package:flutter/material.dart';
import 'package:flutter_bloc/flutter_bloc.dart';
import 'KomponenIzin.dart';

// ignore: must_be_immutable
class HalamanListRekapIzinPegawai extends StatefulWidget {
  PageIzinModel? redaksional;
  HalamanListRekapIzinPegawai(this.redaksional);

  @override
  _HalamanListRekapIzinPegawaiState createState() =>
      _HalamanListRekapIzinPegawaiState();
}

class _HalamanListRekapIzinPegawaiState
    extends State<HalamanListRekapIzinPegawai> {
  final GlobalKey<ScaffoldState> scaffoldKey = GlobalKey<ScaffoldState>();
  ScrollController _scrollController = new ScrollController();
  ModelFilter? modelFilter;

  @override
  void initState() {
    super.initState();
    BlocProvider.of<DateRangePickerBloc>(context).add(InitialDate());
    BlocProvider.of<RekapIzinPegawaiBloc>(context)
        .add(getListRekapIzinEvent(context, null));
    _scrollController.addListener(() =>
        BlocProvider.of<RekapIzinPegawaiBloc>(context)
            .add(loadMoreEvent(context, scaffoldKey, _scrollController)));
  }

  @override
  Widget build(BuildContext context) {
    return Scaffold(
      key: scaffoldKey,
      body: Stack(
        children: [
          Column(
            children: [
              Container(
                height: 50,
                width: MediaQuery.of(context).size.width * 1.5,
                child:
                    BlocListener<FilterBottomSheetBloc, FilterBottomSheetState>(
                        listener: (BuildContext context,
                            FilterBottomSheetState state) {
                          if (state is setFilterSuccess) {
                            modelFilter = state.modelFilter;
                            BlocProvider.of<RekapIzinPegawaiBloc>(context).add(
                                getListRekapIzinEvent(context, modelFilter));
                          }
                        },
                        child: FilterHeaderSheet()),
              ),
            ],
          ),
          Padding(
            padding: const EdgeInsets.only(top: 50),
            child: BlocBuilder<RekapIzinPegawaiBloc, RekapIzinPegawaiState>(
                builder: (BuildContext context, RekapIzinPegawaiState state) {
              if (state is getListRekapIzinSuccessState ||
                  state is LoadMoreProgressState)
                return Stack(
                  children: <Widget>[
                    ListView.builder(
                        physics: AlwaysScrollableScrollPhysics(),
                        controller: _scrollController,
                        itemCount: state.data!.length,
                        itemBuilder: (BuildContext context, index) {
                          return CardIzin(
                            state.data![index],
                            'rekapPegawai',
                            scaffoldKey,
                            widget.redaksional!,
                            izinPegawai: true,
                          );
                        }),
                    state is LoadMoreProgressState
                        ? Positioned(
                            bottom: 16,
                            child: Container(
                                width: MediaQuery.of(context).size.width,
                                child: Center(
                                    child: CircularProgressIndicator(
                                  strokeWidth: 8,
                                ))))
                        : Container(),
                  ],
                );
              else if (state is RekapIzinProgressState)
                return Center(
                  child: CircularProgressIndicator(
                    strokeWidth: 8,
                  ),
                );
              else
                return Center(
                  child: Image.asset(
                    ValueImage.noData,
                    height: 250,
                  ),
                );
            }),
          ),
        ],
      ),
    );
  }
}
