import 'package:absenkuv3/Bloc/Cuti/GetDataPeriodeCutiBloc.dart';
import 'package:absenkuv3/Bloc/Izin/DetailIzinBloc.dart';
import 'package:absenkuv3/Bloc/NavigatorBloc.dart';
import 'package:absenkuv3/Bloc/NotifBloc.dart';
import 'package:absenkuv3/Repository/Model/PageModel/mIzinPage.dart';
import 'package:absenkuv3/Repository/sharedPreference.dart';
import 'package:absenkuv3/Setting/PengaturanBahasa.dart';
import 'package:absenkuv3/Setting/value_image.dart';
import 'package:absenkuv3/UI/Template/style.dart';
import 'package:absenkuv3/UI/Template/templateButton.dart';
import 'package:absenkuv3/UI/Template/templateConfirmationDialogV2.dart';
import 'package:flutter/material.dart';
import 'package:flutter/services.dart';
import 'package:flutter_bloc/flutter_bloc.dart';
import '../../../Bloc/Izin/IzinPegawaiBloc.dart';
import '../../../Bloc/Izin/SisaCutiBloc.dart';
import '../../../Repository/Model/mIzin.dart';
import '../../Template/templateConfirmationDialog.dart';
import '../Aktivitas/KomponenAktivitas.dart';
import 'KomponenIzin.dart';

class HalamanDetailIzin extends StatefulWidget {
  final data; //[0] = data, [1] = konteks , [2] = izinPegawai
  HalamanDetailIzin(this.data);

  @override
  _HalamanDetailIzinState createState() => _HalamanDetailIzinState();
}

class _HalamanDetailIzinState extends State<HalamanDetailIzin> {
  GlobalKey<ScaffoldState> scaffoldKey = GlobalKey();
  bool refresh = false;

  @override
  void initState() {
    super.initState();
    BlocProvider.of<DetailIzinBloc>(context)
        .add(GetDetailIzin(widget.data![0]));
    BlocProvider.of<NotifBloc>(context)
        .add(BacaNotif(widget.data![0], 'izin', context));
  }

  Future<bool> keluar() async {
    BlocProvider.of<NavigatorBloc>(context)
        .add(NavigateRemoveToDashboard(context));
    return false;
  }

  Future<bool> keluar2() async {
    if (widget.data[2] == 'notif') {
      Navigator.pop(context, refresh);
    } else {
      BlocProvider.of<NavigatorBloc>(context).add(NavigatePop(context));
    }
    return false;
  }

  @override
  Widget build(BuildContext context) {
    return WillPopScope(
      onWillPop: keluar2,
      child: FutureBuilder<PageIzinModel>(
          future: PengaturanBahasa().izin(),
          builder: (context, snapshot) {
            if (snapshot.connectionState == ConnectionState.done) {
              return BlocListener<NotifBloc, NotifState>(
                listener: (context, stateNotifBloc) {
                  if (stateNotifBloc is SuccessBacaNotifState) {
                    refresh = true;
                  }
                },
                child: Scaffold(
                    key: scaffoldKey,
                    backgroundColor: Colors.white,
                    appBar: AppBar(
                      flexibleSpace: Image(
                        image: AssetImage(ValueImage.headerBiruDashboard),
                        fit: BoxFit.cover,
                      ),
                      backgroundColor: Colors.transparent,
                      centerTitle: true,
                      title: Text(
                        snapshot.data!.menuIzin!.title!.titleDetail!,
                        style: TextStyle(fontSize: CustomStyle.fontSizeTitle),
                      ),
                    ),
                    body: BlocBuilder<DetailIzinBloc, DetailIzinState>(
                        builder: (BuildContext context, DetailIzinState state) {
                      if (state is DetailIzinSuccess) {
                        DataIzin data = state.izinRespon.data![0];
                        return Stack(
                          children: [
                            Container(
                              height: double.infinity,
                              color: Colors.white,
                              margin: EdgeInsets.only(
                                  bottom: widget.data![1] == 'izinPegawai' &&
                                          state.izinRespon.data![0].aksi!
                                      ? 60
                                      : 0),
                              child: SingleChildScrollView(
                                child: Padding(
                                  padding: const EdgeInsets.all(22),
                                  child: Column(
                                    crossAxisAlignment:
                                        CrossAxisAlignment.start,
                                    children: [
                                      Row(
                                        mainAxisAlignment:
                                            MainAxisAlignment.spaceBetween,
                                        children: [
                                          Row(
                                            children: [
                                              Icon(
                                                Icons.calendar_month,
                                                size: 28,
                                              ),
                                              SizedBox(
                                                width: 8,
                                              ),
                                              TemplateColumn(
                                                title:
                                                    "${snapshot.data!.menuIzin!.data!.tanggalPengajuan}",
                                                value: data.tglPengajuan,
                                              ),
                                            ],
                                          ),
                                          TemplateButton(
                                            label: data.jenisIzin!,
                                            color: Color(
                                                int.parse(data.warnaBgIzin!)),
                                            contentColor: Color(
                                                int.parse(data.warnaFontIzin!)),
                                            fontSize: 14,
                                            radius: 2,
                                            paddingTopBottom: 4,
                                            heightButton: 30,
                                            bold: true,
                                            paddingLeftRight: 16,
                                          ),
                                        ],
                                      ),
                                      Text("ini konteks = ${widget.data[1]}"),
                                      SizedBox(
                                        height: 16,
                                      ),
                                      Divider(),
                                      widget.data[1]! == "izinPegawai" ||
                                              widget.data![1] == "rekapPegawai"
                                          ? Column(
                                              crossAxisAlignment:
                                                  CrossAxisAlignment.start,
                                              children: [
                                                Text(
                                                  "${snapshot.data!.menuIzin!.data!.dataKaryawan}",
                                                  style: TextStyle(
                                                      fontSize: 22,
                                                      fontWeight:
                                                          FontWeight.bold),
                                                ),
                                                SizedBox(
                                                  height: 16,
                                                ),
                                                TemplateColumn(
                                                  title:
                                                      "${snapshot.data!.menuIzin!.data!.namaKaryawan}",
                                                  value: data.nama,
                                                ),
                                                SizedBox(
                                                  height: 16,
                                                ),
                                                TemplateColumn(
                                                  title:
                                                      "${snapshot.data!.menuIzin!.data!.jabatan}",
                                                  value: data.jabatan,
                                                ),
                                                SizedBox(
                                                  height: 16,
                                                ),
                                                TemplateColumn(
                                                  title:
                                                      "${snapshot.data!.menuIzin!.data!.cabang}",
                                                  value: data.cabang,
                                                ),
                                                SizedBox(
                                                  height: 16,
                                                ),
                                                TemplateColumn(
                                                  title:
                                                      "${snapshot.data!.menuIzin!.data!.departemen}",
                                                  value: data.departemen,
                                                ),
                                                SizedBox(
                                                  height: 32,
                                                ),
                                                Divider(),
                                                Text(
                                                  "${snapshot.data!.menuIzin!.data!.dataIzin}",
                                                  style: TextStyle(
                                                      fontSize: 22,
                                                      fontWeight:
                                                          FontWeight.bold),
                                                ),
                                                SizedBox(
                                                  height: 16,
                                                ),
                                              ],
                                            )
                                          : Container(),
                                      TemplateColumn(
                                        title:
                                            "${snapshot.data!.menuIzin!.data!.tanggalIzin}",
                                        value: data.tglIzin,
                                      ),
                                      SizedBox(
                                        height: 16,
                                      ),
                                      TemplateColumn(
                                        title:
                                            "${snapshot.data!.menuIzin!.data!.jumlahIzin}",
                                        value:
                                            "${data.jumlahIzin} ${snapshot.data!.menuIzin!.data!.hari}",
                                      ),
                                      SizedBox(
                                        height: 16,
                                      ),
                                      TemplateColumn(
                                        title:
                                            "${snapshot.data!.menuIzin!.data!.namaIzin}",
                                        value: data.namaIzin,
                                      ),
                                      SizedBox(
                                        height: 16,
                                      ),
                                      TemplateColumn(
                                        title:
                                            "${snapshot.data!.menuIzin!.data!.keteranganIzin}",
                                        value: data.ketIzin,
                                      ),
                                      SizedBox(
                                        height: 16,
                                      ),
                                      Text(
                                        "${snapshot.data!.menuIzin!.data!.approval}",
                                        style: TextStyle(
                                            fontSize: 12,
                                            fontWeight: FontWeight.w400,
                                            color: CustomStyle.fontColorGrey),
                                      ),
                                      SizedBox(
                                        height: 8,
                                      ),
                                      Wrap(
                                        spacing: 8,
                                        direction: Axis.vertical,
                                        runSpacing: 4,
                                        children: state
                                            .izinRespon.data![0].listApproval!
                                            .map(
                                              (item) => TemplateButton(
                                                label: item.statusApproval,
                                                color: Color(int.parse(
                                                    item.warnaStatus!)),
                                                heightButton: 24,
                                                radius: 4,
                                                paddingTopBottom: 0,
                                                contentColor: Color(
                                                    int.parse(item.warnaFont!)),
                                                bold: true,
                                              ),
                                            )
                                            .toList(),
                                      ),
                                      SizedBox(
                                        height: 16,
                                      ),
                                      Text(
                                        "${snapshot.data!.menuIzin!.data!.lampiran}",
                                        style: TextStyle(
                                            fontSize: 12,
                                            fontWeight: FontWeight.w400,
                                            color: CustomStyle.fontColorGrey),
                                      ),
                                      SizedBox(
                                        height: 8,
                                      ),
                                      state.izinRespon.data![0].listImage !=
                                                  null &&
                                              state.izinRespon.data![0]
                                                      .listImage!.length >
                                                  0
                                          ? Wrap(
                                              spacing: 8,
                                              runSpacing: 4,
                                              children: state.izinRespon
                                                  .data![0].listImage!
                                                  .map((item) => item.file !=
                                                          '-'
                                                      ? GestureDetector(
                                                          onTap: () => BlocProvider
                                                                  .of<NavigatorBloc>(
                                                                      context)
                                                              .add(NavigateToDetailImageClicked(
                                                                  context,
                                                                  item.file)),
                                                          child: Image.network(
                                                            item.file!,
                                                            width: MediaQuery.of(
                                                                        context)
                                                                    .size
                                                                    .width /
                                                                4,
                                                          ))
                                                      : Container())
                                                  .toList(),
                                            )
                                          : Container(
                                              width: MediaQuery.of(context)
                                                  .size
                                                  .width,
                                              child: Column(
                                                crossAxisAlignment:
                                                    CrossAxisAlignment.center,
                                                children: [
                                                  Icon(
                                                    Icons.image_not_supported,
                                                    color: Colors.grey[500],
                                                    size: MediaQuery.of(context)
                                                            .size
                                                            .width /
                                                        3.2,
                                                  ),
                                                  SizedBox(
                                                    height: 14,
                                                  ),
                                                  Text(
                                                    "${snapshot.data!.menuIzin!.pesanKonfirmasi!.tidakAdaLampiran}",
                                                    style: TextStyle(
                                                        color: CustomStyle
                                                            .fontColorGrey,
                                                        fontSize: CustomStyle
                                                            .fontSizeSmall,
                                                        fontWeight:
                                                            FontWeight.w400),
                                                  )
                                                ],
                                              ),
                                            ),
                                    ],
                                  ),
                                ),
                              ),
                            ),
                            Positioned(
                              bottom: 0,
                              child: widget.data![1] == 'izinPegawai' &&
                                      state.izinRespon.data![0].aksi!
                                  ? Container(
                                      padding:
                                          EdgeInsets.only(left: 22, right: 22),
                                      decoration: BoxDecoration(
                                          boxShadow: [
                                            BoxShadow(
                                              color:
                                                  Colors.grey.withOpacity(0.4),
                                              spreadRadius: 2,
                                              blurRadius: 7,
                                              offset: Offset(0,
                                                  1), // changes position of shadow
                                            ),
                                          ],
                                          color: Colors.white,
                                          borderRadius: new BorderRadius.only(
                                              topLeft: Radius.circular(
                                                  CustomStyle.boxRadius + 4),
                                              topRight: Radius.circular(
                                                  CustomStyle.boxRadius + 4))),
                                      height: 62,
                                      width: MediaQuery.of(context).size.width,
                                      child: Row(
                                        children: <Widget>[
                                          Expanded(
                                            child: TemplateButton(
                                              onClick: () => TemplateConfirmationDialog(
                                                  state.izinRespon.data![0].buttonApprovalHrd!
                                                      ? '${snapshot.data!.menuIzin!.pesanKonfirmasi!.tolakSemua}'
                                                      : '${snapshot.data!.menuIzin!.pesanKonfirmasi!.tolak}',
                                                  () => state
                                                          .izinRespon
                                                          .data![0]
                                                          .buttonApprovalHrd!
                                                      ? BlocProvider.of<IzinPegawaiBloc>(context)
                                                          .add(MewakiliTolakIzin(
                                                              state
                                                                  .izinRespon
                                                                  .data![0]
                                                                  .idIzin,
                                                              context,
                                                              scaffoldKey,
                                                              'detailIzin'))
                                                      : BlocProvider.of<IzinPegawaiBloc>(context)
                                                          .add(tolakIzin(
                                                              state
                                                                  .izinRespon
                                                                  .data![0]
                                                                  .idIzin,
                                                              context,
                                                              scaffoldKey,
                                                              'detailIzin')),
                                                  context),
                                              label: state.izinRespon.data![0]
                                                      .buttonApprovalHrd!
                                                  ? "${snapshot.data!.menuIzin!.button!.tolakSemua}"
                                                  : "${snapshot.data!.menuIzin!.button!.tolak}",
                                              color: Colors.white,
                                              heightButton: 40,
                                              borderColor: Colors.blue,
                                              radius: CustomStyle.boxRadius + 4,
                                              bold: true,
                                              contentColor: Colors.blue,
                                              fontSize:
                                                  CustomStyle.fontSizeSmall - 1,
                                              iconSize: 16,
                                              paddingTopBottom: 0,
                                            ),
                                          ),
                                          SizedBox(
                                            width: 12,
                                          ),
                                          Expanded(
                                            child: TemplateButton(
                                              onClick: () => 
                                              TemplateConfirmationDialogV2(
                                                  state.izinRespon.data![0]
                                                          .buttonApprovalHrd!
                                                      ? '${snapshot.data!.menuIzin!.pesanKonfirmasi!.setujuiSemua}'
                                                      : '${snapshot.data!.menuIzin!.pesanKonfirmasi!.setujui}',
                                                  () => state
                                                          .izinRespon
                                                          .data![0]
                                                          .buttonApprovalHrd!
                                                      ? BlocProvider.of<IzinPegawaiBloc>(
                                                              context)
                                                          .add(MewakiliSetujuiIzin(
                                                              state
                                                                  .izinRespon
                                                                  .data![0]
                                                                  .idIzin,
                                                              context,
                                                              scaffoldKey,
                                                              'detailIzin'))
                                                      : BlocProvider.of<IzinPegawaiBloc>(
                                                              context)
                                                          .add(setujuiIzin(
                                                              state
                                                                  .izinRespon
                                                                  .data![0]
                                                                  .idIzin,
                                                              context,
                                                              scaffoldKey,
                                                              'detailIzin')),
                                                  context,
                                                  icon: Container(
                                                    width: 70,
                                                    height: 70,
                                                    margin: EdgeInsets.only(
                                                        bottom: 15),
                                                    decoration: BoxDecoration(
                                                      border: Border.all(
                                                          color: Colors.blue,
                                                          width: 3),
                                                      shape: BoxShape
                                                          .circle, // Membuat lingkaran
                                                    ),
                                                    child: Icon(
                                                      Icons
                                                          .question_mark_rounded,
                                                      color: Colors
                                                          .blue, // Warna ikon
                                                      size: 40, // Ukuran ikon
                                                    ),
                                                  ),
                                                  addWidget: 
                                                  state.izinRespon.data![0].flag == '1'?
                                                  Column(
                                                    children: [
                                                      SizedBox(
                                                        height: 10,
                                                      ),
                                                      Container(
                                                        padding:
                                                            EdgeInsets.all(10),
                                                        decoration: BoxDecoration(
                                                            borderRadius:
                                                                BorderRadius
                                                                    .circular(
                                                                        5),
                                                            color: CustomStyle
                                                                .colorGreySoft),
                                                        width: MediaQuery.of(
                                                                context)
                                                            .size
                                                            .width,
                                                        child: Column(
                                                          children: [
                                                            Row(
                                                              mainAxisAlignment:
                                                                  MainAxisAlignment
                                                                      .spaceBetween,
                                                              children: [
                                                                Expanded(
                                                                  child: Text(
                                                                      '${snapshot.data!.menuIzin!.data!.jumlahIzin}',
                                                                      style: TextStyle(
                                                                          fontSize:
                                                                              CustomStyle.fontSizeNormal -
                                                                                  1,color: CustomStyle.colorGreyDop)),
                                                                ),
                                                                Text(
                                                                    '${state.izinRespon.data![0].jumlahIzin}',
                                                                    style: TextStyle(
                                                                        fontSize:
                                                                            CustomStyle.fontSizeNormal -
                                                                                1))
                                                              ],
                                                            ),
                                                            SizedBox(
                                                              height: 7,
                                                            ),
                                                            BlocProvider<
                                                                SisaCutiBloc>(
                                                              create:
                                                                  (context) {
                                                                return SisaCutiBloc(
                                                                    SisaCutiProgress());
                                                              },
                                                              child: WidgetSisaCutiV2(
                                                                  state
                                                                      .izinRespon
                                                                      .data![0]
                                                                      .idKaryawan,
                                                                  snapshot
                                                                      .data!
                                                                      .menuIzin!
                                                                      .data!
                                                                      .infoSisaCutiKaryawan),
                                                            ),
                                                            SizedBox(
                                                              height: 7,
                                                            ),
                                                            BlocProvider<
                                                                GetDataPeriodeCutiBloc>(
                                                              create:
                                                                  (context) {
                                                                return GetDataPeriodeCutiBloc(
                                                                    GetDataPeriodeCutiProggres());
                                                              },
                                                              child: WidgetPeriodeCuti(
                                                                  state
                                                                      .izinRespon
                                                                      .data![0]
                                                                      .idKaryawan,
                                                                  snapshot
                                                                      .data!
                                                                      .menuIzin!
                                                                      .data!
                                                                      .infoCutiBerlakuHingga),
                                                            ),
                                                          ],
                                                        ),
                                                      ),
                                                      SizedBox(
                                                        height: 10,
                                                      ),
                                                    ],
                                                  ):Container()),
                                              
                                              label: state.izinRespon.data![0]
                                                      .buttonApprovalHrd!
                                                  ? "${snapshot.data!.menuIzin!.button!.setujuiSemua}"
                                                  : "${snapshot.data!.menuIzin!.button!.setujui}",
                                              color: CustomStyle.color1,
                                              heightButton: 40,
                                              radius: CustomStyle.boxRadius + 4,
                                              // icon: Icons.check,
                                              bold: true,
                                              fontSize:
                                                  CustomStyle.fontSizeSmall - 1,
                                              iconSize: 16,
                                              paddingTopBottom: 0,
                                            ),
                                          ),
                                        ],
                                      ),
                                    )
                                  : Container(),
                            )
                          ],
                        );
                      } else if (state is DetailIzinProgress)
                        return Container(
                            height: MediaQuery.of(context).size.height,
                            child: Center(
                                child: CircularProgressIndicator(
                              strokeWidth: 8,
                            )));
                      else
                        return Container();
                    })),
              );
            } else {
              return CircularProgressIndicator(strokeWidth: 8);
            }
          }),
    );
  }
}

class TemplateColumn extends StatelessWidget {
  final String? title;
  final String? value;
  TemplateColumn({super.key, this.title, this.value});

  @override
  Widget build(BuildContext context) {
    return Column(
      crossAxisAlignment: CrossAxisAlignment.start,
      children: [
        Text(
          title!,
          style: TextStyle(
              fontSize: 12,
              fontWeight: FontWeight.w400,
              color: CustomStyle.fontColorGrey),
        ),
        SizedBox(
          height: 8,
        ),
        Text(
          value!,
          style: TextStyle(
              fontSize: 12,
              fontWeight: FontWeight.w600,
              color: CustomStyle.fontColorBlack),
        ),
      ],
    );
  }
}
