import 'package:absenkuv3/Bloc/Dropdown/Akun/DropdownProvinsiBloc.dart';
import 'package:absenkuv3/Setting/PengaturanBahasa.dart';
import 'package:absenkuv3/UI/Template/style.dart';
import 'package:flutter/material.dart';
import 'package:flutter_bloc/flutter_bloc.dart';
import 'package:shimmer/shimmer.dart';

// ignore: must_be_immutable
class DropdownJenisProvinsi extends StatefulWidget {
  String title;
  var color;
  double fontSize;
  String? initialData;
  double? formHeight;
  bool validasi;
  double marginHorizontal;
  double marginTop;
  DropdownJenisProvinsi(this.title,
      {this.initialData,
      this.color = Colors.grey,
      this.fontSize = 14,
      this.formHeight,
      this.validasi = false,
      this.marginHorizontal = 0,
      this.marginTop = 11});

  @override
  _DropdownJenisProvinsiState createState() => _DropdownJenisProvinsiState();
}

class _DropdownJenisProvinsiState extends State<DropdownJenisProvinsi> {
  TextEditingController _controller = TextEditingController();
  GlobalKey dropdownKey = GlobalKey();

  @override
  void initState() {
    super.initState();
    BlocProvider.of<DropdownProvinsiBloc>(context)
        .add(GetDataDropdownProvinsi());
    // if (widget.initialData != null) {
    //   _controller.text = widget.initialData!;
    // }
  }

  @override
  Widget build(BuildContext context) {
    if (widget.initialData != null) {
      _controller.text = widget.initialData!;
    }
    return WillPopScope(
      onWillPop: () async {
        Navigator.pop(dropdownKey.currentContext!);
        return false;
      },
      child: Container(
        margin: EdgeInsets.only(
            bottom: 12,
            top: widget.marginTop,
            right: widget.marginHorizontal,
            left: widget.marginHorizontal),
        child: Column(
          crossAxisAlignment: CrossAxisAlignment.start,
          children: [
            BlocBuilder<DropdownProvinsiBloc, DropdownProvinsiState>(
              builder: (BuildContext context, DropdownProvinsiState state) {
                if (state is DropdownProvinsiSuccessState){
                  // print("masuk dropdown");
                  return Container(
                    child: DropdownMenu(
                      key: dropdownKey,
                      enableSearch: false,
                      dropdownMenuEntries:
                      state.dropdownRespon.data!.map((item) {
                        return DropdownMenuEntry(
                            value: item, label: item.nama!);
                      }).toList(),
                      inputDecorationTheme: InputDecorationTheme(
                        contentPadding: EdgeInsets.symmetric(vertical: 7.0),
                        enabledBorder: UnderlineInputBorder(
                            borderSide: BorderSide(
                                color: CustomStyle.colorLineFormDropdown)),
                      ),
                      controller: _controller,
                      onSelected: (value) =>
                          BlocProvider.of<DropdownProvinsiBloc>(context)
                              .add(SelectDataDropdownProvinsi(value!)),
                      label: Row(
                        children: [
                          Text(widget.title,
                              style: TextStyle(
                                  fontSize:_controller.text.isEmpty?widget.fontSize:17,
                                  fontWeight: FontWeight.w400)),
                          SizedBox(width: 7),
                          Text('*',
                              style: TextStyle(
                                  color: Colors.red,
                                  fontSize: _controller.text.isEmpty?widget.fontSize:17)),
                        ],
                      ),
                      textStyle: TextStyle(fontSize: 13),
                      requestFocusOnTap: false,
                      width: MediaQuery.of(context).size.width - 50,
                    ),
                  );
                }else if(state is DropdownProvinsiSetValueSuccessState){
                  // print('masuk set value');
                  return Container(
                    child: DropdownMenu(
                      key: dropdownKey,
                      enableSearch: false,
                      dropdownMenuEntries:
                      state.dropdownRespon.data!.map((item) {
                        return DropdownMenuEntry(
                            value: item, label: item.nama!);
                      }).toList(),
                      inputDecorationTheme: InputDecorationTheme(
                        contentPadding: EdgeInsets.symmetric(vertical: 7.0),
                        enabledBorder: UnderlineInputBorder(
                            borderSide: BorderSide(
                                color: CustomStyle.colorLineFormDropdown)),
                      ),
                      controller: _controller,
                      onSelected: (value) =>
                          BlocProvider.of<DropdownProvinsiBloc>(context)
                              .add(SelectDataDropdownProvinsi(value!)),
                      label: Row(
                        children: [
                          Text(widget.title,
                              style: TextStyle(
                                  fontSize: widget.fontSize,
                                  fontWeight: FontWeight.w400)),
                          SizedBox(width: 7),
                          Text('*',
                              style: TextStyle(
                                  color: Colors.red,
                                  fontSize: widget.fontSize)),
                        ],
                      ),
                      textStyle: TextStyle(fontSize: 13),
                      requestFocusOnTap: false,
                      width: MediaQuery.of(context).size.width - 50,
                    ),
                  );
                }
                else
                  return Container(
                    height: widget.formHeight ?? CustomStyle.formHeight,
                    width: MediaQuery.of(context).size.width,
                    child: Shimmer.fromColors(
                      baseColor: Colors.grey[200]!,
                      highlightColor: Colors.white,
                      period: Duration(seconds: 4),
                      child: Card(),
                    ),
                  );
              },
            ),
          ],
        ),
      ),
    );
  }
}
