import 'package:absenkuv3/Bloc/Dropdown/Akun/DropdownKelurahanBloc.dart';
import 'package:absenkuv3/Repository/Model/Akun/mDataDiri.dart';
import 'package:absenkuv3/UI/Template/style.dart';
import 'package:flutter/material.dart';
import 'package:flutter_bloc/flutter_bloc.dart';

// ignore: must_be_immutable
class DropdownJenisKelurahan extends StatefulWidget {
  String title;
  var color;
  double fontSize;
  JenisData? initialData;
  double? formHeight;
  bool validasi;
  double marginHorizontal;
  double marginTop;
  String? idKac;
  DropdownJenisKelurahan(this.title,
      {this.initialData,
      this.color = Colors.grey,
      this.fontSize = 14,
      this.formHeight,
      this.validasi = false,
      this.marginHorizontal = 0,
        this.marginTop = 11,
      this.idKac});

  @override
  _DropdownJenisKelurahanState createState() => _DropdownJenisKelurahanState();
}

class _DropdownJenisKelurahanState extends State<DropdownJenisKelurahan> {
  TextEditingController _controller = TextEditingController();

  @override
  void initState() {
    // TODO: implement initState
    super.initState();
    // BlocProvider.of<DropdownKelurahanBloc>(context).add(GetDataDropdownKelurahan());
    // if (widget.initialData != null) {
    //   _controller.text = widget.initialData!.nama!;
    //   BlocProvider.of<DropdownKelurahanBloc>(context)
    //       .add(SetKecamatan(widget.idKac!, widget.initialData));
    // }
  }

  @override
  Widget build(BuildContext context) {
    if (widget.initialData != null) {
      _controller.text = widget.initialData!.nama!;
      // BlocProvider.of<DropdownKelurahanBloc>(context)
      //     .add(SetKecamatan(widget.idKac!, widget.initialData));
    }
    return Container(
      margin: EdgeInsets.only(
          bottom: 12,
          top: 11,
          left: widget.marginHorizontal,
          right: widget.marginHorizontal),
      child: BlocBuilder<DropdownKelurahanBloc, DropdownKelurahanState>(
        builder: (BuildContext context, DropdownKelurahanState state) {
          if (state is DropdownKelurahanSuccessState) {
            if (state.selectedValue == null) {
              _controller.text = "";
            }else{
              _controller.text = state.selectedValue!.nama!;
            }
            return Container(
              child: DropdownMenu(
                enableSearch: false,
                dropdownMenuEntries: state.dropdownRespon.data!.map((item) {
                  return DropdownMenuEntry(value: item, label: item.nama!);
                }).toList(),
                inputDecorationTheme: InputDecorationTheme(
                  contentPadding: EdgeInsets.symmetric(vertical: 7.0),
                  enabledBorder: UnderlineInputBorder(
                      borderSide:
                          BorderSide(color: CustomStyle.colorLineFormDropdown)),
                  disabledBorder: UnderlineInputBorder(
                      borderSide:
                          BorderSide(color: CustomStyle.colorLineFormDropdown)),
                ),
                controller: _controller,
                onSelected: (value) =>
                    BlocProvider.of<DropdownKelurahanBloc>(context)
                        .add(SelectDataDropdownKelurahan(value!)),
                label: Row(
                  children: [
                    Text(widget.title,
                        style: TextStyle(
                            fontSize: _controller.text.isEmpty?widget.fontSize:17,
                            fontWeight: FontWeight.w400)),
                    SizedBox(width: 7),
                    Text('*',
                        style: TextStyle(
                            color: !widget.validasi ? Colors.white : Colors.red, fontSize: _controller.text.isEmpty?widget.fontSize:17)),
                  ],
                ),
                textStyle: TextStyle(fontSize: 13),
                requestFocusOnTap: false,
                width: MediaQuery.of(context).size.width - 50,
              ),
            );
          } else {
            _controller.clear();
            return Container(
              child: DropdownMenu(
                dropdownMenuEntries: [],
                inputDecorationTheme: InputDecorationTheme(
                  contentPadding: EdgeInsets.symmetric(vertical: 7.0),
                  enabledBorder: UnderlineInputBorder(
                      borderSide:
                      BorderSide(color: CustomStyle.colorLineFormDropdown)),
                  disabledBorder: UnderlineInputBorder(
                      borderSide:
                      BorderSide(color: CustomStyle.colorLineFormDropdown)),
                ),
                controller: _controller,
                enabled: false,
                // onSelected: (value)=>BlocProvider.of<DropdownKabupatenBloc>(context).add(SelectDataDropdownKabupaten(value!)),
                label: Row(
                  children: [
                    Text(widget.title,
                        style: TextStyle(
                            fontSize: widget.fontSize,
                            fontWeight: FontWeight.w400)),
                    SizedBox(width: 7),
                    Text('*',
                        style: TextStyle(
                            color: !widget.validasi ? Colors.white : Colors
                                .red, fontSize: widget.fontSize)),
                  ],
                ),
                textStyle: TextStyle(fontSize: 13),
                requestFocusOnTap: true,
                width: MediaQuery
                    .of(context)
                    .size
                    .width - 50,
              ),
            );
          }
        },
      ),
    );
  }
}
