import 'package:absenkuv3/Bloc/Akun/NotifikasiAkunBloc.dart';
import 'package:absenkuv3/Bloc/AuthBloc.dart';
import 'package:absenkuv3/Bloc/Badge/BadgeNotificationDashboardBloc.dart';
import 'package:absenkuv3/Bloc/Dashboard/DashboardBloc.dart';
import 'package:absenkuv3/Bloc/JamKerja/JamKerjaBloc.dart';
import 'package:absenkuv3/Bloc/NavigatorBloc.dart';
import 'package:absenkuv3/Bloc/PengaturanBloc.dart';
import 'package:absenkuv3/Bloc/SlipGaji/SlipGajiBloc.dart' as slip;
import 'package:absenkuv3/Bloc/SplashScreenBloc.dart';
import 'package:absenkuv3/Bloc/Summary/HadirBloc.dart';
import 'package:absenkuv3/Bloc/Summary/SisaCutiBloc.dart';
import 'package:absenkuv3/Bloc/Summary/SummaryIzinBloc.dart';
import 'package:absenkuv3/Repository/Model/PageModel/mButtonPage.dart';
import 'package:absenkuv3/Repository/Model/PageModel/mDashboardPage.dart';
import 'package:absenkuv3/Repository/Model/mBadge.dart';
import 'package:absenkuv3/Repository/Model/mLogin.dart';
import 'package:absenkuv3/Setting/PengaturanBahasa.dart';
import 'package:absenkuv3/Setting/value_image.dart';
import 'package:absenkuv3/UI/Modul/MonitorAbsensi/MonitorAbsensiDashboard/MonitorAbsensiDashboard.dart';
import 'package:absenkuv3/UI/Template/templateButton.dart';
import 'package:absenkuv3/UI/Template/templateFormPassword.dart';
import 'package:absenkuv3/UI/Template/verticalDivider.dart';
import 'package:flutter/material.dart';
import 'package:flutter_bloc/flutter_bloc.dart';
import '../../Template/style.dart';
import 'komponenDashboard.dart';

class HalamanDashboard extends StatefulWidget {
  @override
  _HalamanDashboardState createState() => _HalamanDashboardState();
}

class _HalamanDashboardState extends State<HalamanDashboard> {
  GlobalKey<ScaffoldState> scaffoldKey = GlobalKey();
  List<Widget> menuDashboard = <Widget>[];
  JumlahBadge? jumlahBadge;

  @override
  void initState() {
    super.initState();
    BlocProvider.of<BadgeNotificationDashboardBloc>(context)
        .add(GetBadgeNotificationDashboard(context));
    BlocProvider.of<AuthBloc>(context)
        .add(GetUserDataTerkiniEvent(context, scaffoldKey));
    BlocProvider.of<JamKerjaBloc>(context).add(getJamKerjaEvent(context));
    // BlocProvider.of<SummaryBloc>(context)
    //     .add(GetDataSummaryDashboardEvent(context));
    BlocProvider.of<HadirBloc>(context)
        .add(GetDataHadirDashboardEvent(context));
    BlocProvider.of<SummaryIzinBloc>(context)
        .add(GetDataIzinDashboardEvent(context));
    BlocProvider.of<SisaCutiDashboardBloc>(context)
        .add(GetDataSisaCutiDashboardEvent(context));
    // BlocProvider.of<badgeShift.BadgeShiftBloc>(context)
    //     .add(badgeShift.GetBadgeShift(context, scaffoldKey));
    BlocProvider.of<PengaturanBloc>(context)
        .add(GetPengaturan(context, scaffoldKey));
    BlocProvider.of<DashboardBloc>(context)
        .add(GetDataDashboard(context, scaffoldKey));
    // BlocProvider.of<SplashScreenBloc>(context).add(VersionAppEvent(context));
    BlocProvider.of<NotifikasiAkunBloc>(context)
        .add(getBadgeAkunEvent(context));

  }

  @override
  Widget build(BuildContext context) {
    return Scaffold(
        key: scaffoldKey,
        backgroundColor: CustomStyle.backgroundColor,
        body: FutureBuilder<PageDashboardModel>(
            future: PengaturanBahasa().dashboard(),
            builder: (context, snapshot){
              // if(snapshot.connectionState == ConnectionState.done){
              return BlocBuilder<AuthBloc, LoginRespon>(
                builder: (context, state) {
                  
                  // buildMenuDashboard(state, snapshot.data == null ? MenuUtama() : snapshot.data!.menuBeranda!.menuUtama!);
                  return Container(
                    height: MediaQuery.of(context).size.height - 50,
                    child: SingleChildScrollView(
                      child: Stack(
                        children: [
                          Container(
                            height: 400,
                            width: MediaQuery.of(context).size.width,
                            child: Stack(
                              children: [
                                Column(
                                  children: <Widget>[
                                    Container(
                                      width: double.infinity,
                                      height: MediaQuery.of(context).size.height / 2.5,
                                      child: Image.asset(
                                        ValueImage.headerBiruDashboard,
                                        fit: BoxFit.fitWidth,
                                      ),
                                    ),
                                    Expanded(
                                      child: Container(
                                        height: MediaQuery.of(context).size.height / 3,
                                        color: CustomStyle.backgroundDashboardColor,
                                        // color: Colors.orange,
                                      ),
                                    ),
                                  ],
                                ),
                                
                                Container(
                                    margin: EdgeInsets.only(
                                        top: MediaQuery.of(context).size.height / 6.7),
                                    padding: EdgeInsets.all(12),
                                    height: 90,
                                    width: MediaQuery.of(context).size.width,
                                    child: Center(child:
                                    BlocBuilder<DashboardBloc, DashboardState>(
                                      builder:
                                          (BuildContext context, DashboardState state) {
                                        if (state is GetSuccess &&
                                            state.dataDashboard!.logo != '-')
                                          return Image.network(
                                              state.dataDashboard!.logo!);
                                        else
                                          return Image.asset(
                                            ValueImage.logoDashboard,
                                          );
                                      },
                                    ))),
                              ],
                            ),
                          ),
                          SafeArea(
                            child: Container(
                              padding: const EdgeInsets.fromLTRB(12, 12, 12, 16),
                              child: Column(
                                crossAxisAlignment: CrossAxisAlignment.start,
                                children: <Widget>[
                                  GestureDetector(
                                    onTap: () => BlocProvider.of<NavigatorBloc>(context)
                                        .add(NavigateToHalamanAkun(context)),
                                    child: Row(
                                      children: <Widget>[
                                        Stack(
                                          children: [
                                            Container(
                                              decoration: new BoxDecoration(
                                                  color: Colors.white,
                                                  borderRadius: new BorderRadius.all(
                                                      Radius.circular(120.0))),
                                              child: ClipRRect(
                                                  borderRadius:
                                                  BorderRadius.circular(120.0),
                                                  child: state.dataLogin != null &&
                                                      state.dataLogin!.foto != '-' &&
                                                      state.dataLogin!.foto != null
                                                      ? Image.network(
                                                    state.dataLogin!.foto!,
                                                    height: 64,
                                                    width: 64,
                                                    fit: BoxFit.cover,
                                                    errorBuilder: (c, obj, st) {
                                                      return Padding(
                                                        padding:
                                                        const EdgeInsets.all(8.0),
                                                        child: Icon(
                                                          Icons.person,
                                                          color: Colors.grey[400],
                                                          size: 48,
                                                        ),
                                                      );
                                                    },
                                                  )
                                                      : Padding(
                                                    padding:
                                                    const EdgeInsets.all(8.0),
                                                    child: Icon(
                                                      Icons.person,
                                                      color: Colors.grey[400],
                                                      size: 48,
                                                    ),
                                                  )),
                                            ),
                                            BlocBuilder<NotifikasiAkunBloc, NotifikasiAkunState>(
                                                builder: (BuildContext context, NotifikasiAkunState se) {
                                                  if(se is getBadgeAkunSuccessState){
                                                    jumlahBadge = se.dataBadge;
                                                  }
                                                  return jumlahBadge==null || jumlahBadge!.data == 0
                                                      ? Container()
                                                      : Positioned(
                                                    right: 0,
                                                    top: 0,
                                                    child: Container(
                                                      child: Center(
                                                        child: Text(
                                                          jumlahBadge!.data.toString(),
                                                          style: TextStyle(
                                                              color: Colors.white),
                                                        ),
                                                      ),
                                                      decoration: new BoxDecoration(
                                                        color: Colors.red,
                                                        shape: BoxShape.circle,
                                                      ),
                                                      height: MediaQuery.of(context)
                                                          .size
                                                          .width *
                                                          0.05,
                                                      width: MediaQuery.of(context)
                                                          .size
                                                          .width *
                                                          0.05,
                                                    ),
                                                  );
                                                }
                                            ),

                                          ],
                                        ),
                                        SizedBox(
                                          width: 12,
                                        ),
                                        Expanded(
                                          child: Column(
                                            crossAxisAlignment:
                                            CrossAxisAlignment.start,
                                            children: <Widget>[
                                              Text(
                                                // ignore: unnecessary_null_comparison
                                                state != null && state.dataLogin != null
                                                    ? state.dataLogin!.namaUser!
                                                    : '',
                                                style: TextStyle(
                                                    fontSize:
                                                    CustomStyle.fontSizeSubTitle,
                                                    fontWeight: FontWeight.bold,
                                                    color: Colors.white),
                                                maxLines: 2,
                                                overflow: TextOverflow.ellipsis,
                                              ),
                                              SizedBox(
                                                height: 2,
                                              ),
                                              Text(
                                                // ignore: unnecessary_null_comparison
                                                state != null && state.dataLogin != null
                                                    ? state.dataLogin!.namaJabatan!
                                                    : '',
                                                style: TextStyle(
                                                    fontSize: CustomStyle.fontSizeSmall,
                                                    color: Colors.white),
                                              ),
                                            ],
                                          ),
                                        ),
                                        GestureDetector(
                                          onTap: () {
                                            BlocProvider.of<NavigatorBloc>(context)
                                                .add(NavigateToNotif(context));
                                          },
                                          child: Stack(
                                            children: [
                                              Row(
                                                children: [
                                                  Container(
                                                    padding: EdgeInsets.only(top: 5),
                                                    child: GestureDetector(
                                                        onTap: () {
                                                          BlocProvider.of<
                                                              NavigatorBloc>(
                                                              context)
                                                              .add(NavigateToNotif(
                                                              context));
                                                        },
                                                        child: Image.asset(
                                                          ValueImage.iconNotif,
                                                          width: 25,
                                                          height: 25,
                                                          color: Colors.white,
                                                        )),
                                                  ),
                                                  SizedBox(
                                                    width: 5,
                                                  )
                                                ],
                                              ),
                                              BlocBuilder<BadgeNotificationDashboardBloc,
                                                  BadgeNotificationDashboardState>(
                                                  builder: (context, state) {
                                                    if (state is GetBadgeNotificationDashboardSuccess) {
                                                      return Positioned(
                                                        right: 0,
                                                        top: 0,
                                                        child: Container(
                                                          child: Center(
                                                            child: Text(
                                                              state.dataDashboard!.data
                                                                  .toString(),
                                                              style: TextStyle(
                                                                  color: Colors.white),
                                                            ),
                                                          ),
                                                          decoration: new BoxDecoration(
                                                            color: Colors.red,
                                                            shape: BoxShape.circle,
                                                          ),
                                                          height: MediaQuery.of(context)
                                                              .size
                                                              .width *
                                                              0.05,
                                                          width: MediaQuery.of(context)
                                                              .size
                                                              .width *
                                                              0.05,
                                                        ),
                                                      );
                                                    }
                                                    return Positioned(
                                                      right: 0,
                                                      top: 0,
                                                      child: Container(
                                                        height: MediaQuery.of(context)
                                                            .size
                                                            .width *
                                                            0.05,
                                                        width: MediaQuery.of(context)
                                                            .size
                                                            .width *
                                                            0.05,
                                                      ),
                                                    );
                                                  }),
                                            ],
                                          ),
                                        ),
                                      ],
                                    ),
                                  ),
                                  
                                  SizedBox(
                                    height: 134,
                                  ),
                                  ConstrainedBox(
                                    constraints: BoxConstraints(minHeight: 199),
                                    child: Container(
                                        width: MediaQuery.of(context).size.width,
                                        padding: EdgeInsets.fromLTRB(16, 16, 16, 20),
                                        decoration: CustomStyle.boxDecoration,
                                        child: BlocBuilder<JamKerjaBloc, JamKerjaState>(
                                            builder: (BuildContext context,
                                                JamKerjaState state) {
                                              if (state is getJamKerjaSuccessState)
                                                return Column(
                                                  children: <Widget>[
                                                    Row(
                                                      children: <Widget>[
                                                        Icon(
                                                          Icons.watch_later,
                                                          color: Colors.grey[500],
                                                          size: 40,
                                                        ),
                                                        SizedBox(
                                                          width: 10,
                                                        ),
                                                        Expanded(
                                                          child: Column(
                                                            crossAxisAlignment:
                                                            CrossAxisAlignment.start,
                                                            children: <Widget>[
                                                              Text(
                                                                state.data!.jadwalKerja ==
                                                                    'Shift'
                                                                    ? "${state.data!.jamKerja!.kodeAbsensi} - ${state.data!.jamKerja!.keterangan}"
                                                                    : state
                                                                    .data!.jadwalKerja!,
                                                                style: TextStyle(
                                                                    fontSize: CustomStyle
                                                                        .fontSizeSmall),
                                                              ),
                                                              state.data!.dataAbsensi !=
                                                                  null
                                                                  ? Row(
                                                                mainAxisAlignment:
                                                                MainAxisAlignment
                                                                    .spaceBetween,
                                                                children: <Widget>[
                                                                  state.data!.jamKerja !=
                                                                      null
                                                                      ? Text(
                                                                    '${state.data!.jamKerja!.jamMasuk} - ${state.data!.jamKerja!.jamPulang}',
                                                                    style: TextStyle(
                                                                        fontSize:
                                                                        CustomStyle
                                                                            .fontSizeSmall,
                                                                        fontWeight:
                                                                        FontWeight.bold),
                                                                  )
                                                                      : Container(),
                                                                ],
                                                              )
                                                                  : Container(),
                                                              SizedBox(
                                                                height: 4,
                                                              ),
                                                              state.data!.dataAbsensi !=
                                                                  null
                                                                  ? Text(
                                                                snapshot.data == null ? "" : "${snapshot.data!.menuBeranda!.rekapAbsensiBulanIni!.dataRekap!.masuk} : ${state.data!.dataAbsensi!.absenMasuk}",
                                                                style: TextStyle(
                                                                    fontSize: CustomStyle
                                                                        .fontSizeSmall -
                                                                        1,
                                                                    color: CustomStyle
                                                                        .color1,
                                                                    fontWeight:
                                                                    FontWeight
                                                                        .w600),
                                                              )
                                                                  : Container(),
                                                            ],
                                                          ),
                                                        ),
                                                        state.data!.jamKerja != null
                                                            ? Column(
                                                          crossAxisAlignment:
                                                          CrossAxisAlignment
                                                              .start,
                                                          children: [
                                                            Text(
                                                              state.data!.jamKerja!
                                                                  .tanggal!
                                                                  .split(',')[0]
                                                                  .trim(),
                                                              style: TextStyle(
                                                                  fontSize: CustomStyle
                                                                      .fontSizeNormal,
                                                                  fontWeight:
                                                                  FontWeight.bold,
                                                                  color: CustomStyle
                                                                      .fontColorBlack),
                                                            ),
                                                            Text(
                                                              state.data!.jamKerja!
                                                                  .tanggal!
                                                                  .split(',')[1]
                                                                  .trim(),
                                                              style: TextStyle(
                                                                  fontSize: CustomStyle
                                                                      .fontSizeSmall,
                                                                  fontWeight:
                                                                  FontWeight.bold,
                                                                  color: CustomStyle
                                                                      .fontColorGrey),
                                                            ),
                                                            SizedBox(
                                                              height: 4,
                                                            ),
                                                            state.data!.dataAbsensi !=
                                                                null
                                                                ? Text(
                                                              snapshot.data == null ? "" : "${snapshot.data!.menuBeranda!.rekapAbsensiBulanIni!.dataRekap!.pulang} : ${state.data!.dataAbsensi!.absenPulang}",
                                                              style: TextStyle(
                                                                  fontSize:
                                                                  CustomStyle.fontSizeSmall -
                                                                      1,
                                                                  color:
                                                                  CustomStyle
                                                                      .color1,
                                                                  fontWeight:
                                                                  FontWeight
                                                                      .w600),
                                                            )
                                                                : Container(),
                                                          ],
                                                        )
                                                            : Container(),
                                                      ],
                                                    ),
                                                    Row(
                                                      mainAxisAlignment:
                                                      MainAxisAlignment.spaceBetween,
                                                      children: [],
                                                    ),
                                                    
                                                    SizedBox(
                                                      height: 4,
                                                    ),
                                                    Divider(
                                                      thickness: 1,
                                                    ),
                                                    SizedBox(
                                                      height: 8,
                                                    ),
                                                    Text(
                                                      snapshot.data == null ? "" : snapshot.data!.menuBeranda!.rekapAbsensiBulanIni!.title!,
                                                      style: TextStyle(
                                                          fontSize:
                                                          CustomStyle.fontSizeNormal,
                                                          fontWeight: FontWeight.w600,
                                                          color:
                                                          CustomStyle.fontColorBlack),
                                                    ),
                                                    SizedBox(
                                                      height: 16,
                                                    ),
                                                    Row(
                                                      mainAxisAlignment:
                                                      MainAxisAlignment
                                                          .center,
                                                      children: [
                                                        BlocBuilder<HadirBloc,
                                                            HadirState>(
                                                            builder:
                                                                (context, state) {
                                                              if (state
                                                              is getHadirDashboardSuccessState) {
                                                                return templateKehadiran(
                                                                  snapshot.data == null ? "" : snapshot
                                                                      .data!
                                                                      .menuBeranda!
                                                                      .rekapAbsensiBulanIni!
                                                                      .dataRekap!
                                                                      .hadir!,
                                                                  "${state.data!.hadir} ${snapshot.data == null ? "" : snapshot.data!.menuBeranda!.rekapAbsensiBulanIni!.dataRekap!.hari}",
                                                                  1.0,
                                                                  Colors.green,
                                                                  valueFontSize:
                                                                  CustomStyle
                                                                      .fontSizeSmall +
                                                                      1,
                                                                  action: true,
                                                                  onClick: (){
                                                                    BlocProvider.of<NavigatorBloc>(context).add(
                                                                  NavigateToHalamanListMonitor(context, ['H',DateTime.now()]));
                                                                  },
                                                                );
                                                              } else
                                                                return templateShimmerDashboard();
                                                            }),
                                                        VerticalDividerAbsenku(),
                                                        BlocBuilder<
                                                            SummaryIzinBloc,
                                                            IzinSummaryState>(
                                                            builder:
                                                                (context, state) {
                                                              if (state
                                                              is getIzinDashboardSuccessState) {
                                                                return templateKehadiran(
                                                                  snapshot.data == null ? "" :
                                                                  snapshot
                                                                      .data!
                                                                      .menuBeranda!
                                                                      .rekapAbsensiBulanIni!
                                                                      .dataRekap!
                                                                      .izin!,
                                                                  "${state.data!.izinSakitCuti} ${snapshot.data == null ? "" : snapshot.data!.menuBeranda!.rekapAbsensiBulanIni!.dataRekap!.hari}",
                                                                  1.0,
                                                                  Colors
                                                                      .lightBlueAccent,
                                                                  valueFontSize:
                                                                  CustomStyle
                                                                      .fontSizeSmall +
                                                                      1,
                                                                  action: true,
                                                                  onClick: (){
                                                                    BlocProvider.of<NavigatorBloc>(context).add(
                                                                        NavigateToHalamanListMonitorIzin(context, ['',DateTime.now()]));
                                                                  },
                                                                );
                                                              } else
                                                                return templateShimmerDashboard();
                                                            }),
                                                        VerticalDividerAbsenku(),
                                                        BlocBuilder<
                                                            SisaCutiDashboardBloc,
                                                            SisaCutiState>(
                                                            builder:
                                                                (context, state) {
                                                              if (state
                                                              is getSisaCutiDashboardSuccessState) {
                                                                return templateKehadiran(
                                                                  snapshot.data == null ? "" :
                                                                  snapshot
                                                                      .data!
                                                                      .menuBeranda!
                                                                      .rekapAbsensiBulanIni!
                                                                      .dataRekap!
                                                                      .sisaCuti!,
                                                                  "${state.data!.sisaCuti} ${snapshot.data == null ? "" : snapshot.data!.menuBeranda!.rekapAbsensiBulanIni!.dataRekap!.hari}",
                                                                  1.0,
                                                                  titleFontSize: 12.5,
                                                                  Colors.orange,
                                                                  valueFontSize:
                                                                  CustomStyle.fontSizeSmall + 1,
                                                                  action: true,
                                                                  onClick: (){
                                                                    BlocProvider.of<NavigatorBloc>(context).add(
                                                                        NavigateToHalamanCuti(context));
                                                                  },
                                                                );
                                                              } else
                                                                return templateShimmerDashboard();
                                                            }),
                                                      ],
                                                    )
                                                    // BlocBuilder<SummaryBloc, SummaryState>(
                                                    //   builder: (BuildContext context,
                                                    //       SummaryState state) {
                                                    //     if (state
                                                    //     is getSummaryDashboardSuccessState)
                                                    //       return Row(
                                                    //         children: <Widget>[
                                                    //           templateKehadiran(
                                                    //             snapshot.data == null ? "" : snapshot.data!.menuBeranda!.rekapAbsensiBulanIni!.dataRekap!.hadir!,
                                                    //             "${state.data!.hadir} ${ snapshot.data == null ? "" : snapshot.data!.menuBeranda!.rekapAbsensiBulanIni!.dataRekap!.hari}",
                                                    //             1.0,
                                                    //             Colors.green,
                                                    //             valueFontSize: CustomStyle
                                                    //                 .fontSizeSmall +
                                                    //                 1,
                                                    //           ),
                                                    //           VerticalDividerAbsenku(),
                                                    //           templateKehadiran(
                                                    //             snapshot.data == null ? "" : snapshot.data!.menuBeranda!.rekapAbsensiBulanIni!.dataRekap!.izin!,
                                                    //             "${state.data!.izinSakitCuti} ${ snapshot.data == null ? "" : snapshot.data!.menuBeranda!.rekapAbsensiBulanIni!.dataRekap!.hari}",
                                                    //             1.0,
                                                    //             Colors.lightBlueAccent,
                                                    //             valueFontSize: CustomStyle
                                                    //                 .fontSizeSmall +
                                                    //                 1,
                                                    //           ),
                                                    //           VerticalDividerAbsenku(),
                                                    //           templateKehadiran(
                                                    //             snapshot.data == null ? "" : snapshot.data!.menuBeranda!.rekapAbsensiBulanIni!.dataRekap!.sisaCuti!,
                                                    //             "${state.data!.sisaCuti} ${ snapshot.data == null ? "" : snapshot.data!.menuBeranda!.rekapAbsensiBulanIni!.dataRekap!.hari}",
                                                    //             1.0,
                                                    //             Colors.orangeAccent,
                                                    //             valueFontSize: CustomStyle
                                                    //                 .fontSizeSmall +
                                                    //                 1,
                                                    //           ),
                                                    //         ],
                                                    //       );
                                                    //     else
                                                    //       return Center(
                                                    //         child:
                                                    //         CircularProgressIndicator(
                                                    //           strokeWidth: 8,
                                                    //         ),
                                                    //       );
                                                    //   },
                                                    // ),
                                                  ],
                                                );
                                              else
                                                return Center(
                                                  child: CircularProgressIndicator(
                                                    strokeWidth: 8,
                                                  ),
                                                );
                                            })),
                                  ),
                                  SizedBox(
                                    height: 28,
                                  ),
                                  Text(
                                    snapshot.data == null ? "" : snapshot.data!.menuBeranda!.menuUtama!.title!,
                                    style: TextStyle(
                                        fontSize: CustomStyle.fontSizeSubTitle,
                                        fontWeight: FontWeight.bold),
                                  ),
                                  SizedBox(
                                    height: 16,
                                  ),
                                  Wrap(
                                    runSpacing: 24,
                                    spacing: 20,
                                    children: menuDashboard,
                                  ),
                                  SizedBox(
                                    height: 24,
                                  ),
                                  Container(
                                    width: double.infinity,
                                    child: Column(
                                      children: [
                                        buildAbsensiHariIni(
                                            state,
                                            snapshot.data == null ? KomponenTambahan() :
                                            snapshot
                                                .data!
                                                .menuBeranda!
                                                .dataKomponenTambahan!
                                                .dataKomponen!)
                                      ],
                                    ),
                                  )
                                ],
                              ),
                            ),
                          ),
                        ],
                      ),
                    ),
                  );
                },
              );
            }
          // else{
          //   return Center(
          //     child: CircularProgressIndicator(
          //       strokeWidth: 8,
          //     ),
          //   );
          // }
          // }
        )
    );
  }

  buildMenuDashboard(LoginRespon state, MenuUtama menu) {
    menuDashboard.clear();
    if (state.dataLogin!.komponenMobile![0] == '1')
      menuDashboard.add(templateMenu(
          menu.data == null ? "" : menu.data!.izin,
          ValueImage.iconIzin,
              () => BlocProvider.of<NavigatorBloc>(context)
              .add(NavigateToListIzin(context))));
    if (state.dataLogin!.komponenMobile![1] == '1')
      menuDashboard.add(templateMenu(
          menu.data == null ? "" : menu.data!.lembur,
          ValueImage.iconLembur,
              () => BlocProvider.of<NavigatorBloc>(context)
              .add(NavigateToListLembur(context))));

    if (state.dataLogin!.komponenMobile![2] == '1')
      menuDashboard.add(BlocBuilder<PengaturanBloc, PengaturanState>(
          builder: (context, snapshot) {
            if (snapshot is GetSuccessPengaturan && (state.dataLogin!.level == 3 || state.dataLogin!.level == 7))
              return Stack(
                children: [
                  templateMenu(
                      menu.data == null ? "" : menu.data!.shift,
                      ValueImage.iconShift,
                          () => BlocProvider.of<NavigatorBloc>(context).add(NavigateToTukarShift(context))),
                ],
              );
            else
              return templateMenu(
                  menu.data == null ? "" : menu.data!.shift,
                  ValueImage.iconShift,
                      () => BlocProvider.of<NavigatorBloc>(context)
                      .add(NavigateToShift(context)));
          }));
    if (state.dataLogin!.komponenMobile![3] == '1')
      menuDashboard.add(templateMenu(
          menu.data == null ? "" : menu.data!.reimbursement,
          ValueImage.iconReimburse,
              () => BlocProvider.of<NavigatorBloc>(context)
              .add(NavigateToMainReimbursement(context))));
    if (state.dataLogin!.komponenMobile![4] == '1')
      menuDashboard.add(templateMenu(
          menu.data == null ? "" : menu.data!.infoGaji,
          ValueImage.iconGaji,
              () => BlocProvider.of<NavigatorBloc>(context)
              .add(NavigateToGaji(context))));
    if (state.dataLogin!.komponenMobile![5] == '1')
      menuDashboard.add(templateMenu(
          menu.data == null ? "" : menu.data!.aktivitas,
          ValueImage.iconAktivitas,
              () => BlocProvider.of<NavigatorBloc>(context)
              .add(NavigateToListAktivitas(context))));
    if (state.dataLogin!.komponenMobile![6] == '1')
      menuDashboard.add(templateMenu(
          menu.data == null ? "" : menu.data!.berita,
          ValueImage.iconBerita,
              () => BlocProvider.of<NavigatorBloc>(context)
              .add(NavigateToListBerita(context))));
    if (state.dataLogin!.komponenMobile!.length > 7) {
      if (state.dataLogin!.komponenMobile![7] == '1')
        menuDashboard.add(templateMenu(
            menu.data == null ? "" : menu.data!.slipGaji,
            ValueImage.iconSlipGaji,
                () => BlocProvider.of<NavigatorBloc>(context)
                .add(NavigateToSlipGaji(context, ['data']))
          // () => openDialogSlipGaji()

        ));
    }
    if (state.dataLogin!.komponenMobile![8] == '1'){
      if(state.dataLogin!.isSales == "1" || state.dataLogin!.adminAtasan!){
        menuDashboard.add(templateMenu(
            menu.data == null ? "" : "Sales Monitoring",
            ValueImage.iconSales,
                () => BlocProvider.of<NavigatorBloc>(context)
                .add(NavigateToSalesActivityPage(context))));
      }
    }
if (state.dataLogin!.komponenMobile != null &&
        state.dataLogin!.komponenMobile!.length > 10) {
      if (state.dataLogin!.komponenMobile![10] == '1') {
        menuDashboard.add(templateMenu(
          menu.data == null ? "" : "KPI",
          ValueImage.iconKpi,
          () => BlocProvider.of<NavigatorBloc>(context)
              .add(NavigateToHalamanKpi(context)),
        ));
      }
    } else {
      print('komponenMobile tidak memiliki index ke-10');
    }
    if (state.dataLogin!.komponenMobile != null &&
        state.dataLogin!.komponenMobile!.length > 11) {
      if (state.dataLogin!.komponenMobile![11] == '1') {
        menuDashboard.add(templateMenu(
          menu.data == null ? "" :menu.data!.patroli,
          ValueImage.iconCheckpoint,
          () => BlocProvider.of<NavigatorBloc>(context)
              .add(NavigateToPatroli(context)),
        ));
      }
    } else {
      print('komponenMobile tidak memiliki index ke-11');
    }
    if (state.dataLogin!.komponenMobile != null &&
        state.dataLogin!.komponenMobile!.length > 12) {
      if (state.dataLogin!.komponenMobile![12] == '1') {
        menuDashboard.add(templateMenu(
          menu.data == null ? "" : "SOS",
          ValueImage.iconSos,
          () => BlocProvider.of<NavigatorBloc>(context)
              .add(NavigateToHalamanPengajuanSos(context)),
        ));
      }
    } else {
      print('komponenMobile tidak memiliki index ke-12');
    }
  }

  buildAbsensiHariIni(LoginRespon state, KomponenTambahan komponenTambahan) {
    if (state.dataLogin!.level != 3) {
      return Container(
        child: Column(
          crossAxisAlignment: CrossAxisAlignment.start,
          children: [
            Text(komponenTambahan.absensi_hari_ini??'',
                style: TextStyle(
                  fontSize: CustomStyle.fontSizeSubTitle,
                  fontWeight: FontWeight.bold,
                )),
            MonitorAbsensiDashboard(),
            SizedBox(
              height: 30,
            )
          ],
        ),
      );
    } else {
      return Container();
    }
  }

  // openDialog() {
  //   BlocProvider.of<GajiBloc>(context).add(InitPasswordEvent());
  //   TextEditingController password = new TextEditingController();
  //   showDialog(
  //       context: context,
  //       builder: (BuildContext context) {
  //         return AlertDialog(
  //           shape: RoundedRectangleBorder(
  //               borderRadius:
  //                   BorderRadius.all(Radius.circular(CustomStyle.boxRadius))),
  //           content: Column(
  //             mainAxisSize: MainAxisSize.min,
  //             children: [
  //               Container(
  //                 padding: const EdgeInsets.only(bottom: 12, top: 6),
  //                 width: MediaQuery.of(context).size.width,
  //                 child: SingleChildScrollView(
  //                   child: Column(
  //                     crossAxisAlignment: CrossAxisAlignment.start,
  //                     children: [
  //                       TemplateFormPassword(
  //                         hintText: "Password",
  //                         controller: password,
  //                         color: CustomStyle.formColor,
  //                         radius: CustomStyle.formRadius,
  //                         formHeight: CustomStyle.formHeight,
  //                         titleText: "Password",
  //                       ),
  //                       BlocBuilder<GajiBloc, GajiState>(
  //                           builder: (BuildContext context, GajiState state) {
  //                         if (state is CekPasswordFalseState)
  //                           return Text(
  //                             state.message!,
  //                             style: TextStyle(
  //                                 fontSize: CustomStyle.fontSizeSmall,
  //                                 color: Colors.redAccent),
  //                           );
  //                         else
  //                           return Container();
  //                       })
  //                     ],
  //                   ),
  //                 ),
  //               ),
  //               Row(
  //                 mainAxisAlignment: MainAxisAlignment.spaceBetween,
  //                 children: [
  //                   TemplateButton(
  //                     onClick: () => BlocProvider.of<NavigatorBloc>(context)
  //                         .add(NavigatePop(context)),
  //                     label: "Tutup",
  //                     color: Colors.transparent,
  //                     contentColor: CustomStyle.color1,
  //                     fontSize: CustomStyle.fontSizeNormal,
  //                     bold: true,
  //                   ),
  //                   TemplateButton(
  //                     onClick: () => BlocProvider.of<GajiBloc>(context)
  //                         .add(CekPasswordEvent(context, password.text)),
  //                     label: "Masuk",
  //                     color: Colors.transparent,
  //                     contentColor: CustomStyle.color1,
  //                     fontSize: CustomStyle.fontSizeNormal,
  //                     bold: true,
  //                   )
  //                 ],
  //               )
  //             ],
  //           ),
  //         );
  //       });
  // }

  openDialogSlipGaji() {
    BlocProvider.of<slip.SlipGajiBloc>(context).add(slip.InitPasswordEvent());
    TextEditingController password = new TextEditingController();
    showDialog(
        context: context,
        builder: (BuildContext context) {
          return AlertDialog(
            shape: RoundedRectangleBorder(
                borderRadius:
                    BorderRadius.all(Radius.circular(CustomStyle.boxRadius))),
            content: Column(
              mainAxisSize: MainAxisSize.min,
              children: [
                Container(
                  padding: const EdgeInsets.only(bottom: 12, top: 6),
                  width: MediaQuery.of(context).size.width,
                  child: SingleChildScrollView(
                    child: Column(
                      crossAxisAlignment: CrossAxisAlignment.start,
                      children: [
                        TemplateFormPassword(
                          hintText: "Password",
                          controller: password,
                          color: CustomStyle.formColor,
                          radius: CustomStyle.formRadius,
                          formHeight: CustomStyle.formHeight,
                          titleText: "Password",
                        ),
                        BlocBuilder<slip.SlipGajiBloc, slip.SlipGajiState>(
                            builder: (BuildContext context,
                                slip.SlipGajiState state) {
                          if (state is slip.CekPasswordFalseState)
                            return Text(
                              state.message!,
                              style: TextStyle(
                                  fontSize: CustomStyle.fontSizeSmall,
                                  color: Colors.redAccent),
                            );
                          else
                            return Container();
                        })
                      ],
                    ),
                  ),
                ),
                FutureBuilder<PageButtonModel>(
                    future: PengaturanBahasa().button(),
                    builder: (context, snapshot) {
                      return Row(
                        mainAxisAlignment: MainAxisAlignment.spaceBetween,
                        children: [
                          TemplateButton(
                            onClick: () => BlocProvider.of<NavigatorBloc>(context)
                                .add(NavigatePop(context)),
                            label: snapshot.data == null ? "" : snapshot.data!.button!.btnTutup,
                            color: Colors.transparent,
                            contentColor: CustomStyle.color1,
                            fontSize: CustomStyle.fontSizeNormal,
                            bold: true,
                          ),
                          TemplateButton(
                            onClick: () => BlocProvider.of<slip.SlipGajiBloc>(context)
                                .add(slip.CekPasswordEvent(context, password.text)),
                            label: snapshot.data == null ? "" : snapshot.data!.button!.btnMasuk,
                            color: Colors.transparent,
                            contentColor: CustomStyle.color1,
                            fontSize: CustomStyle.fontSizeNormal,
                            bold: true,
                          )
                        ],
                      );
                    }
                )
              ],
            ),
          );
        });
  }

  Widget templateMenu(label, String image, var onClick) {
    return GestureDetector(
      onTap: onClick,
      child: Container(
        width: MediaQuery.of(context).size.width / 5.4,
        child: Column(
          crossAxisAlignment: CrossAxisAlignment.center,
          children: <Widget>[
            Container(
              padding: EdgeInsets.all(5),
              decoration: CustomStyle.boxDecoration,
              child: Center(
                child: Image.asset(
                  "$image",
                  fit: BoxFit.contain,
                ),
              ),
            ),
            SizedBox(
              height: 8,
            ),
            Text(
              label,
              maxLines: 2,
              overflow: TextOverflow.ellipsis,
              style: TextStyle(
                  fontSize: CustomStyle.fontSizeNormal - 1,
                  color: Colors.grey[700]),
              textAlign: TextAlign.center,
            )
          ],
        ),
      ),
    );
  }

}
