import 'package:flutter/material.dart';

class HalamanDashboard extends StatelessWidget {
  const HalamanDashboard({super.key});

  Future<void> _onRefresh() async {
    // Tambahkan logika refresh di sini, misal memanggil API atau Bloc
    await Future.delayed(const Duration(seconds: 1));
  }

  @override
  Widget build(BuildContext context) {
    final absensi = [
      {"hari": "Selasa", "tgl": "15 Jun 2025", "masuk": "08.40", "pulang": "17.05"},
      {"hari": "Senin", "tgl": "14 Jun 2025", "lupa": true},
      {"hari": "Minggu", "tgl": "13 Jun 2025", "libur": true},
      {"hari": "Sabtu", "tgl": "12 Jun 2025", "libur": true},
      {"hari": "Jumat", "tgl": "11 Jun 2025", "masuk": "08.40", "pulang": "17.05"},
      {"hari": "Kamis", "tgl": "10 Jun 2025", "masuk": "08.40", "pulang": "17.05"},
    ];

    return Scaffold(
      body: SafeArea(
        child: RefreshIndicator(
          onRefresh: _onRefresh,
          child: SingleChildScrollView(
            physics: const AlwaysScrollableScrollPhysics(),
            child: Column(
              crossAxisAlignment: CrossAxisAlignment.start,
              children: [
                // Header User
                Padding(
                  padding: const EdgeInsets.all(16),
                  child: Column(
                    children: [
                      Row(
                        children: const [
                          CircleAvatar(radius: 24, backgroundColor: Colors.grey),
                          SizedBox(width: 12),
                          Column(
                            crossAxisAlignment: CrossAxisAlignment.start,
                            children: [
                              Text("Giri Lukisantoso, SH", style: TextStyle(fontWeight: FontWeight.bold)),
                              Text("UND-1083-10", style: TextStyle(color: Colors.grey)),
                            ],
                          ),
                        ],
                      ),
                      const SizedBox(height: 16),
                      Container(
                        padding: const EdgeInsets.symmetric(horizontal: 16, vertical: 12),
                        decoration: BoxDecoration(
                          color: Colors.blue.shade700,
                          borderRadius: BorderRadius.circular(12),
                        ),
                        child: Row(
                          mainAxisAlignment: MainAxisAlignment.spaceBetween,
                          children: const [
                            Text("Rabu\n16 Jun 2025", style: TextStyle(color: Colors.white)),
                            Text("Total Kehadiran\n14 Hari", style: TextStyle(color: Colors.white)),
                          ],
                        ),
                      ),
                    ],
                  ),
                ),

                // Tombol Absen Masuk & Pulang
                Padding(
                  padding: const EdgeInsets.all(16),
                  child: Row(
                    children: [
                      Expanded(
                        child: Card(
                          child: ListTile(
                            leading: const Icon(Icons.login, color: Colors.green),
                            title: const Text("Absen Masuk"),
                            trailing: const Icon(Icons.arrow_forward, color: Colors.green),
                            onTap: () {},
                          ),
                        ),
                      ),
                      const SizedBox(width: 8),
                      Expanded(
                        child: Card(
                          child: ListTile(
                            leading: const Icon(Icons.logout, color: Colors.red),
                            title: const Text("Absen Pulang"),
                            trailing: const Icon(Icons.arrow_forward, color: Colors.red),
                            onTap: () {},
                          ),
                        ),
                      ),
                    ],
                  ),
                ),

                // Menu Utama
                Padding(
                  padding: const EdgeInsets.symmetric(horizontal: 16),
                  child: Row(
                    mainAxisAlignment: MainAxisAlignment.spaceBetween,
                    children: [
                      _buildMenu(Icons.assignment, "Kegiatan"),
                      _buildMenu(Icons.timer, "Lembur"),
                      _buildMenu(Icons.qr_code_scanner, "Patroli"),
                      _buildMenu(Icons.edit_note, "Lupa Absen"),
                    ],
                  ),
                ),

                const SizedBox(height: 24),

                // Data Absensi Anda
                Padding(
                  padding: const EdgeInsets.symmetric(horizontal: 16),
                  child: Row(
                    mainAxisAlignment: MainAxisAlignment.spaceBetween,
                    children: const [
                      Text("Data Absensi Anda", style: TextStyle(fontWeight: FontWeight.bold)),
                      Text("Lihat Semua", style: TextStyle(color: Colors.blue)),
                    ],
                  ),
                ),

                const SizedBox(height: 8),

                ListView.builder(
                  shrinkWrap: true,
                  physics: const NeverScrollableScrollPhysics(),
                  itemCount: absensi.length,
                  itemBuilder: (context, index) {
                    final item = absensi[index];
                    return Padding(
                      padding: const EdgeInsets.symmetric(horizontal: 16),
                      child: Card(
                        child: ListTile(
                          title: Text("${item["hari"]}, ${item["tgl"]}"),
                          subtitle: item["libur"] == true
                              ? const Text("Hari Libur", style: TextStyle(color: Colors.grey))
                              : item["lupa"] == true
                                  ? TextButton(
                                      onPressed: () {},
                                      child: const Text("Ajukan Lupa Absen"),
                                    )
                                  : Row(
                                      mainAxisAlignment: MainAxisAlignment.spaceBetween,
                                      children: [
                                        Text("Masuk: ${item["masuk"]}"),
                                        Text("Pulang: ${item["pulang"]}"),
                                      ],
                                    ),
                        ),
                      ),
                    );
                  },
                ),

                const SizedBox(height: 24),
              ],
            ),
          ),
        ),
      ),
    );
  }

  Widget _buildMenu(IconData icon, String label) {
    return Column(
      children: [
        CircleAvatar(
          backgroundColor: Colors.blue.shade50,
          child: Icon(icon, color: Colors.blue),
        ),
        const SizedBox(height: 4),
        Text(label, style: const TextStyle(fontSize: 12)),
      ],
    );
  }
}
