import 'package:absenkuv3/Repository/Model/Cuti/mDataHistoryCuti.dart';
import 'package:flutter/material.dart';
import 'package:flutter/widgets.dart';

class CardTitleCuti extends StatelessWidget {
  String Title;
  String Subtitle;
  String Total;
  Function() OnClick;
  var ColorDecor;
  CardTitleCuti(
      {required this.Title,
      required this.Subtitle,
      required this.Total,
      required this.ColorDecor,
      required this.OnClick});

  @override
  Widget build(BuildContext context) {
    return Container(
      padding: EdgeInsets.fromLTRB(20, 10, 20, 10),
      child: GestureDetector(
        onTap: OnClick,
        child: Container(
          // Tambahkan Container di sini
          color: Colors.transparent, // Pastikan area ini dapat menerima klik
          child: Row(
            mainAxisAlignment: MainAxisAlignment.spaceBetween,
            children: [
              Expanded(
                // Gunakan Expanded untuk mengisi ruang
                child: Column(
                  crossAxisAlignment: CrossAxisAlignment.start,
                  children: [
                    FittedBox(
                      child: Text(
                        Title,
                        style: TextStyle(
                          fontWeight: FontWeight.bold,
                          color: Colors.black,
                        ),
                      ),
                    ),
                    SizedBox(height: 5),
                    FittedBox(
                      child: Text(
                        Subtitle,
                        style: TextStyle(
                          fontWeight: FontWeight.w300,
                          color: Colors.grey,
                        ),
                      ),
                    ),
                  ],
                ),
              ),
              Container(
                child: Row(
                  children: [
                    Container(
                      padding: EdgeInsets.all(8),
                      decoration: BoxDecoration(
                        color: ColorDecor,
                        borderRadius: BorderRadius.circular(15),
                      ),
                      child: Text(
                        Total,
                        style: TextStyle(color: Colors.white),
                      ),
                    ),
                    Container(
                      margin: EdgeInsets.only(left: 5),
                      child: Icon(
                        Icons.arrow_forward_ios_sharp,
                        size: 20,
                        color: Colors.black,
                      ),
                    )
                  ],
                ),
              )
            ],
          ),
        ),
      ),
    );
  }
}

// ignore_for_file: camel_case_types, prefer_typing_uninitialized_variables
class ListHistoryCuti extends StatelessWidget {
  DataHistoryCuti data;
  bool kurang;
  ListHistoryCuti(this.data, this.kurang);

  @override
  Widget build(BuildContext context) {
    return Container(
      padding: EdgeInsets.only(left: 22, right: 22, top: 5, bottom: 10),
      child: Column(
        crossAxisAlignment: CrossAxisAlignment.start,
        children: [
          Container(
            child: Row(
              mainAxisAlignment: MainAxisAlignment.spaceBetween,
              children: [
                Text(data.tglTrx.toString(),
                    style:
                        TextStyle(fontWeight: FontWeight.bold, fontSize: 16)),
                Text(
                  kurang ? data.kurang.toString() : data.tambah.toString(),
                  style: TextStyle(
                      fontWeight: FontWeight.bold,
                      fontSize: 16,
                      color: kurang ? Colors.red : Colors.green),
                ),
              ],
            ),
          ),
          SizedBox(
            height: 8,
          ),
          Text(
            data.keterangan.toString(),
            style: TextStyle(fontSize: 15, color: Colors.grey),
          ),
          Divider()
        ],
      ),
    );
  }
}
