import 'package:absenkuv3/Bloc/NavigatorBloc.dart';
import 'package:absenkuv3/UI/Template/MultiImagePicker/Bloc/MultiImagePickerBloc.dart';
import 'package:absenkuv3/UI/Template/style.dart';
import 'package:cached_network_image/cached_network_image.dart';
import 'package:flutter/material.dart';
import 'package:flutter_bloc/flutter_bloc.dart';
import 'package:photo_view/photo_view.dart';
import '../../../Bloc/AuthBloc.dart';

class DetailImageClickedAkun extends StatelessWidget {
  final String? imageUrl;
  DetailImageClickedAkun(this.imageUrl);
  final GlobalKey<ScaffoldState> scaffoldKey = GlobalKey<ScaffoldState>();
  @override
  Widget build(BuildContext context) {
    return Scaffold(
      key: scaffoldKey,
      // appBar: AppBar(
      //   backgroundColor: Colors.black,
      //   title: Row(children: [
      //     Expanded(child: Text("Foto profil",)),
      //   GestureDetector(
      //       onTap: ()=>BlocProvider.of<MultiImagePickerBloc>(context).add(PickImageSingle(context, false)),
      //       child: Icon(Icons.edit, color: Colors.white,))
      // ],),),
      body: Stack(
        children: [
          Container(
              child: PhotoView(
            imageProvider: CachedNetworkImageProvider(imageUrl!),
          )),
          Container(
            padding: EdgeInsets.fromLTRB(14, 10, 14, 16),
            color: Colors.black,
            width: double.infinity,
            child: SafeArea(
              child: Row(
                children: [
                  GestureDetector(
                      onTap: () => BlocProvider.of<NavigatorBloc>(context)
                          .add(NavigatePop(context)),
                      child: Icon(
                        Icons.chevron_left,
                        color: Colors.white,
                        size: 30,
                      )),
                  SizedBox(
                    width: 18,
                  ),
                  Expanded(
                      child: Text(
                    "Foto profil",
                    style: TextStyle(
                        fontSize: CustomStyle.fontSizeHeader,
                        color: Colors.white,
                        fontWeight: FontWeight.w700),
                  )),
                  BlocListener<MultiImagePickerBloc, MultiImagePickerState>(
                    listener:
                        (BuildContext context, MultiImagePickerState state) {
                      if (state is MultiImageSuccessState)
                        BlocProvider.of<AuthBloc>(context).add(
                            UploadFotoProfilEvent(state.listData[0].base64,
                                context, scaffoldKey));
                    },
                    child: GestureDetector(
                        onTap: () =>
                            BlocProvider.of<MultiImagePickerBloc>(context)
                                .add(PickImageSingle(context, false)),
                        child: Icon(
                          Icons.edit,
                          color: Colors.white,
                          size: 22,
                        )),
                  ),
                ],
              ),
            ),
          )
        ],
      ),
    );
  }
}
