import 'package:absenkuv3/Bloc/NavigatorBloc.dart';
import 'package:absenkuv3/Repository/Model/Akun/mKontakPegawai.dart';
import 'package:absenkuv3/Repository/Model/PageModel/mDataKontakPegawaiPage.dart';
import 'package:absenkuv3/Setting/value_image.dart';
import 'package:absenkuv3/UI/Template/style.dart';
import 'package:flutter/material.dart';
import 'package:flutter/services.dart';
import 'package:flutter_bloc/flutter_bloc.dart';
import 'package:url_launcher/url_launcher.dart';

class HalamanDetailKontakPegawai extends StatelessWidget {
  var data;
  HalamanDetailKontakPegawai(this.data);

  @override
  Widget build(BuildContext context) {
    final DataKontak dataKontakPegawai = data[0];
    final MenuDataKontakPegawai? redaksional = data[1];
    return Scaffold(
      appBar: AppBar(
        title: Text(redaksional!.detailTitle.toString(), style: TextStyle(fontSize: CustomStyle.fontSizeTitle),),
        centerTitle: true,
        flexibleSpace: Image(
          image: AssetImage(ValueImage.headerBiruDashboard),
          fit: BoxFit.cover,
        ),
        actions: const [],
      ),
      body: SingleChildScrollView(
        child: Container(
          color: Colors.white,
          child: Column(
            mainAxisAlignment: MainAxisAlignment.start,
            crossAxisAlignment: CrossAxisAlignment.center,
            children: [
              SizedBox(
                height: 10,
              ),
              Center(
                  child: Column(
                children: [
                  GestureDetector(
                      child: Container(
                        height: 200,
                        width: 200,
                        decoration: BoxDecoration(
                          border: Border.all(color: Colors.grey.shade100),
                          borderRadius: BorderRadius.circular(120.0),
                        ),
                        child: ClipRRect(
                          borderRadius: BorderRadius.circular(120.0),
                          child: Container(
                              child: dataKontakPegawai.foto != '-'
                                  ? Image.network(
                                      dataKontakPegawai.foto!,
                                      height: 200,
                                      width: 200,
                                      fit: BoxFit.cover,
                                      errorBuilder: (c, obj, st) {
                                        return Image.asset(
                                          ValueImage.iconUserEmpty,
                                          fit: BoxFit.fill,
                                        );
                                      },
                                    )
                                  : Image.asset(
                                      ValueImage.iconUserEmpty,
                                      fit: BoxFit.fill,
                                    )),
                        ),
                      ),
                      onTap: () => BlocProvider.of<NavigatorBloc>(context).add(
                          NavigateToDetailImageClicked(
                              context, dataKontakPegawai.foto))),
                  SizedBox(
                    height: 15,
                  ),
                  Text(dataKontakPegawai.namaLengkap.toString(),
                      style: TextStyle(
                          fontSize: 18,
                          fontWeight: FontWeight.bold,
                          color: Color(0XFF353535))),
                  SizedBox(
                    height: 5,
                  ),
                  Text(dataKontakPegawai.nik.toString(),
                      style: TextStyle(
                          fontSize: 14,
                          fontWeight: FontWeight.w400,
                          color: Colors.blue)),
                ],
              )),
              SizedBox(
                height: 30,
              ),
              Container(
                color: Color(0XFFF5F6F8),
                width: MediaQuery.of(context).size.width,
                height: 10,
              ),
              ListTile(
                dense: true,
                leading: CircleAvatar(
                    backgroundColor: Colors.transparent,
                    child: Image.asset(
                      ValueImage.iconTelpV2,
                      height: 30,
                    )),
                title: Text(redaksional.data!.no_telepon.toString(),
                    style:
                        TextStyle(fontSize: 12, fontWeight: FontWeight.w400)),
                subtitle: Text(dataKontakPegawai.telepon.toString(),
                    style:
                        TextStyle(fontSize: 14, fontWeight: FontWeight.w600)),
                trailing: Wrap(
                  children: <Widget>[
                    dataKontakPegawai.buttonWa == true
                        ? Wrap(
                            spacing: 0,
                            runSpacing: 0,
                            children: [
                              IconButton(
                                icon: Icon(Icons.copy_sharp),
                                onPressed: () {
                                  Clipboard.setData(new ClipboardData(
                                          text: dataKontakPegawai.telepon
                                              .toString()))
                                      .then((value) => {
                                            ScaffoldMessenger.of(context)
                                                .showSnackBar(
                                              SnackBar(
                                                content: Text(redaksional
                                                    .data!.copyMessageNomor
                                                    .toString()),
                                                backgroundColor: Colors.blue,
                                              ),
                                            )
                                          });
                                },
                              ),
                              IconButton(
                                icon: Image.asset(
                                  ValueImage.iconWhatsapp,
                                  height: 30,
                                ),
                                onPressed: () async {
                                  Uri url = Uri.parse(
                                      dataKontakPegawai.linkTelepon.toString());
                                  if (!await launchUrl(url,
                                      mode: LaunchMode.externalApplication)) {
                                    throw Exception('Could not launch $url');
                                  }
                                },
                              )
                            ],
                          )
                        : const Icon(
                            Icons.developer_board,
                            size: 24.0,
                            color: Colors.transparent,
                          ),
                  ],
                ),
              ),
              Divider(),
              ListTile(
                dense: true,
                leading: CircleAvatar(
                    backgroundColor: Colors.transparent,
                    child: Image.asset(ValueImage.iconEmailV2, height: 30)),
                title: Text(redaksional.data!.email.toString(),
                    style:
                        TextStyle(fontSize: 12, fontWeight: FontWeight.w400)),
                subtitle: Text(dataKontakPegawai.email.toString(),
                    style:
                        TextStyle(fontSize: 14, fontWeight: FontWeight.w600)),
                trailing: dataKontakPegawai.buttonEmail == true
                    ? IconButton(
                        icon: Icon(Icons.copy_sharp),
                        onPressed: () {
                          Clipboard.setData(new ClipboardData(
                                  text: dataKontakPegawai.email.toString()))
                              .then((value) => {
                                    ScaffoldMessenger.of(context).showSnackBar(
                                      SnackBar(
                                        content: Text(redaksional
                                            .data!.copyMessage
                                            .toString()),
                                        backgroundColor: Colors.blue,
                                      ),
                                    )
                                  });
                        },
                      )
                    : const Icon(
                        Icons.developer_board,
                        size: 24.0,
                        color: Colors.transparent,
                      ),
              ),
            ],
          ),
        ),
      ),
    );
  }
}
