import 'package:absenkuv3/Bloc/Akun/StatusPengajuanDataBloc.dart';
import 'package:absenkuv3/Bloc/AuthBloc.dart';
import 'package:absenkuv3/Bloc/NavigatorBloc.dart';
import 'package:absenkuv3/Repository/Model/Akun/mStatusPengajuan.dart';
import 'package:absenkuv3/Repository/Model/PageModel/mDataPendidikanPage.dart';
import 'package:absenkuv3/Repository/Model/mLogin.dart';
import 'package:absenkuv3/Setting/PengaturanBahasa.dart';
import 'package:absenkuv3/Setting/value_image.dart';
import 'package:absenkuv3/UI/Modul/Akun/DataPendidikan/HalamanDataPendidikanPengajuan.dart';
import 'package:absenkuv3/UI/Modul/Akun/DataPendidikan/HalamanDataPendidikanTerverifikasi.dart';
import 'package:absenkuv3/UI/Template/style.dart';
import 'package:flutter/material.dart';
import 'package:flutter_bloc/flutter_bloc.dart';

// ignore: must_be_immutable
class ParentTabDataPendidikan extends StatefulWidget {
  var initialIndex;

  ParentTabDataPendidikan(this.initialIndex);

  @override
  _ParentTabDataPendidikanState createState() => _ParentTabDataPendidikanState();
}

class _ParentTabDataPendidikanState extends State<ParentTabDataPendidikan> {
  int tabLength = 2;
  StatusPengajuanDataRespon? dataStatusPengajuan;

  Future<bool> keluar() async {
    Navigator.pop(context);
    BlocProvider.of<NavigatorBloc>(context)
        .add(NavigateToRepaceHalamanAkun(context));
    return false;
  }

  @override
  void initState() {
    super.initState();
    BlocProvider.of<StatusPengajuanDataBloc>(context).add(getStatusPengajuanDataEvent(context));
  }


  @override
  Widget build(BuildContext context) {
    return WillPopScope(
      onWillPop: keluar,
      child: FutureBuilder<PageDataPendidikanModel>(
        future: PengaturanBahasa().dataPendidikan(),
        builder: (context, snapshot) {
          if(snapshot.connectionState == ConnectionState.done){
            return BlocBuilder<StatusPengajuanDataBloc, StatusPengajuanDataState>(
                builder: (BuildContext context, StatusPengajuanDataState state) {
                  if(state is getStatusPengajuanDataSuccessState){
                    dataStatusPengajuan = state.listStatusPengajuanData;
                    if(dataStatusPengajuan!.statusDataPendidikan == false){
                      widget.initialIndex = 0;
                    }
                  }
                  return DefaultTabController(
                    length: tabLength,
                    initialIndex: widget.initialIndex,
                    child: BlocBuilder<AuthBloc, LoginRespon>(
                      builder: (context, stateLogin) {
                        return Scaffold(
                          appBar: AppBar(
                            centerTitle: true,
                            iconTheme: IconThemeData(color: CustomStyle.color15),
                            flexibleSpace: Image(
                              image: AssetImage(ValueImage.headerBiruDashboard),
                              fit: BoxFit.cover,
                            ),
                            backgroundColor: Colors.transparent,
                            title: Text(snapshot.data!.menuDataPendidikan!.title!, style: TextStyle(fontSize: CustomStyle.fontSizeTitle,color: CustomStyle.color15)),
                            bottom: dataStatusPengajuan == null ? null : dataStatusPengajuan!.statusDataPendidikan == false ? null : TabBar(
                              labelPadding: EdgeInsets.all(0),
                              indicatorSize: TabBarIndicatorSize.tab,
                              labelColor: CustomStyle.color15,
                              indicatorColor: Colors.white,
                              indicatorWeight: 4,
                              isScrollable: true,
                              tabs: [
                                Container(
                                    width: MediaQuery.of(context).size.width / tabLength,
                                    child: Tab(text: snapshot.data!.menuDataPendidikan!.terverifikasi)),
                                Container(
                                    width: MediaQuery.of(context).size.width / tabLength,
                                    child: Tab(text: snapshot.data!.menuDataPendidikan!.pengajuan)),
                              ],
                            ),
                            actions: stateLogin.dataLogin!.komponenMobile![9] == '0' ? null : [
                              GestureDetector(
                                onTap: () => BlocProvider.of<NavigatorBloc>(context)
                                    .add(NavigateToHalamanAddDataPendidikan(context)),
                                child: Container(
                                    margin: EdgeInsets.only(right: 14),
                                    child: Icon(
                                      Icons.add,
                                      size: 26,
                                    )),
                              ),
                            ],
                          ),
                          body: TabBarView(
                            physics: NeverScrollableScrollPhysics(),
                            children: [
                              HalamanDataPendidikanTerverifikasi(snapshot.data!),
                              HalamanDataPendidikanPengajuan(snapshot.data!),
                            ],
                          ),
                        );
                      }
                    )
                  );
                }
            );
          }else{
            return Container();
          }
        }
      )
    );
  }
}
