import 'package:absenkuv3/Bloc/Akun/DataKeluarga/DataKeluargaBloc.dart';
import 'package:absenkuv3/Bloc/CustomFunction.dart';
import 'package:absenkuv3/Bloc/Dropdown/Akun/DropdownAgamaBloc.dart';
import 'package:absenkuv3/Bloc/Dropdown/Akun/DropdownHubunganBloc.dart';
import 'package:absenkuv3/Bloc/Dropdown/Akun/DropdownJenisKelaminBloc.dart';
import 'package:absenkuv3/Bloc/Dropdown/Akun/DropdownJenisStatusBloc.dart';
import 'package:absenkuv3/Bloc/Dropdown/Akun/DropdownPekerjaanBloc.dart';
import 'package:absenkuv3/Bloc/Dropdown/Akun/DropdownPendidikanBloc.dart';
import 'package:absenkuv3/Bloc/Dropdown/Akun/DropdownStatusPerkawinanBloc.dart';
import 'package:absenkuv3/Repository/Model/Akun/DataKeluarga/mDataKeluarga.dart';
import 'package:absenkuv3/Repository/Model/Akun/DataKeluarga/mDataKeluargaById.dart';
import 'package:absenkuv3/Repository/Model/Akun/mDataDiri.dart';
import 'package:absenkuv3/Repository/Model/PageModel/mDataKeluargaPage.dart';
import 'package:absenkuv3/Setting/PengaturanBahasa.dart';
import 'package:absenkuv3/Setting/value_image.dart';
import 'package:absenkuv3/UI/Modul/Dropdown/Akun/DropdownJenisAgama.dart';
import 'package:absenkuv3/UI/Modul/Dropdown/Akun/DropdownJenisHubungan.dart';
import 'package:absenkuv3/UI/Modul/Dropdown/Akun/DropdownJenisKelamin.dart';
import 'package:absenkuv3/UI/Modul/Dropdown/Akun/DropdownJenisPekerjaan.dart';
import 'package:absenkuv3/UI/Modul/Dropdown/Akun/DropdownJenisStatus.dart';
import 'package:absenkuv3/UI/Modul/Dropdown/Akun/DropdownJenisStatusPerkawinan.dart';
import 'package:absenkuv3/UI/Modul/Dropdown/Akun/DropdownPendidikan.dart';
import 'package:absenkuv3/UI/Template/BottomSheet/BottomSheetAgama.dart';
import 'package:absenkuv3/UI/Template/BottomSheet/BottomSheetJenisHubungan.dart';
import 'package:absenkuv3/UI/Template/BottomSheet/BottomSheetJenisKelamin.dart';
import 'package:absenkuv3/UI/Template/BottomSheet/BottomSheetJenisPekerjaan.dart';
import 'package:absenkuv3/UI/Template/BottomSheet/BottomSheetJenisStatus.dart';
import 'package:absenkuv3/UI/Template/BottomSheet/BottomSheetPendidikan.dart';
import 'package:absenkuv3/UI/Template/BottomSheet/BottomSheetStatusPerkawinan.dart';
import 'package:absenkuv3/UI/Template/DatePicker/Bloc/DatePickerTglKawinBloc.dart';
import 'package:absenkuv3/UI/Template/DatePicker/Bloc/DatePickerTglLahirBloc.dart';
import 'package:absenkuv3/UI/Template/DatePicker/UI/templateDatePickerTglKawin.dart';
import 'package:absenkuv3/UI/Template/DatePicker/UI/templateDatePickerTglLahir.dart';
import 'package:absenkuv3/UI/Template/style.dart';
import 'package:absenkuv3/UI/Template/templateTextFormAkun.dart';
import 'package:flutter/material.dart';
import 'package:flutter_bloc/flutter_bloc.dart';
import 'package:intl/intl.dart';

// ignore: must_be_immutable
class HalamanEditDataKeluarga extends StatefulWidget {
  var idKeluarga;
  HalamanEditDataKeluarga(this.idKeluarga);

  @override
  _HalamanEditDataKeluargaState createState() => _HalamanEditDataKeluargaState();
}

class _HalamanEditDataKeluargaState extends State<HalamanEditDataKeluarga> {
  GlobalKey<ScaffoldState> scaffoldKey = GlobalKey();
  // DATA DIRI
  TextEditingController nik = new TextEditingController();
  TextEditingController namaLengkap = new TextEditingController();
  JenisData? pendTerakhir;
  JenisData? jenisKelamin;
  JenisData? jenisStatus;
  JenisData? jenisStatusPerkawinan;
  JenisData? jenisPekerjaan;
  JenisData? jenisHubunganKeluarga;
  TextEditingController tmptLahir = new TextEditingController();
  TextEditingController telp = new TextEditingController();
  TextEditingController noBPJS = new TextEditingController();
  JenisData? agama;
  String? idKaryawan;
  String? idCompany;
  final dateFormat = new DateFormat('yyyy-MM-dd');
  DateFormat dateFormatRaw = DateFormat('d MMMM yyyy', 'id_ID');
  String tanggalLahir = '0000-00-00';
  TextEditingController tanggalLahirRaw = new TextEditingController();
  String tglPerkawinan = '0000-00-00';
  String idKeluarga = "";
  TextEditingController tglPerkawinanRaw = new TextEditingController();


  @override
  void initState() {
    super.initState();
    BlocProvider.of<DataKeluargaBloc>(context).add(getDataKeluargaPengajuanByIdEvent(context,widget.idKeluarga, 'data'));
  }

  Future<bool> keluar() async {
    Navigator.pop(context);
    return false;
  }

  void setDataKeluarga(DataDatakeluargaById state, String bahasa){
    dateFormatRaw = DateFormat('d MMMM yyyy', bahasa);
    idKeluarga            = state.idKeluarga!;
    nik.text              = state.nik!;
    namaLengkap.text      = state.namaLengkap!;
    pendTerakhir          = state.pendidikanTerakhir;
    jenisKelamin          = state.jenisKelamin;
    tmptLahir.text        = state.tempatLahir!;
    tanggalLahir          = state.tglLahir!;
    if(tanggalLahir != '0000-00-00'){
      tanggalLahirRaw.text = dateFormatRaw.format(DateTime.parse(state.tglLahir!));
    }
    idKaryawan            = state.idKaryawan;
    idCompany             = state.idCompany;
    telp.text             = state.telepon!;
    agama                 = state.agama;
    jenisStatus           = state.status;
    jenisStatusPerkawinan = state.statusPerkawinan;
    jenisPekerjaan        = state.pekerjaan;
    jenisHubunganKeluarga = state.hubKeluarga;
    noBPJS.text           = state.noBpjs!;
    tglPerkawinan         = state.tanggalPerkawinan!;
    if(tglPerkawinan != '0000-00-00'){
      tglPerkawinanRaw.text = dateFormatRaw.format(DateTime.parse(state.tanggalPerkawinan!));
    }
  }

  @override
  Widget build(BuildContext context) {
    return WillPopScope(
      onWillPop: keluar,
      child: FutureBuilder<PageDataKeluargaModel>(
        future: PengaturanBahasa().dataKeluarga(),
        builder: (context, snapshot) {
          if(snapshot.connectionState == ConnectionState.done){
            return Scaffold(
                key: scaffoldKey,
                appBar: AppBar(centerTitle: true,
                  iconTheme: IconThemeData(color: CustomStyle.color15),
                  flexibleSpace: Image(
                    image: AssetImage(ValueImage.headerBiruDashboard),
                    fit: BoxFit.cover,
                  ),
                  backgroundColor: Colors.transparent,
                  title: Text(snapshot.data!.menuDataKeluarga!.editTitle!,
                    style: TextStyle(fontSize: CustomStyle.fontSizeTitle,color: CustomStyle.color15),
                  ),
                ),
                body: BlocBuilder<DataKeluargaBloc, DataKeluargaState>(
                    builder: (BuildContext context, DataKeluargaState state){
                      if(state is getDataKeluargaByIdSuccessState) {
                        setDataKeluarga(state.dataById![0], snapshot.data!.menuDataKeluarga!.locale!);
                        return SingleChildScrollView(
                          child: Container(
                            margin: EdgeInsets.all(10),
                            child: Column(
                              mainAxisAlignment: MainAxisAlignment.start,
                              crossAxisAlignment: CrossAxisAlignment.start,
                              children: [
                                BlocListener<DropdownHubunganBloc, DropdownHubunganState>(
                                  listener: (BuildContext context, DropdownHubunganState state) {
                                    if (state is DropdownHubunganSuccessState && state.selectedValue != null) {
                                      jenisHubunganKeluarga = state.selectedValue;
                                    }
                                  },
                                  child: BottomSheetJenisHubungan(
                                    snapshot.data!.menuDataKeluarga!.dataKeluarga!.hubKeluarga!,
                                    initialData: jenisHubunganKeluarga==null?null:jenisHubunganKeluarga!.nama,
                                    color: Colors.black,
                                    marginHorizontal: 13,
                                  ),
                                ),
                                SizedBox(height: 17),
                                TemplateTextFormAkun(
                                  adaValidasi: false,
                                  controller: nik,
                                  color: Colors.black,
                                  fontSize: 13,
                                  titleText: snapshot.data!.menuDataKeluarga!.dataKeluarga!.nik,
                                  radius: CustomStyle.formRadius,
                                  marginHorizontal: 13,
                                  // hintText: "NIK",
                                ),
                                SizedBox(height: 17),
                                TemplateTextFormAkun(
                                  adaValidasi: true,
                                  controller: namaLengkap,
                                  color: Colors.black,
                                  fontSize: 13,
                                  titleText: snapshot.data!.menuDataKeluarga!.dataKeluarga!.namaLengkap,
                                  radius: CustomStyle.formRadius,
                                  // hintText: "Nama Lengkap",
                                  marginHorizontal: 13,
                                ),
                                SizedBox(height: 17),
                                TemplateTextFormAkun(
                                  adaValidasi: true,
                                  controller: tmptLahir,
                                  color: Colors.black,
                                  fontSize: 13,
                                  titleText: snapshot.data!.menuDataKeluarga!.dataKeluarga!.tempatLahir,
                                  radius: CustomStyle.formRadius,
                                  marginHorizontal: 13,
                                  // hintText: "Tempat Lahir",
                                ),
                                SizedBox(height: 17),
                                BlocListener<DatePickerTglLahirBloc, DateTime>(
                                  listener: (BuildContext context, DateTime date) {
                                    tanggalLahir = dateFormat.format(date);//dateFormat.format(date);
                                    tanggalLahirRaw.text = dateFormatRaw.format(date);
                                  },
                                  child: TemplateDatePickerTglLahir(
                                    '${snapshot.data!.menuDataKeluarga!.dataKeluarga!.tanggalLahir} ',
                                    marginHorizontal: 13,
                                    textEditingController: tanggalLahirRaw,
                                    initialData: tanggalLahir == '0000-00-00'
                                        ? null
                                        : DateTime(int.parse(tanggalLahir.split('-')[0]),int.parse(tanggalLahir.split('-')[1]),int.parse(tanggalLahir.split('-')[2])),),
                                ),
                                BlocListener<DropdownJenisKelaminBloc, DropdownJenisKelaminState>(
                                  listener: (BuildContext context, DropdownJenisKelaminState state) {
                                    if (state is DropdownJenisKelaminSuccessState && state.selectedValue != null) {
                                      jenisKelamin = state.selectedValue;
                                    }
                                  },
                                  child: BottomSheetJenisKelamin(
                                    snapshot.data!.menuDataKeluarga!.dataKeluarga!.jenisKelamin!,
                                    initialData: jenisKelamin==null?null:jenisKelamin!.nama,
                                    color: Colors.black,
                                    marginHorizontal: 13,
                                  ),
                                ),
                                BlocListener<DropdownAgamaBloc, DropdownAgamaState>(
                                  listener: (BuildContext context, DropdownAgamaState state) {
                                    if (state is DropdownAgamaSuccessState && state.selectedValue != null) {
                                      agama = state.selectedValue;
                                    }
                                  },
                                  child: BottomSheetAgama(
                                    snapshot.data!.menuDataKeluarga!.dataKeluarga!.agama!,
                                    initialData: agama == null ? null : agama!.nama,
                                    color: Colors.black,
                                    marginHorizontal: 14,
                                  ),
                                ),
                                TemplateTextFormAkun(
                                  adaValidasi: false,
                                  controller: telp,
                                  color: Colors.black,
                                  keyboardNumber: true,
                                  fontSize: 13,
                                  titleText: snapshot.data!.menuDataKeluarga!.dataKeluarga!.telepon,
                                  radius: CustomStyle.formRadius,
                                  marginHorizontal: 13,
                                  // hintText: "No Telepon",
                                ),
                                BlocListener<DropdownPekerjaanBloc, DropdownPekerjaanState>(
                                  listener: (BuildContext context, DropdownPekerjaanState state) {
                                    if (state is DropdownPekerjaanSuccessState && state.selectedValue != null) {
                                      jenisPekerjaan = state.selectedValue;
                                    }
                                  },
                                  child: BottomSheetJenisPekerjaan(
                                    snapshot.data!.menuDataKeluarga!.dataKeluarga!.pekerjaan!,
                                    initialData: jenisPekerjaan==null?null:jenisPekerjaan!.nama,
                                    color: Colors.black,
                                    marginHorizontal: 14,
                                  ),
                                ),
                                BlocListener<DropdownStatusPerkawinanBloc, DropdownStatusPerkawinanState>(
                                  listener: (BuildContext context, DropdownStatusPerkawinanState state) {
                                    if (state is DropdownStatusPerkawinanSuccessState && state.selectedValue != null) {
                                      jenisStatusPerkawinan = state.selectedValue;
                                    }
                                  },
                                  child: BottomSheetStatusPerkawinan(
                                    snapshot.data!.menuDataKeluarga!.dataKeluarga!.statusPerkawinan!,
                                    initialData: jenisStatusPerkawinan==null?null:jenisStatusPerkawinan!.nama,
                                    color: Colors.black,
                                    marginHorizontal: 14,
                                  ),
                                ),
                                BlocListener<DatePickerTglKawinBloc, DateTime>(
                                  listener: (BuildContext context, DateTime date) {
                                    tglPerkawinan = dateFormat.format(date);//dateFormat.format(date);
                                    tglPerkawinanRaw.text = dateFormatRaw.format(date);
                                  },
                                  child: TemplateDatePickerTglKawin(
                                    snapshot.data!.menuDataKeluarga!.dataKeluarga!.tanggalPerkawinan!,
                                    marginHorizontal: 13,
                                    textEditingController: tglPerkawinanRaw,
                                    initialData: tglPerkawinan == '0000-00-00'
                                        ? null
                                        : DateTime(int.parse(tglPerkawinan.split('-')[0]),int.parse(tglPerkawinan.split('-')[1]),int.parse(tglPerkawinan.split('-')[2])),),
                                ),
                                TemplateTextFormAkun(
                                  adaValidasi: false,
                                  controller: noBPJS,
                                  color: Colors.black,
                                  fontSize: 13,
                                  marginHorizontal: 13,
                                  keyboardNumber: true,
                                  titleText: snapshot.data!.menuDataKeluarga!.dataKeluarga!.noBpjsKes,
                                  radius: CustomStyle.formRadius,
                                  // hintText: "Nomor BPJS Kesehatan",
                                ),
                                BlocListener<DropdownJenisStatusBloc, DropdownJenisStatusState>(
                                  listener: (BuildContext context, DropdownJenisStatusState state) {
                                    if (state is DropdownJenisStatusSuccessState && state.selectedValue != null) {
                                      jenisStatus = state.selectedValue;
                                    }
                                  },
                                  child: BottomSheetJenisStatus(
                                    snapshot.data!.menuDataKeluarga!.dataKeluarga!.status!,
                                    initialData: jenisStatus==null?null:jenisStatus!.nama,
                                    color: Colors.black,
                                    marginHorizontal: 13,
                                  ),
                                ),

                                BlocListener<DropdownPendidikanBloc, DropdownPendidikanState>(
                                  listener: (BuildContext context, DropdownPendidikanState state) {
                                    if (state is DropdownPendidikanSuccessState && state.selectedValue != null) {
                                      pendTerakhir = state.selectedValue;
                                    }
                                  },
                                  child: BottomSheetPendidikan(
                                    snapshot.data!.menuDataKeluarga!.dataKeluarga!.pendidikanTerakhir!,
                                    initialData: pendTerakhir == null ? null : pendTerakhir!.nama,
                                    color: Colors.black,
                                    marginHorizontal: 14,
                                  ),
                                ),
                                Container(
                                  margin: EdgeInsets.only(top: 15),
                                  width: double.infinity,
                                  height: 41,
                                  child: MaterialButton(onPressed: () {
                                    if(jenisHubunganKeluarga == null) showSnackBarDelayed(scaffoldKey, snapshot.data!.menuDataKeluarga!.message!.hubKeluargaEmpty, context);
                                    else if(namaLengkap.text.trim().isEmpty) showSnackBarDelayed(scaffoldKey, snapshot.data!.menuDataKeluarga!.message!.namaLengkapEmpty, context);
                                    else if(tmptLahir.text.trim().isEmpty) showSnackBarDelayed(scaffoldKey, snapshot.data!.menuDataKeluarga!.message!.tempatLahirEmpty, context);
                                    else if(tanggalLahir =='0000-00-00') showSnackBarDelayed(scaffoldKey, snapshot.data!.menuDataKeluarga!.message!.tanggalLahirEmpty, context);
                                    else if(jenisKelamin == null) showSnackBarDelayed(scaffoldKey, snapshot.data!.menuDataKeluarga!.message!.jenisKelaminEmpty, context);
                                    else if(agama == null) showSnackBarDelayed(scaffoldKey, snapshot.data!.menuDataKeluarga!.message!.agamaEmpty, context);
                                    else if(jenisPekerjaan == null) showSnackBarDelayed(scaffoldKey, snapshot.data!.menuDataKeluarga!.message!.jenisPekerjaan, context);
                                    else if(jenisStatusPerkawinan == null) showSnackBarDelayed(scaffoldKey, snapshot.data!.menuDataKeluarga!.message!.statusPerkawinan, context);
                                    else if(jenisStatus == null) showSnackBarDelayed(scaffoldKey, snapshot.data!.menuDataKeluarga!.message!.status, context);
                                    else if(pendTerakhir == null) showSnackBarDelayed(scaffoldKey, snapshot.data!.menuDataKeluarga!.message!.pendidikanTerakhirEmpty, context);
                                    else BlocProvider.of<DataKeluargaBloc>(context).add(
                                          EditDataKeluargaEvent(
                                              context,
                                              scaffoldKey,
                                              DataDatakeluarga(
                                                  nik: nik.text,
                                                  idKaryawan: idKaryawan,
                                                  agama: agama!.nama,
                                                  hubKeluarga: jenisHubunganKeluarga!.nama,
                                                  idCompany: idCompany,
                                                  idKeluarga: idKeluarga,
                                                  jenisKelamin: jenisKelamin!.id,
                                                  namaLengkap: namaLengkap.text,
                                                  noBpjs: noBPJS.text,
                                                  pekerjaan: jenisPekerjaan!.nama,
                                                  pendidikanTerakhir: pendTerakhir!.nama,
                                                  status: jenisStatus!.nama,
                                                  statusPerkawinan: jenisStatusPerkawinan!.nama,
                                                  tglLahir:  tanggalLahir == '0000-00-00' ? tanggalLahir : tanggalLahir,
                                                  tanggalPerkawinan: tglPerkawinan == '0000-00-00' ? tglPerkawinan : tglPerkawinan, //'${tglPerkawinan.split('-')[2]}-${tglPerkawinan.split('-')[1]}-${tglPerkawinan.split('-')[0]}',
                                                  telepon: telp.text,
                                                  tempatLahir: tmptLahir.text
                                              )
                                          ));
                                  },
                                    shape: RoundedRectangleBorder(
                                        borderRadius: BorderRadius.circular(15)
                                    ),
                                    color: CustomStyle.color1,
                                    textColor: Colors.white,
                                    child: Text(snapshot.data!.menuDataKeluarga!.button!.ajukanPerubahanData!),
                                  ),
                                )
                              ],
                            ),
                          ),
                        );
                      }
                      else if(state is DataKeluargaProgressState) return Center(child: CircularProgressIndicator(strokeWidth: 8,),);
                      else return Center(child: Image.asset(ValueImage.noData, height: 250,),);
                    }
                )
            );
          }else{
            return Container();
          }
        }
      ),
    );
  }
}
