import 'package:absenkuv3/Bloc/Akun/DataDiri/DataDiriEditBloc.dart';
import 'package:absenkuv3/Bloc/CustomFunction.dart';
import 'package:absenkuv3/Bloc/Dropdown/Akun/DropdownAgamaBloc.dart';
import 'package:absenkuv3/Bloc/Dropdown/Akun/DropdownGolonganDarahBloc.dart';
import 'package:absenkuv3/Bloc/Dropdown/Akun/DropdownJenisKelaminBloc.dart';
import 'package:absenkuv3/Bloc/Dropdown/Akun/DropdownKabupatenBloc.dart';
import 'package:absenkuv3/Bloc/Dropdown/Akun/DropdownKelurahanBloc.dart';
import 'package:absenkuv3/Bloc/Dropdown/Akun/DropdownPendidikanBloc.dart';
import 'package:absenkuv3/Bloc/Dropdown/Akun/DropdownProvinsiBloc.dart';
import 'package:absenkuv3/Repository/Model/Akun/View/mDataDataDiri.dart';
import 'package:absenkuv3/Repository/Model/Akun/mDataDiri.dart';
import 'package:absenkuv3/Repository/Model/PageModel/mDataDiriPage.dart';
import 'package:absenkuv3/Setting/PengaturanBahasa.dart';
import 'package:absenkuv3/Setting/value_image.dart';
import 'package:absenkuv3/UI/Modul/Dropdown/Akun/DropdownJenisAgama.dart';
import 'package:absenkuv3/UI/Modul/Dropdown/Akun/DropdownJenisGolonganDarah.dart';
import 'package:absenkuv3/UI/Modul/Dropdown/Akun/DropdownJenisKabupaten.dart';
import 'package:absenkuv3/UI/Modul/Dropdown/Akun/DropdownJenisKecamatan.dart';
import 'package:absenkuv3/UI/Modul/Dropdown/Akun/DropdownJenisKelamin.dart';
import 'package:absenkuv3/UI/Modul/Dropdown/Akun/DropdownJenisKelurahan.dart';
import 'package:absenkuv3/UI/Modul/Dropdown/Akun/DropdownJenisProvinsi.dart';
import 'package:absenkuv3/Bloc/Dropdown/Akun/DropdownKecamatanBloc.dart';
import 'package:absenkuv3/UI/Modul/Dropdown/Akun/DropdownPendidikan.dart';
import 'package:absenkuv3/UI/Template/BottomSheet/BottomSheetAgama.dart';
import 'package:absenkuv3/UI/Template/BottomSheet/BottomSheetJenisGolonganDarah.dart';
import 'package:absenkuv3/UI/Template/BottomSheet/BottomSheetJenisKelamin.dart';
import 'package:absenkuv3/UI/Template/BottomSheet/BottomSheetKabKot.dart';
import 'package:absenkuv3/UI/Template/BottomSheet/BottomSheetKecamatan.dart';
import 'package:absenkuv3/UI/Template/BottomSheet/BottomSheetKelurahan.dart';
import 'package:absenkuv3/UI/Template/BottomSheet/BottomSheetPendidikan.dart';
import 'package:absenkuv3/UI/Template/BottomSheet/BaseBottomSheet.dart';
import 'package:absenkuv3/UI/Template/BottomSheet/BottomSheetProvinsi.dart';
import 'package:absenkuv3/UI/Template/DatePicker/Bloc/DatePickerTglLahirBloc.dart';
import 'package:absenkuv3/UI/Template/DatePicker/UI/templateDatePickerTglLahir.dart';
import 'package:absenkuv3/UI/Template/style.dart';
import 'package:absenkuv3/UI/Template/templateTextFormAkun.dart';
import 'package:flutter/material.dart';
import 'package:flutter_bloc/flutter_bloc.dart';
import 'package:intl/intl.dart';

class HalamanEditDataDiri extends StatefulWidget {
  @override
  _HalamanEditDataDiriState createState() => _HalamanEditDataDiriState();
}

class _HalamanEditDataDiriState extends State<HalamanEditDataDiri> {
  GlobalKey<ScaffoldState> scaffoldKey = GlobalKey();
  final dateFormat = new DateFormat('yyyy-MM-dd');
  DateFormat dateFormatView = DateFormat('d MMMM yyyy', 'id_ID');
  // DATA DIRI
  TextEditingController nik = new TextEditingController();
  TextEditingController namaLengkap = new TextEditingController();
  JenisData? pendTerakhir;
  TextEditingController gelarDpn = new TextEditingController();
  TextEditingController gelarBlkg = new TextEditingController();
  JenisData? jenisKelamin;
  JenisData? golonganDarah;
  TextEditingController tmptLahir = new TextEditingController();
  TextEditingController tglLahir = new TextEditingController();
  TextEditingController tglLahirRaw = new TextEditingController();
  TextEditingController telp = new TextEditingController();
  JenisData? agama;
  TextEditingController email = new TextEditingController();
  TextEditingController noKTP = new TextEditingController();
  TextEditingController noBPJSKes = new TextEditingController();
  TextEditingController noBPJSTk = new TextEditingController();
  TextEditingController noAsuransi = new TextEditingController();

  // DATA ALAMAT
  JenisData? provinsi;
  JenisData? kabkota;
  JenisData? kecamatan;
  JenisData? kelurahan;
  TextEditingController rt = new TextEditingController();
  TextEditingController rw = new TextEditingController();
  TextEditingController alamatDomisili = new TextEditingController();
  TextEditingController kodePos = new TextEditingController();

  // DATA KEPEGAWAIAN
  TextEditingController jabatan = new TextEditingController();
  TextEditingController cabang = new TextEditingController();
  TextEditingController jatahCuti = new TextEditingController();
  TextEditingController status = new TextEditingController();
  TextEditingController tglAktif = new TextEditingController();

  @override
  void initState() {
    super.initState();
    BlocProvider.of<DataDiriEditBloc>(context)
        .add(getDataDiriEditEvent(context));
  }

  Future<bool> keluar() async {
    // BlocProvider.of<DropdownKabupatenBloc>(context).add(SetProvinsi(null));
    // BlocProvider.of<DropdownKecamatanBloc>(context).add(SetKabupaten(null));
    // BlocProvider.of<DropdownKelurahanBloc>(context).add(SetKecamatan(null));
    Navigator.pop(context);
    return false;
  }

  void tes(getDataDiriEditSuccessState state, String? bahasa) {
    // DATA DIRI
    dateFormatView = DateFormat('d MMMM yyyy', bahasa);
    nik.text = state.data!.nik!;
    namaLengkap.text = state.data!.namaLengkap!;
    pendTerakhir = state.data!.pendidikanTerakhir;
    gelarDpn.text = state.data!.gelarDepan!;
    gelarBlkg.text = state.data!.gelarBelakang!;
    jenisKelamin = state.data!.jenisKelamin;
    golonganDarah = state.data!.golonganDarah;
    tmptLahir.text = state.data!.tempatLahir!;
    tglLahir.text = state.data!.tglLahir!;
    if (state.data!.tglLahir != '0000-00-00') {
      tglLahirRaw.text =
          dateFormatView.format(DateTime.parse(state.data!.tglLahir!));
    }
    telp.text = state.data!.telepon!;
    email.text = state.data!.email!;
    agama = state.data!.agama;
    noKTP.text = state.data!.noKtp!;
    noBPJSKes.text = state.data!.noBpjsKes!;
    noBPJSTk.text = state.data!.noBpjsTk!;
    // nik.text = state.data.nik;

    // DATA ALAMAT
    provinsi = state.data!.provinsi;
    kabkota = state.data!.kabupaten;
    kecamatan = state.data!.kecamatan;
    kelurahan = state.data!.kelurahan;
    rt.text = state.data!.rt!;
    rw.text = state.data!.rw!;
    alamatDomisili.text = state.data!.alamatDomisili!;
    kodePos.text = state.data!.kodePos!;
    BlocProvider.of<DropdownKabupatenBloc>(context).add(SetProvinsi(
        provinsi == null ? null :provinsi!.id!, kabkota == null ? null :JenisData(id: kabkota!.id, nama: kabkota!.nama)));
    BlocProvider.of<DropdownKecamatanBloc>(context).add(SetKabupaten(
        kabkota == null ? null : kabkota!.id, kecamatan == null ? null : JenisData(id: kecamatan!.id, nama: kecamatan!.nama)));
    BlocProvider.of<DropdownKelurahanBloc>(context).add(SetKecamatan(
        kecamatan == null ? null : kecamatan!.id, kelurahan == null ? null:JenisData(id: kelurahan!.id, nama: kelurahan!.nama)));
  }

  @override
  Widget build(BuildContext context) {
    return WillPopScope(
      onWillPop: keluar,
      child: FutureBuilder<PageDataDiriModel>(
          future: PengaturanBahasa().dataDiri(),
          builder: (context, snapshot) {
            if (snapshot.connectionState == ConnectionState.done) {
              return Scaffold(
                  key: scaffoldKey,
                  appBar: AppBar(
                    centerTitle: true,
                    iconTheme: IconThemeData(color: CustomStyle.color15),
                    flexibleSpace: Image(
                      image: AssetImage(ValueImage.headerBiruDashboard),
                      fit: BoxFit.cover,
                    ),
                    backgroundColor: Colors.transparent,
                    title: Text(
                      snapshot.data!.menuDataDiri!.editTitle!,
                      style: TextStyle(
                          fontSize: CustomStyle.fontSizeTitle,
                          color: CustomStyle.color15),
                    ),
                  ),
                  body: BlocBuilder<DataDiriEditBloc, DataDiriEditState>(
                      builder: (BuildContext context, DataDiriEditState state) {
                    if (state is getDataDiriEditSuccessState) {
                      tes(state, snapshot.data!.menuDataDiri!.locale);
                      return SingleChildScrollView(
                        child: Container(
                          margin: EdgeInsets.all(10),
                          child: Column(
                            mainAxisAlignment: MainAxisAlignment.start,
                            crossAxisAlignment: CrossAxisAlignment.start,
                            children: [
                              Container(
                                  child: Text(
                                      snapshot.data!.menuDataDiri!.dataDiri!
                                          .header!,
                                      style: TextStyle(
                                          color: CustomStyle.color1,
                                          fontWeight: FontWeight.bold))),
                              SizedBox(height: 13),
                              TemplateTextFormAkun(
                                adaValidasi: false,
                                controller: nik,
                                color: Colors.black,
                                marginHorizontal: 13,
                                fontSize: 13,
                                titleText: snapshot.data!.menuDataDiri!
                                    .dataDiri!.nomorIndukKaryawan,
                                // labelText: "Nomor Induk Karyawan",
                                radius: CustomStyle.formRadius,
                                // hintText: "Nomor Induk Karyawan",
                              ),
                              SizedBox(height: 9),
                              TemplateTextFormAkun(
                                adaValidasi: true,
                                controller: namaLengkap,
                                marginHorizontal: 13,
                                color: Colors.black,
                                fontSize: 13,
                                titleText: snapshot
                                    .data!.menuDataDiri!.dataDiri!.namaLengkap,
                                // labelText: "Nama Lengkap",
                                radius: CustomStyle.formRadius,
                                // hintText: "Nama Lengkap",
                              ),
                              BlocListener<DropdownPendidikanBloc,
                                  DropdownPendidikanState>(
                                listener: (BuildContext context,
                                    DropdownPendidikanState state) {
                                  if (state is DropdownPendidikanSuccessState &&
                                      state.selectedValue != null) {
                                    pendTerakhir = state.selectedValue;
                                  }
                                },
                                child: BottomSheetPendidikan(
                                  snapshot.data!.menuDataDiri!.dataDiri!
                                      .pendidikanTerakhir!,
                                  initialData: pendTerakhir == null
                                      ? null
                                      : pendTerakhir!.nama,
                                  // color: Colors.grey[600],
                                  marginHorizontal: 13,
                                ),
                              ),
                              SizedBox(height: 9),
                              TemplateTextFormAkun(
                                adaValidasi: false,
                                controller: gelarDpn,
                                color: Colors.black,
                                marginHorizontal: 13,
                                fontSize: 13,
                                titleText: snapshot
                                    .data!.menuDataDiri!.dataDiri!.gelarDepan,
                                radius: CustomStyle.formRadius,
                              ),
                              SizedBox(height: 21),
                              TemplateTextFormAkun(
                                adaValidasi: false,
                                controller: gelarBlkg,
                                marginHorizontal: 13,
                                color: Colors.black,
                                fontSize: 13,
                                titleText: snapshot.data!.menuDataDiri!
                                    .dataDiri!.gelarBelakang,
                                radius: CustomStyle.formRadius,
                                // hintText: "Gelar Belakang",
                              ),
                              BlocListener<DropdownJenisKelaminBloc,
                                  DropdownJenisKelaminState>(
                                listener: (BuildContext context,
                                    DropdownJenisKelaminState state) {
                                  if (state
                                          is DropdownJenisKelaminSuccessState &&
                                      state.selectedValue != null) {
                                    jenisKelamin = state.selectedValue;
                                  }
                                },
                                child: BottomSheetJenisKelamin(
                                  snapshot.data!.menuDataDiri!.dataDiri!
                                      .jenisKelamin!,
                                  initialData: jenisKelamin == null
                                      ? null
                                      : jenisKelamin!.nama,
                                  marginHorizontal: 13,
                                ),
                              ),
                              BlocListener<DropdownGolonganDarahBloc,
                                  DropdownGolonganDarahState>(
                                listener: (BuildContext context,
                                    DropdownGolonganDarahState state) {
                                  if (state
                                          is DropdownGolonganDarahSuccessState &&
                                      state.selectedValue != null) {
                                    golonganDarah = state.selectedValue;
                                  }
                                },
                                child: BottomSheetJenisGolonganDarah(
                                  snapshot.data!.menuDataDiri!.dataDiri!
                                      .golonganDarah!,
                                  initialData: golonganDarah == null
                                      ? null
                                      : golonganDarah!.nama,
                                  marginHorizontal: 13,
                                ),
                              ),
                              SizedBox(height: 17),
                              TemplateTextFormAkun(
                                adaValidasi: true,
                                controller: tmptLahir,
                                color: Colors.black,
                                fontSize: 13,
                                titleText: snapshot
                                    .data!.menuDataDiri!.dataDiri!.tempatLahir,
                                marginHorizontal: 13,
                                radius: CustomStyle.formRadius,
                              ),
                              SizedBox(height: 17),
                              BlocListener<DatePickerTglLahirBloc, DateTime>(
                                listener:
                                    (BuildContext context, DateTime date) {
                                  tglLahir.text = dateFormat
                                      .format(date); //dateFormat.format(date);
                                  tglLahirRaw.text =
                                      dateFormatView.format(date);
                                },
                                child: TemplateDatePickerTglLahir(
                                  '${snapshot.data!.menuDataDiri!.dataDiri!.tanggalLahir} ',
                                  marginHorizontal: 13,
                                  textEditingController: tglLahirRaw,
                                  initialData: tglLahir.text == '0000-00-00'
                                      ? null
                                      : DateTime(
                                          int.parse(
                                              tglLahir.text.split('-')[0]),
                                          int.parse(
                                              tglLahir.text.split('-')[1]),
                                          int.parse(
                                              tglLahir.text.split('-')[2])),
                                ),
                              ),
                              SizedBox(height: 19),
                              TemplateTextFormAkun(
                                adaValidasi: true,
                                controller: telp,
                                color: Colors.black,
                                marginHorizontal: 13,
                                keyboardNumber: true,
                                fontSize: 13,
                                titleText: snapshot
                                    .data!.menuDataDiri!.dataDiri!.noTelepon,
                                radius: CustomStyle.formRadius,
                                // hintText: "No Telepon",
                              ),
                              SizedBox(height: 19),
                              TemplateTextFormAkun(
                                adaValidasi: true,
                                controller: email,
                                color: Colors.black,
                                marginHorizontal: 13,
                                fontSize: 13,
                                titleText: snapshot
                                    .data!.menuDataDiri!.dataDiri!.email,
                                radius: CustomStyle.formRadius,
                                // hintText: "Email",
                              ),
                              BlocListener<DropdownAgamaBloc,
                                  DropdownAgamaState>(
                                listener: (BuildContext context,
                                    DropdownAgamaState state) {
                                  if (state is DropdownAgamaSuccessState &&
                                      state.selectedValue != null) {
                                    agama = state.selectedValue;
                                  }
                                },
                                child: BottomSheetAgama(
                                  snapshot.data!.menuDataDiri!.dataDiri!.agama!,
                                  initialData:
                                      agama == null ? null : agama!.nama,
                                  marginHorizontal: 13,
                                ),
                              ),
                              SizedBox(height: 19),
                              TemplateTextFormAkun(
                                adaValidasi: true,
                                controller: noKTP,
                                color: Colors.black,
                                fontSize: 13,
                                marginHorizontal: 13,
                                titleText: snapshot.data!.menuDataDiri!
                                    .dataDiri!.noIndukKependudukan,
                                radius: CustomStyle.formRadius,
                                keyboardNumber: true,
                                // hintText: "Nomor Induk Kependudukan (KTP)",
                              ),
                              SizedBox(height: 19),
                              TemplateTextFormAkun(
                                adaValidasi: false,
                                controller: noBPJSKes,
                                color: Colors.black,
                                fontSize: 13,
                                marginHorizontal: 13,
                                titleText: snapshot
                                    .data!.menuDataDiri!.dataDiri!.noBpjsKes,
                                radius: CustomStyle.formRadius,
                                keyboardNumber: true,
                                // hintText: "Nomor BPJS Kesehatan",
                              ),
                              TemplateTextFormAkun(
                                adaValidasi: false,
                                controller: noAsuransi,
                                color: Colors.black,
                                keyboardNumber: true,
                                marginHorizontal: 13,
                                fontSize: 13,
                                titleText: snapshot
                                    .data!.menuDataDiri!.dataDiri!.noAsuransi,
                                radius: CustomStyle.formRadius,
                              ),
                              SizedBox(height: 13),
                              Container(
                                  child: Text(
                                      snapshot.data!.menuDataDiri!.dataAlamat!
                                          .header!,
                                      style: TextStyle(
                                          color: CustomStyle.color1,
                                          fontWeight: FontWeight.bold))),
                              SizedBox(height: 13),
                              BlocListener<DropdownProvinsiBloc,
                                  DropdownProvinsiState>(
                                listener: (BuildContext context,
                                    DropdownProvinsiState state) {
                                  if (state is DropdownProvinsiSuccessState &&
                                      state.selectedValue != null) {
                                    provinsi = state.selectedValue;
                                    kabkota = null;
                                    kecamatan = null;
                                    kelurahan = null;
                                    BlocProvider.of<DropdownKabupatenBloc>(
                                            context)
                                        .add(SetProvinsi(provinsi!.id!, null));
                                    BlocProvider.of<DropdownKecamatanBloc>(
                                            context)
                                        .add(SetKabupaten(null, null));
                                    BlocProvider.of<DropdownKelurahanBloc>(
                                            context)
                                        .add(SetKecamatan(null, null));
                                  }
                                },
                                child: BottomSheetProvinsi(
                                  snapshot.data!.menuDataDiri!.dataAlamat!
                                      .provinsi!,
                                  initialData:
                                      provinsi == null ? null : provinsi!.nama,
                                  marginHorizontal: 13,
                                ),
                              ),
                              
                              BlocListener<DropdownKabupatenBloc,
                                  DropdownKabupatenState>(
                                listener: (BuildContext context,
                                    DropdownKabupatenState state) {
                                  if (state is DropdownKabupatenSuccessState) {
                                    if (state.selectedValue != null) {
                                      final newKabkota = state.selectedValue;
                                      if (kabkota?.id != newKabkota!.id) {
                                        kabkota = newKabkota;
                                        kecamatan = null;
                                        kelurahan = null;
                                      }
                                      BlocProvider.of<DropdownKecamatanBloc>(
                                              context)
                                          .add(SetKabupaten(
                                              kabkota!.id, kecamatan));
                                      BlocProvider.of<DropdownKelurahanBloc>(
                                              context)
                                          .add(SetKecamatan(
                                              kecamatan?.id, null));
                                    }
                                  }
                                },
                                child: BottomSheetKabKot(
                                  snapshot.data!.menuDataDiri!.dataAlamat!
                                      .kabupaten!,
                                  initialData: kabkota == null
                                      ? null
                                      : kabkota,
                                  validasi: true,
                                  marginHorizontal: 13,
                                  idProv:
                                      provinsi == null ? null : provinsi!.id,
                                ),
                              ),
                              BlocListener<DropdownKecamatanBloc,
                                  DropdownKecamatanState>(
                                listener: (BuildContext context,
                                    DropdownKecamatanState state) {
                                  if (state is DropdownKecamatanSuccessState) {
                                    if (state.selectedValue != null) {
                                      final newKecamatan = state.selectedValue;
                                      if (kecamatan?.id != newKecamatan!.id) {
                                        kecamatan = newKecamatan;
                                        kelurahan = null;
                                      }
                                      BlocProvider.of<DropdownKelurahanBloc>(
                                              context)
                                          .add(SetKecamatan(
                                              kecamatan!.id, kelurahan));
                                    }
                                  }
                                },
                                child: BottomSheetKecamatan(
                                  snapshot.data!.menuDataDiri!.dataAlamat!
                                      .kecamatan!,
                                  initialData:
                                      kecamatan == null ? null : kecamatan,
                                  validasi: true,
                                  marginHorizontal: 13,
                                  // idKab: kabkota == null ? null : kabkota!.id,
                                ),
                              ),
                              BlocListener<DropdownKelurahanBloc,
                                  DropdownKelurahanState>(
                                listener: (BuildContext context,
                                    DropdownKelurahanState state) {
                                  if (state is DropdownKelurahanSuccessState &&
                                      state.selectedValue != null) {
                                    kelurahan = state.selectedValue;
                                  }
                                },
                                child: BottomSheetKelurahan(
                                  snapshot.data!.menuDataDiri!.dataAlamat!
                                      .kelurahan!,
                                  initialData:
                                      kelurahan == null ? null : kelurahan,
                                  validasi: true,
                                  color: Colors.grey[600],
                                  marginHorizontal: 13,
                                ),
                              ),
                              
                              SizedBox(height: 19),
                              TemplateTextFormAkun(
                                adaValidasi: false,
                                controller: rt,
                                color: Colors.black,
                                fontSize: 13,
                                marginHorizontal: 13,
                                titleText:
                                    snapshot.data!.menuDataDiri!.dataAlamat!.rt,
                                radius: CustomStyle.formRadius,
                                // hintText: "RT",
                              ),
                              SizedBox(height: 19),
                              TemplateTextFormAkun(
                                adaValidasi: false,
                                controller: rw,
                                color: Colors.black,
                                marginHorizontal: 13,
                                fontSize: 13,
                                titleText:
                                    snapshot.data!.menuDataDiri!.dataAlamat!.rw,
                                radius: CustomStyle.formRadius,
                                // hintText: "RW",
                              ),
                              TemplateTextFormAkun(
                                adaValidasi: false,
                                controller: alamatDomisili,
                                color: Colors.black,
                                marginHorizontal: 13,
                                fontSize: 13,
                                titleText: snapshot.data!.menuDataDiri!
                                    .dataAlamat!.alamatDomisili,
                                radius: CustomStyle.formRadius,
                                // hintText: "Alamat Domisili",
                              ),
                              SizedBox(height: 19),
                              TemplateTextFormAkun(
                                adaValidasi: false,
                                controller: kodePos,
                                color: Colors.black,
                                keyboardNumber: true,
                                fontSize: 13,
                                marginHorizontal: 13,
                                titleText: snapshot
                                    .data!.menuDataDiri!.dataAlamat!.kodePos,
                                radius: CustomStyle.formRadius,
                                // hintText: "Kode Pos",
                              ),
                              Container(
                                margin: EdgeInsets.only(top: 15),
                                width: double.infinity,
                                height: 41,
                                child: MaterialButton(
                                  onPressed: () {
                                    if (nik.text.trim().isEmpty)
                                      showSnackBarDelayed(
                                          scaffoldKey,
                                          snapshot.data!.menuDataDiri!.message!
                                              .nikEmpty,
                                          context);
                                    else if (namaLengkap.text.trim().isEmpty)
                                      showSnackBarDelayed(
                                          scaffoldKey,
                                          snapshot.data!.menuDataDiri!.message!
                                              .namaLengkapEmpty,
                                          context);
                                    else if (pendTerakhir == null)
                                      showSnackBarDelayed(
                                          scaffoldKey,
                                          snapshot.data!.menuDataDiri!.message!
                                              .pendidikanTerakhirEmpty,
                                          context);
                                    else if (jenisKelamin == null)
                                      showSnackBarDelayed(
                                          scaffoldKey,
                                          snapshot.data!.menuDataDiri!.message!
                                              .jenisKelaminEmpty,
                                          context);
                                    // else if(golonganDarah == null) showSnackBarDelayed(scaffoldKey, "Golongan darah wajib diisi", context);
                                    else if (tmptLahir.text.trim().isEmpty)
                                      showSnackBarDelayed(
                                          scaffoldKey,
                                          snapshot.data!.menuDataDiri!.message!
                                              .tempatLahirEmpty,
                                          context);
                                    else if (tglLahirRaw.text.trim().isEmpty)
                                      showSnackBarDelayed(
                                          scaffoldKey,
                                          snapshot.data!.menuDataDiri!.message!
                                              .tanggalLahirEmpty,
                                          context);
                                    else if (telp.text.trim().isEmpty)
                                      showSnackBarDelayed(
                                          scaffoldKey,
                                          snapshot.data!.menuDataDiri!.message!
                                              .teleponEmpty,
                                          context);
                                    else if (email.text.trim().isEmpty)
                                      showSnackBarDelayed(
                                          scaffoldKey,
                                          snapshot.data!.menuDataDiri!.message!
                                              .emailEmpty,
                                          context);
                                    else if (agama == null)
                                      showSnackBarDelayed(
                                          scaffoldKey,
                                          snapshot.data!.menuDataDiri!.message!
                                              .agamaEmpty,
                                          context);
                                    else if (noKTP.text.trim().isEmpty)
                                      showSnackBarDelayed(
                                          scaffoldKey,
                                          snapshot.data!.menuDataDiri!.message!
                                              .noIndukKtp,
                                          context);
                                    // else if(provinsi == null) showSnackBarDelayed(scaffoldKey, snapshot.data!.menuDataDiri!.message!.provinsiEmpty, context);
                                    // else if(kabkota == null) showSnackBarDelayed(scaffoldKey, snapshot.data!.menuDataDiri!.message!.kabupatenEmpty, context);
                                    // else if(kecamatan == null) showSnackBarDelayed(scaffoldKey, snapshot.data!.menuDataDiri!.message!.kecamatanEmpty, context);
                                    // else if(kelurahan == null) showSnackBarDelayed(scaffoldKey, snapshot.data!.menuDataDiri!.message!.kelurahanEmpty, context);
                                    // else if(alamatDomisili.text.trim().isEmpty) showSnackBarDelayed(scaffoldKey,snapshot.data!.menuDataDiri!.message!.alamatDomisiliEmpty, context);
                                    else {
                                      BlocProvider.of<DataDiriEditBloc>(context)
                                          .add(pengajuanEditDataDiriEvent(
                                              context,
                                              scaffoldKey,
                                              DataDatadiri(
                                                  nik: nik.text,
                                                  namaLengkap: namaLengkap.text,
                                                  pendidikanTerakhir:
                                                      pendTerakhir!.nama,
                                                  gelarDepan: gelarDpn.text,
                                                  gelarBelakang: gelarBlkg.text,
                                                  jenisKelamin:
                                                      jenisKelamin!.id,
                                                  golonganDarah:
                                                      golonganDarah!.nama,
                                                  tempatLahir: tmptLahir.text,
                                                  tglLahir: tglLahir.text,
                                                  telepon: telp.text,
                                                  email: email.text,
                                                  agama: agama!.nama,
                                                  noKtp: noKTP.text,
                                                  noBpjsKes: noBPJSKes.text,
                                                  noAsuransi: noAsuransi.text,
                                                  namaProvinsi:
                                                      provinsi?.id ?? null,
                                                  namaKabupaten:
                                                      kabkota?.id ?? null,
                                                  namaKecamatan:
                                                      kecamatan?.id ?? null,
                                                  namaKelurahan:
                                                      kelurahan?.id ?? null,
                                                  rt: rt.text,
                                                  rw: rw.text,
                                                  alamatDomisili:
                                                      alamatDomisili.text,
                                                  kodePos: kodePos.text)));
                                    }
                                  },
                                  shape: RoundedRectangleBorder(
                                      borderRadius: BorderRadius.circular(15)),
                                  color: CustomStyle.color1,
                                  textColor: Colors.white,
                                  child: Text(snapshot.data!.menuDataDiri!
                                      .button!.ajukanPerubahanData!),
                                ),
                              )
                            ],
                          ),
                        ),
                      );
                    } else if (state is DataDiriEditProgressState)
                      return Center(
                        child: CircularProgressIndicator(
                          strokeWidth: 8,
                        ),
                      );
                    else
                      return Center(
                        child: Image.asset(
                          ValueImage.noData,
                          height: 250,
                        ),
                      );
                  }));
            } else {
              return Container();
            }
          }),
    );
  }
}
