import 'package:absenkuv3/Bloc/Akun/DataDiri/DataDiriBloc.dart';
import 'package:absenkuv3/Bloc/Akun/DataDiri/DataDiriEditBloc.dart';
import 'package:absenkuv3/Bloc/NavigatorBloc.dart';
import 'package:absenkuv3/Bloc/NotifBloc.dart';
import 'package:absenkuv3/Repository/Model/Akun/mNotifikasiAkun.dart';
import 'package:absenkuv3/Repository/Model/PageModel/mDataDiriPage.dart';
import 'package:absenkuv3/Setting/PengaturanBahasa.dart';
import 'package:absenkuv3/Setting/value_image.dart';
import 'package:absenkuv3/UI/Template/templateButton.dart';
import 'package:flutter/material.dart';
import 'package:flutter_bloc/flutter_bloc.dart';
import 'package:absenkuv3/UI/Template/style.dart';

class HalamanDetailNotifikasiDataDiri extends StatefulWidget {
  final DataNotifikasiAkun data;
  HalamanDetailNotifikasiDataDiri(this.data);

  @override
  _HalamanDetailNotifikasiDataDiriState createState() => _HalamanDetailNotifikasiDataDiriState();
}

class _HalamanDetailNotifikasiDataDiriState extends State<HalamanDetailNotifikasiDataDiri> {

  @override
  void initState() {
    super.initState();
    BlocProvider.of<DataDiriBloc>(context).add(getDetailDataDiriByIdEvent(context, widget.data));
    BlocProvider.of<NotifBloc>(context).add(BacaNotifAkun(widget.data.idNotif, context));
  }


  Future<bool> keluar() async {
    Navigator.pop(context);
    BlocProvider.of<NavigatorBloc>(context).add(NavigateToReplacementHalamanNotifikasiAkun(context));
    return false;
  }

  @override
  Widget build(BuildContext context) {
    return WillPopScope(
      onWillPop: keluar,
      child: FutureBuilder<PageDataDiriModel>(
        future: PengaturanBahasa().dataDiri(),
        builder: (context, snapshot) {
          if(snapshot.connectionState == ConnectionState.done){
            return Scaffold(
              appBar: AppBar(centerTitle: true,
                  iconTheme: IconThemeData(color: CustomStyle.color15),
                  flexibleSpace: Image(
                    image: AssetImage(ValueImage.headerBiruDashboard),
                    fit: BoxFit.cover,
                  ),
                  backgroundColor: Colors.transparent,
                  title: Text(snapshot.data!.menuDataDiri!.dataDiri!.header!,
                    style: TextStyle(fontSize: CustomStyle.fontSizeTitle,color: CustomStyle.color15),
                  )),
              body: BlocBuilder<DataDiriBloc, DataDiriState>(
                  builder: (BuildContext context, DataDiriState state){
                    if(state is getDataDiriSuccessState)
                      return SingleChildScrollView(
                        child: Container(
                          width: MediaQuery.of(context).size.width,
                          margin: EdgeInsets.fromLTRB(21, 10, 10, 10),
                          child: Column(
                            mainAxisAlignment: MainAxisAlignment.start,
                            crossAxisAlignment: CrossAxisAlignment.start,
                            children: [
                              Container(
                                child: Column(
                                  crossAxisAlignment: CrossAxisAlignment.start,
                                  children: [
                                    SizedBox(height: 5),
                                    Row(
                                      mainAxisAlignment: MainAxisAlignment.spaceBetween,
                                      children: [
                                        Text(snapshot.data!.menuDataDiri!.dataDiri!.header!,style: TextStyle(color: CustomStyle.color1,fontWeight: FontWeight.bold)),
                                        Row(
                                          children: [
                                            GestureDetector(
                                              onTap: (){
                                                if(state.data!.buttonRevisi! && state.data!.ketRevisi != ""){
                                                  showDialog(context: context,
                                                      barrierDismissible: false,
                                                      builder: (_) => AlertDialog(
                                                        shape: RoundedRectangleBorder(borderRadius: BorderRadius.circular(13)),
                                                        title: Container(
                                                          padding: EdgeInsets.only(top: 13, bottom: 13),
                                                          decoration: BoxDecoration(
                                                              color: CustomStyle.color1,
                                                              borderRadius: BorderRadius.only(topLeft: Radius.circular(13), topRight: Radius.circular(13))
                                                          ),
                                                          child: Center(child: Text(snapshot.data!.menuDataDiri!.button!.catatanRevisi!, style: TextStyle(fontWeight: FontWeight.bold, color: Colors.white, fontSize: 17),)),
                                                        ),
                                                        titlePadding: EdgeInsets.all(0),
                                                        content: Container(
                                                          child: Column(
                                                            mainAxisSize: MainAxisSize.min,
                                                            children: [
                                                              TextFormField(
                                                                  minLines: 4,
                                                                  initialValue: state.data!.ketRevisi??"",
                                                                  maxLines: 6,
                                                                  style: TextStyle(fontSize: 13, color: Colors.black),
                                                                  decoration: InputDecoration(
                                                                      disabledBorder: OutlineInputBorder(
                                                                        borderRadius: BorderRadius.circular(13),
                                                                        borderSide: BorderSide(
                                                                          color: Colors.grey,
                                                                          width: 0.8,
                                                                        ),
                                                                      ),
                                                                      enabled: false,
                                                                      labelStyle: TextStyle(color: Colors.grey),
                                                                      fillColor: Colors.transparent,
                                                                      filled: true
                                                                  )
                                                              ),
                                                              SizedBox(height: 27),
                                                              Row(
                                                                children: [
                                                                  Expanded(
                                                                    child: TemplateButton(
                                                                      onClick: (){
                                                                        Navigator.pop(context);
                                                                      },
                                                                      label: snapshot.data!.menuDataDiri!.button!.btnTutup,
                                                                      color: Colors.transparent,
                                                                      contentColor: CustomStyle.color1,
                                                                      borderColor: CustomStyle.color1,
                                                                      fontSize: CustomStyle.fontSizeSmall,
                                                                      bold: true,
                                                                    ),
                                                                  ),
                                                                ],
                                                              )
                                                            ],
                                                          ),
                                                        ),
                                                      ));
                                                }
                                              },
                                              child: Container(
                                                  decoration: BoxDecoration(
                                                      color: Color(int.parse(state.data!.colorStatusPengajuan!)),
                                                      borderRadius: BorderRadius.circular(5)
                                                  ),
                                                  padding: EdgeInsets.all(5),
                                                  child: Text(state.data!.statusPengajuan!,style: TextStyle(color: Colors.grey.shade600,
                                                      fontWeight: FontWeight.w700, fontSize: 11))),
                                            ),
                                            SizedBox(width: 7),
                                            Container()
                                            // PopupMenuButton<String>(
                                            //   onSelected: (value) {
                                            //     if (value == 'Ubah Data')
                                            //       BlocProvider.of<NavigatorBloc>(context)
                                            //           .add(NavigateToHalamanEditDataPengajuanDataDiri(context));
                                            //     else{
                                            //       _showDialog(context, 'pengajuan');
                                            //     }
                                            //   },
                                            //   itemBuilder: (BuildContext context) {
                                            //     return {'Ubah Data','Hapus Data'}.map((String choice) {
                                            //       return PopupMenuItem<String>(
                                            //         value: choice,
                                            //         child: Text(choice, style: TextStyle(fontSize: 12),),
                                            //       );
                                            //     }).toList();
                                            //   },
                                            //   child: Icon(
                                            //     Icons.more_vert_sharp,
                                            //     color: CustomStyle.fontColorGrey,
                                            //   ),
                                            // )
                                          ],
                                        ),
                                      ],
                                    ),
                                    // SizedBox(height: 5),
                                    Container(child: Divider(thickness: 1),margin: EdgeInsets.only(right: 11)),
                                    SizedBox(height: 5)
                                  ],
                                ),
                              ),
                              formSee(snapshot.data!.menuDataDiri!.dataDiri!.nomorIndukKaryawan!, state.data!.nik!),
                              formSee(snapshot.data!.menuDataDiri!.dataDiri!.namaLengkap!, state.data!.namaLengkap!),
                              formSee(snapshot.data!.menuDataDiri!.dataDiri!.pendidikanTerakhir!, state.data!.pendidikanTerakhir!),
                              Row(
                                children: [
                                  Expanded(child: formSee(snapshot.data!.menuDataDiri!.dataDiri!.gelarDepan!, state.data!.gelarDepan!)),
                                  Expanded(child: formSee(snapshot.data!.menuDataDiri!.dataDiri!.gelarBelakang!, state.data!.gelarBelakang!)),
                                ],
                              ),
                              Row(
                                children: [
                                  Expanded(child: formSee(snapshot.data!.menuDataDiri!.dataDiri!.jenisKelamin!, state.data!.jenisKelamin!)),
                                  Expanded(child: formSee(snapshot.data!.menuDataDiri!.dataDiri!.golonganDarah!, state.data!.golonganDarah!)),
                                ],
                              ),
                              Row(
                                children: [
                                  Expanded(child: formSee(snapshot.data!.menuDataDiri!.dataDiri!.tempatLahir!, state.data!.tempatLahir!)),
                                  Expanded(child: formSee(snapshot.data!.menuDataDiri!.dataDiri!.tanggalLahir!, state.data!.tglLahir!)),
                                ],
                              ),
                              Row(
                                children: [
                                  Expanded(child: formSee(snapshot.data!.menuDataDiri!.dataDiri!.noTelepon!, state.data!.telepon!)),
                                  Expanded(child: formSee(snapshot.data!.menuDataDiri!.dataDiri!.agama!, state.data!.agama!)),
                                ],
                              ),
                              Row(
                                children: [
                                  Expanded(child: formSee(snapshot.data!.menuDataDiri!.dataDiri!.noIndukKependudukan!, state.data!.noKtp!)),
                                  Expanded(child: formSee(snapshot.data!.menuDataDiri!.dataDiri!.noBpjsKes!, state.data!.noBpjsKes!)),
                                ],
                              ),
                              Row(
                                children: [
                                  Expanded(child: formSee(snapshot.data!.menuDataDiri!.dataDiri!.noBpjsTk!, state.data!.noBpjsTk!)),
                                  Expanded(child: formSee("", "")),
                                ],
                              ),
                              Container(
                                  margin: EdgeInsets.only(top: 15),
                                  child: Column(
                                    crossAxisAlignment: CrossAxisAlignment.start,
                                    children: [
                                      SizedBox(height: 5),
                                      Text(snapshot.data!.menuDataDiri!.dataAlamat!.header!,style: TextStyle(color: CustomStyle.color1,fontWeight: FontWeight.bold)),
                                      SizedBox(height: 5),
                                      Divider(thickness: 1),
                                      SizedBox(height: 5)
                                    ],
                                  )
                              ),
                              Row(
                                children: [
                                  Expanded(child: formSee(snapshot.data!.menuDataDiri!.dataAlamat!.provinsi!, state.data!.namaProvinsi!)),
                                  Expanded(child: formSee(snapshot.data!.menuDataDiri!.dataAlamat!.kabupaten!, state.data!.namaKabupaten!)),
                                ],
                              ),
                              Row(
                                children: [
                                  Expanded(child: formSee(snapshot.data!.menuDataDiri!.dataAlamat!.kecamatan!, state.data!.namaKecamatan!)),
                                  Expanded(child: formSee(snapshot.data!.menuDataDiri!.dataAlamat!.kelurahan!, state.data!.namaKelurahan!)),
                                ],
                              ),
                              Row(
                                children: [
                                  Expanded(child: formSee(snapshot.data!.menuDataDiri!.dataAlamat!.rt!, state.data!.rt == null ? "-" : state.data!.rt == "" ? "-" : state.data!.rt!)),
                                  Expanded(child: formSee(snapshot.data!.menuDataDiri!.dataAlamat!.rw!, state.data!.rw == null ? "-" : state.data!.rw == "" ? "-" : state.data!.rw!)),
                                ],
                              ),
                              Row(
                                children: [
                                  Expanded(child: formSee(snapshot.data!.menuDataDiri!.dataAlamat!.alamatDomisili!, state.data!.alamatDomisili == null ? "-" : state.data!.alamatDomisili == "" ? "-" : state.data!.alamatDomisili!)),
                                  Expanded(child: formSee(snapshot.data!.menuDataDiri!.dataAlamat!.kodePos!, state.data!.kodePos == null ? "-" : state.data!.kodePos == "" ? "-" : state.data!.kodePos!)),
                                ],
                              ),
                            ],
                          ),
                        ),
                      );

                    else if(state is DataDiriProgressState) return Center(child: CircularProgressIndicator(strokeWidth: 8,),);
                    else return Center(child: Image.asset(ValueImage.noData, height: 250,),);
                  }
              ),
            );
          }else{
            return Container();
          }
        }
      )
    );
  }

  Widget formSee(String title, String data){
    return Container(
      margin: EdgeInsets.only(bottom: 15, left: 15, right: 15),
      child: Column(
        mainAxisAlignment: MainAxisAlignment.start,
        crossAxisAlignment: CrossAxisAlignment.start,
        children: [
          Text(
              title,
              style: TextStyle(color: Color(0xFF828282), fontSize: 11.5)),
          SizedBox(height: 3),
          Text(
              data,
              style: TextStyle(color: Colors.black, fontWeight: FontWeight.w500, fontSize: 13)),
        ],
      ),
    );
  }

}
