import 'package:absenkuv3/Bloc/AuthBloc.dart';
import 'package:absenkuv3/Bloc/NavigatorBloc.dart';
import 'package:absenkuv3/Repository/Model/PageModel/mAktivitasPage.dart';
import 'package:absenkuv3/Repository/Model/mLogin.dart';
import 'package:absenkuv3/Setting/PengaturanBahasa.dart';
import 'package:absenkuv3/Setting/value_image.dart';
import 'package:absenkuv3/UI/Template/style.dart';
import 'package:flutter/material.dart';
import 'package:flutter_bloc/flutter_bloc.dart';
import 'HalamanListAktivitasPegawai.dart';
import 'HalamanListAktivitasSaya.dart';

class ParentTabAktivitas extends StatelessWidget {
  final int tabLength = 2;
  @override
  Widget build(BuildContext context) {
    return FutureBuilder<PageAktivitasModel>(
        future: PengaturanBahasa().aktivitas(),
        builder: (context, snapshot) {
          if(snapshot.connectionState == ConnectionState.done){
            return BlocBuilder<AuthBloc, LoginRespon>(
                builder: (BuildContext context, LoginRespon loginRespon) {
                  return DefaultTabController(
                    length: tabLength,
                    child: Scaffold(
                      appBar: AppBar(
                        centerTitle: true,
                        flexibleSpace: Image(
                          image: AssetImage(ValueImage.headerBiruDashboard),
                          fit: BoxFit.cover,
                        ),
                        backgroundColor: Colors.transparent,
                        title: Text(
                          snapshot.data!.menuAktivitas!.title!,
                          style: TextStyle(fontSize: CustomStyle.fontSizeTitle),
                        ),
                        bottom: loginRespon.dataLogin!.level != 3
                            ? TabBar(
                          labelPadding: EdgeInsets.all(0),
                          indicatorSize: TabBarIndicatorSize.tab,
                          indicatorWeight: 4,
                          isScrollable: true,
                          tabs: [
                            Container(
                              width: MediaQuery.of(context).size.width / tabLength,
                              child: Tab(
                                text: snapshot.data!.menuAktivitas!.tabSaya,
                              ),
                            ),
                            Container(
                              width: MediaQuery.of(context).size.width / tabLength,
                              child: Tab(
                                text: snapshot.data!.menuAktivitas!.tabKaryawan,
                              ),
                            ),
                          ],
                        )
                            : null,
                        actions: [
                          GestureDetector(
                            onTap: () => BlocProvider.of<NavigatorBloc>(context)
                                .add(NavigateToPengajuanAktivitas(context)),
                            child: Container(
                                margin: EdgeInsets.only(right: 14),
                                child: Icon(
                                  Icons.add,
                                  size: 26,
                                )),
                          ),
                        ],
                      ),
                      body: TabBarView(
                        physics: NeverScrollableScrollPhysics(),
                        children: [
                          HalamanListAktivitasSaya(snapshot.data!),
                          HalamanListAktivitasPegawai(snapshot.data!),
                        ],
                      ),
                    ),
                  );
                });
          }else{
            return CircularProgressIndicator(strokeWidth: 8);
          }
        }
    );
  }
}
