import 'package:absenkuv3/Bloc/Aktivitas/AktivitasBloc.dart';
import 'package:absenkuv3/Repository/Model/PageModel/mAktivitasPage.dart';
import 'package:absenkuv3/Repository/Model/mFilter.dart';
import 'package:absenkuv3/Setting/value_image.dart';
import 'package:absenkuv3/UI/Template/DateRangePicker/Bloc/DateRangePickerBloc.dart';
import 'package:absenkuv3/UI/Template/DateRangePicker/UI/templateDateRangePicker.dart';
import 'package:absenkuv3/UI/Template/FilterToggle/UI/templateFilterTogle.dart';
import 'package:flutter/material.dart';
import 'package:flutter_bloc/flutter_bloc.dart';
import 'KomponenAktivitas.dart';


class HalamanListAktivitasSaya extends StatefulWidget {
  PageAktivitasModel redaksional;
  HalamanListAktivitasSaya(this.redaksional);

  @override
  _HalamanListAktivitasSayaState createState() => _HalamanListAktivitasSayaState();
}

class _HalamanListAktivitasSayaState extends State<HalamanListAktivitasSaya> {
  final GlobalKey<ScaffoldState> scaffoldKey = GlobalKey<ScaffoldState>();
  ScrollController _scrollController = new ScrollController();

  @override
  void initState() {
    super.initState();
    BlocProvider.of<DateRangePickerBloc>(context).add(SetDate([DateTime.now(),DateTime.now()]));
    BlocProvider.of<AktivitasBloc>(context).add(getListAktivitasEvent(context, null));
    _scrollController.addListener(()=>BlocProvider.of<AktivitasBloc>(context).add(loadMoreEvent(context, scaffoldKey, _scrollController)));
  }
  @override
  Widget build(BuildContext context) {
    return Scaffold(
      key: scaffoldKey,
      body: Stack(
        children: [
          BlocBuilder<AktivitasBloc, AktivitasState>(
              builder: (BuildContext context, AktivitasState state){
                if(state is getListAktivitasSuccessState || state is LoadMoreProgressState)
                  return Stack(
                    children: <Widget>[
                      ListView.builder(
                          physics: AlwaysScrollableScrollPhysics(),
                          controller: _scrollController,
                          itemCount: state.data!.length,
                          itemBuilder: (BuildContext context, index) {
                            return CardAktivitas(state.data![index],scaffoldKey, 'aktivitasSaya', widget.redaksional);
                          }
                      ),
                      state is LoadMoreProgressState? Positioned(
                          bottom :16,
                          child: Container(
                              width: MediaQuery.of(context).size.width,
                              child: Center(child: CircularProgressIndicator(strokeWidth: 8,)))):Container(),
                    ],
                  );
                else if(state is AktivitasProgressState) return Center(child: CircularProgressIndicator(strokeWidth: 8,),);
                else return Center(child: Image.asset(ValueImage.noData, height: 250,),);
              }),
          Positioned(
            bottom: 16,
            right: 14,
            child: BlocListener<DateRangePickerBloc, DateRangePickerState>(
              listener: (BuildContext context, DateRangePickerState dateRangePickerState){
                if(dateRangePickerState is DateAvailable) BlocProvider.of<AktivitasBloc>(context).add(getListAktivitasEvent(context, ModelFilter(dateRange: dateRangePickerState.date)));
              },
              child: TemplateFilterToggle(),
            ),
          ),
        ],
      ),
    );
  }
}


