import 'package:absenkuv3/Bloc/Aktivitas/AktivitasPegawaiBloc.dart';
import 'package:absenkuv3/Bloc/FilterBottomSheetBloc.dart';
import 'package:absenkuv3/Repository/Model/PageModel/mAktivitasPage.dart';
import 'package:absenkuv3/Repository/Model/mFilter.dart';
import 'package:absenkuv3/Setting/value_image.dart';
import 'package:absenkuv3/UI/Template/DateRangePicker/Bloc/DateRangePickerBloc.dart';
import 'package:absenkuv3/UI/Template/FilterBottomSheet.dart';
import 'package:absenkuv3/UI/Template/FilterHeaderSheet.dart';
import 'package:flutter/material.dart';
import 'package:flutter_bloc/flutter_bloc.dart';
import 'KomponenAktivitas.dart';

class HalamanListAktivitasPegawai extends StatefulWidget {
  final PageAktivitasModel redaksional;
  HalamanListAktivitasPegawai(this.redaksional);

  @override
  _HalamanListAktivitasPegawaiState createState() =>
      _HalamanListAktivitasPegawaiState();
}

class _HalamanListAktivitasPegawaiState
    extends State<HalamanListAktivitasPegawai> {
  final GlobalKey<ScaffoldState> scaffoldKey = GlobalKey<ScaffoldState>();
  ScrollController _scrollController = new ScrollController();
  ModelFilter? modelFilter;

  @override
  void initState() {
    super.initState();
    BlocProvider.of<DateRangePickerBloc>(context)
        .add(SetDate([DateTime.now(), DateTime.now()]));
        
    BlocProvider.of<AktivitasPegawaiBloc>(context)
        .add(getListAktivitasEvent(context, null));
    _scrollController.addListener(() =>
        BlocProvider.of<AktivitasPegawaiBloc>(context)
            .add(loadMoreEvent(context, scaffoldKey, _scrollController)));
  }

  @override
  Widget build(BuildContext context) {
    return Scaffold(
      key: scaffoldKey,
      body: Stack(
        children: [
          Column(
            children: [
              Container(
                height: 50,
                width: MediaQuery.of(context).size.width * 1.5,
                child: BlocListener<FilterBottomSheetBloc, FilterBottomSheetState>(
                listener: (BuildContext context, FilterBottomSheetState state) {
                  if (state is setFilterSuccess) {
                    modelFilter = state.modelFilter;
                    BlocProvider.of<AktivitasPegawaiBloc>(context)
                        .add(getListAktivitasEvent(context, modelFilter));
                    // modelFilterDataAbsensi = state.modelFilter;
                    // BlocProvider.of<DataAbsensiPegawaiBloc>(context).add(
                    //     getListDataAbsensiKaryawanEvent(
                    //         context, modelFilterDataAbsensi));
                  }
                },
                child: FilterHeaderSheet()),
              ),
            ],
          ),
          
          Padding(
            padding: const EdgeInsets.only(top: 50),
            child: BlocBuilder<AktivitasPegawaiBloc, AktivitasPegawaiState>(
                builder: (BuildContext context, AktivitasPegawaiState state) {
              if (state is getListAktivitasSuccessState ||
                  state is LoadMoreProgressState)
                return Stack(
                  children: <Widget>[
                    ListView.builder(
                        physics: AlwaysScrollableScrollPhysics(),
                        controller: _scrollController,
                        itemCount: state.data!.length,
                        itemBuilder: (BuildContext context, index) {
                          return CardAktivitas(state.data![index], scaffoldKey,
                              'aktivitasPegawai', widget.redaksional);
                        }),
                    state is LoadMoreProgressState
                        ? Positioned(
                            bottom: 16,
                            child: Container(
                                width: MediaQuery.of(context).size.width,
                                child: Center(
                                    child: CircularProgressIndicator(
                                  strokeWidth: 8,
                                ))))
                        : Container(),
                  ],
                );
              else if (state is AktivitasProgressState)
                return Center(
                  child: CircularProgressIndicator(
                    strokeWidth: 8,
                  ),
                );
              else
                return Center(
                  child: Image.asset(
                    ValueImage.noData,
                    height: 250,
                  ),
                );
            }),
          ),
        ],
      ),
    );
  }
}
