import 'dart:async';

import 'package:flutter/material.dart';
import 'package:geolocator/geolocator.dart';
import 'package:google_maps_flutter/google_maps_flutter.dart';

class MapWidget extends StatelessWidget {
  final Completer<GoogleMapController> controller;
  final CameraPosition initialPosition;
  final Set<Marker> markers;
  final Future<void> Function(GoogleMapController, Position) animateCamera;

  const MapWidget({
    required this.controller,
    required this.initialPosition,
    required this.markers,
    required this.animateCamera,
  });

  @override
  Widget build(BuildContext context) {
    return GoogleMap(
      myLocationButtonEnabled: true,
      compassEnabled: true,
      zoomControlsEnabled: false,
      initialCameraPosition: initialPosition,
      mapType: MapType.normal,
      onMapCreated: (GoogleMapController controllers) {
        controller.complete(controllers);
      },
      markers: markers,
    );
  }
}
