import 'package:absenkuv3/Bloc/NavigatorBloc.dart';
import 'package:absenkuv3/Repository/Model/PageModel/mDataAbsensiPage.dart';
import 'package:absenkuv3/Repository/Model/mAbsensi.dart';
import 'package:absenkuv3/UI/Template/halamanDetailMap.dart';
import 'package:absenkuv3/UI/Template/style.dart';
import 'package:absenkuv3/UI/Template/templateButton.dart';
import 'package:flutter/material.dart';
import 'package:flutter_bloc/flutter_bloc.dart';
import 'package:intl/intl.dart';

class CardAbsensi extends StatefulWidget {
  final DataRekapAbsensi dataRekapAbsensi;
  final PageDataAbsensiModel redaksional;
  final bool absensiPegawai;

  CardAbsensi(this.dataRekapAbsensi, this.redaksional,
      {this.absensiPegawai = false});

  @override
  _CardAbsensiState createState() => _CardAbsensiState();
}

class _CardAbsensiState extends State<CardAbsensi> {
  @override
  Widget build(BuildContext context) {
    String idKaryawan = widget.dataRekapAbsensi.idKaryawan!;
    String tgl = widget.dataRekapAbsensi.tglAbsensi!;
    DateTime dateTime = DateTime.parse(tgl);
    return GestureDetector(
        onTap: () => widget.dataRekapAbsensi.warna!.enableDetail!
            ? BlocProvider.of<NavigatorBloc>(context).add(
                NavigateToDetailListRekapAbsensi(context, [idKaryawan, tgl]))
            : null,
        child: Container(
          decoration: BoxDecoration(
              color: Color(int.parse(widget.dataRekapAbsensi.warna!.color!)),
              borderRadius:
                  BorderRadius.all(Radius.circular(CustomStyle.cardRadius))),
          margin: EdgeInsets.only(top: 12, left: 12, right: 12),
          padding: EdgeInsets.only(left: 5),
          child: Container(
            decoration: CustomStyle.boxDecoration2,
            child: Row(
              children: [
                const SizedBox(
                  width: 12,
                ),
                Expanded(
                  flex: 1,
                  child: Column(
                    crossAxisAlignment: CrossAxisAlignment.center,
                    children: [
                      Text(
                        DateFormat.MMM(
                                widget.redaksional.menuDataAbsensi!.locale)
                            .format(dateTime),
                        style: TextStyle(
                            fontSize: 14,
                            color: CustomStyle.fontColorGrey,
                            fontWeight: FontWeight.w400),
                      ),
                      SizedBox(
                        height: 6,
                      ),
                      Text(DateFormat('dd').format(dateTime),
                          style: TextStyle(
                              fontSize: 16, fontWeight: FontWeight.w600)),
                    ],
                  ),
                ),
                VDivider(),
                Expanded(
                  flex: 8,
                  child: Container(
                    width: MediaQuery.of(context).size.width,
                    child: Row(
                      mainAxisAlignment: MainAxisAlignment.spaceBetween,
                      children: [
                        Expanded(
                          child: Column(
                            crossAxisAlignment: CrossAxisAlignment.start,
                            children: [
                              Row(
                                crossAxisAlignment: CrossAxisAlignment.start,
                                children: [
                                  Text(widget.dataRekapAbsensi.hariAbsensi!,
                                      style: TextStyle(
                                          fontSize: 14,
                                          fontWeight: FontWeight.w600)),
                                  SizedBox(
                                    width: 8,
                                  ),
                                  Wrap(
                                    spacing: 1,
                                    runSpacing: 1,
                                    children: widget
                                        .dataRekapAbsensi.kodeAbsensi!
                                        .map(
                                          (item) => Container(
                                              padding:
                                                  EdgeInsets.only(bottom: 4),
                                              child: TemplateButton(
                                                label: item.kodeAbsensi,
                                                fontSize: 12,
                                                color: Colors.redAccent,
                                                heightButton: 18,
                                                radius: 4,
                                                paddingTopBottom: 0,
                                                paddingLeftRight: 8,
                                                contentColor: Colors.white,
                                                bold: true,
                                              )),
                                        )
                                        .toList(),
                                  )
                                ],
                              ),
                              SizedBox(
                                height: widget.dataRekapAbsensi.kodeAbsensi!
                                            .length >
                                        0
                                    ? 0
                                    : 4,
                              ),
                              widget.absensiPegawai
                                  ? Column(
                                      children: [
                                        Text(
                                            widget
                                                .dataRekapAbsensi.namaKaryawan!,
                                            style: TextStyle(
                                                fontSize: 12,
                                                fontWeight: FontWeight.w400)),
                                        // SizedBox(
                                        //   height: 4,
                                        // ),
                                        SizedBox(
                                          height: widget.dataRekapAbsensi
                                                      .kodeAbsensi!.length >
                                                  0
                                              ? 2
                                              : 4,
                                        ),
                                      ],
                                    )
                                  : Container(),
                              Text(
                                widget.dataRekapAbsensi.jenisAbsensi!,
                                style: TextStyle(
                                    fontSize: 12,
                                    color: CustomStyle.fontColorGrey,
                                    fontWeight: FontWeight.w400),
                              )
                            ],
                          ),
                        ),
                        widget.dataRekapAbsensi.labelMasukPulang!
                            ? Row(
                                children: [
                                  SizedBox(width: 3,),
                                  Column(
                                    children: [
                                      Row(
                                        children: [
                                          Container(
                                            margin: EdgeInsets.only(right: 4),
                                            width: 5,
                                            height: 5,
                                            decoration: BoxDecoration(
                                                color: Colors.green,
                                                borderRadius:
                                                    BorderRadius.circular(10)),
                                          ),
                                          Text(
                                              widget
                                                  .redaksional
                                                  .menuDataAbsensi!
                                                  .data!
                                                  .masuk!,
                                              style: TextStyle(
                                                  fontSize: 12,
                                                  fontWeight: FontWeight.w500)),
                                        ],
                                      ),
                                      SizedBox(
                                        height: 4,
                                      ),
                                      Text(
                                        widget.dataRekapAbsensi.absenMasuk!,
                                        style: TextStyle(
                                            color: Colors.blue,
                                            fontSize: 19,
                                            fontWeight: FontWeight.w500),
                                      ),
                                    ],
                                  ),
                                  VDivider(),
                                  Column(
                                    children: [
                                      Row(
                                        children: [
                                          Container(
                                            margin: EdgeInsets.only(right: 4),
                                            width: 5,
                                            height: 5,
                                            decoration: BoxDecoration(
                                                color: Colors.red,
                                                borderRadius:
                                                    BorderRadius.circular(10)),
                                          ),
                                          Text(
                                              widget
                                                  .redaksional
                                                  .menuDataAbsensi!
                                                  .data!
                                                  .pulang!,
                                              style: TextStyle(
                                                  fontSize: 12,
                                                  fontWeight: FontWeight.w500)),
                                        ],
                                      ),
                                      SizedBox(
                                        height: 4,
                                      ),
                                      Text(
                                        widget.dataRekapAbsensi.absenPulang!,
                                        style: TextStyle(
                                            color: Colors.blue,
                                            fontSize: 19,
                                            fontWeight: FontWeight.w500),
                                      ),
                                    ],
                                  ),
                                  SizedBox(
                                    width: 8,
                                  ),
                                ],
                              )
                            : Container()
                      ],
                    ),
                  ),
                )
              ],
            ),
          ),
        ));
  }
}

class VDivider extends StatelessWidget {
  const VDivider({
    super.key,
  });

  @override
  Widget build(BuildContext context) {
    return Container(
      height: 75,
      margin: EdgeInsets.symmetric(horizontal: 12),
      decoration: BoxDecoration(
        border: Border(
          right: BorderSide(
            color: Theme.of(context).dividerColor,
            width: 2,
          ),
        ),
      ),
    );
  }
}

class TombolIcon extends StatelessWidget {
  final IconData? icon;
  final Color bgnColor;
  final Color iconColor;
  final double? size;
  final gradient;
  final onClick;

  TombolIcon(
      {this.icon,
      this.onClick,
      this.bgnColor = Colors.white,
      this.size,
      this.iconColor = Colors.grey,
      this.gradient});

  @override
  Widget build(BuildContext context) {
    return GestureDetector(
      onTap: onClick,
      child: Container(
          decoration: BoxDecoration(boxShadow: [
            BoxShadow(
              color: Colors.grey.withOpacity(0.4),
              spreadRadius: 2,
              blurRadius: 5,
              offset: Offset(0, 1), // changes position of shadow
            ),
          ], gradient: gradient, color: bgnColor, shape: BoxShape.circle),
          child: Padding(
            padding: const EdgeInsets.all(8.0),
            child: Icon(
              icon,
              color: iconColor,
              size: size,
            ),
          )),
    );
  }
  
}
class CustomRadioButton extends StatelessWidget {
  final bool isSelected;
  final VoidCallback onTap;
  final Color activeColor;
  final Color hoverColor;

  CustomRadioButton({
    required this.isSelected,
    required this.onTap,
    required this.activeColor,
    required this.hoverColor,
  });

  @override
  Widget build(BuildContext context) {
    return GestureDetector(
      onTap: onTap,
      child: MouseRegion(
        onEnter: (_) {
          // Jika pointer masuk (hover), ubah warna hover
        },
        onExit: (_) {
          // Jika pointer keluar dari area (hover), kembalikan warna normal
        },
        child: CustomPaint(
          size: Size(30, 30),  // Ukuran radio button
          painter: RadioPainter(isSelected, activeColor, hoverColor),
        ),
      ),
    );
  }
}

class RadioPainter extends CustomPainter {
  final bool isSelected;
  final Color activeColor;
  final Color hoverColor;

  RadioPainter(this.isSelected, this.activeColor, this.hoverColor);

  @override
  void paint(Canvas canvas, Size size) {
    final Paint paint = Paint()
      ..color = isSelected ? activeColor : hoverColor
      ..style = PaintingStyle.fill;

    // Menggambar lingkaran luar untuk radio button
    canvas.drawCircle(Offset(size.width / 2, size.height / 2), size.width / 2, paint);

    if (isSelected) {
      final Paint innerPaint = Paint()
        ..color = Colors.white
        ..style = PaintingStyle.fill;
      
      // Menggambar lingkaran kecil di dalam radio button
      canvas.drawCircle(Offset(size.width / 2, size.height / 2), size.width / 4, innerPaint);
    }
  }

  @override
  bool shouldRepaint(covariant CustomPainter oldDelegate) {
    return false;
  }
}

