import 'package:absenkuv3/Repository/Model/PageModel/mAbsensiPage.dart';
import 'package:absenkuv3/Repository/Model/PageModel/mAktivitasPage.dart';
import 'package:absenkuv3/Repository/Model/PageModel/mAkunPage.dart';
import 'package:absenkuv3/Repository/Model/PageModel/mBahasaPage.dart';
import 'package:absenkuv3/Repository/Model/PageModel/mBeritaPengumumanPage.dart';
import 'package:absenkuv3/Repository/Model/PageModel/mButtonPage.dart';
import 'package:absenkuv3/Repository/Model/PageModel/mCutiPage.dart';
import 'package:absenkuv3/Repository/Model/PageModel/mDashboardPage.dart';
import 'package:absenkuv3/Repository/Model/PageModel/mDataAbsensiPage.dart';
import 'package:absenkuv3/Repository/Model/PageModel/mDataDiriPage.dart';
import 'package:absenkuv3/Repository/Model/PageModel/mDataKelengkapanFilePage.dart';
import 'package:absenkuv3/Repository/Model/PageModel/mDataKeluargaPage.dart';
import 'package:absenkuv3/Repository/Model/PageModel/mDataKontakPegawaiPage.dart';
import 'package:absenkuv3/Repository/Model/PageModel/mDataPendidikanPage.dart';
import 'package:absenkuv3/Repository/Model/PageModel/mDataPengalamanKerjaPage.dart';
import 'package:absenkuv3/Repository/Model/PageModel/mDetailAbsensiPage.dart';
import 'package:absenkuv3/Repository/Model/PageModel/mInfoGajiPage.dart';
import 'package:absenkuv3/Repository/Model/PageModel/mIzinPage.dart';
import 'package:absenkuv3/Repository/Model/PageModel/mLemburPage.dart';
import 'package:absenkuv3/Repository/Model/PageModel/mLoginPage.dart';
import 'package:absenkuv3/Repository/Model/PageModel/mMonitorAbsenPage.dart';
import 'package:absenkuv3/Repository/Model/PageModel/mMessagePage.dart';
import 'package:absenkuv3/Repository/Model/PageModel/mNotifikasiPage.dart';
import 'package:absenkuv3/Repository/Model/PageModel/mParentTabPage.dart';
import 'package:absenkuv3/Repository/Model/PageModel/mPatroliPage.dart';
import 'package:absenkuv3/Repository/Model/PageModel/mPkwtPage.dart';
import 'package:absenkuv3/Repository/Model/PageModel/mRangkumanAbsensiPage.dart';
import 'package:absenkuv3/Repository/Model/PageModel/mReimbursementPage.dart';
import 'package:absenkuv3/Repository/Model/PageModel/mRekapPage.dart';
import 'package:absenkuv3/Repository/Model/PageModel/mShiftPage.dart';
import 'package:absenkuv3/Repository/Model/PageModel/mSlipGajiPage.dart';
import 'package:absenkuv3/Repository/Model/PageModel/mSosPage.dart';
import 'package:absenkuv3/Repository/Model/PageModel/mTukarShiftPage.dart';
import 'package:absenkuv3/Repository/Model/PageModel/mUbahPasswordPage.dart';
import 'package:absenkuv3/Repository/sharedPreference.dart';
import 'package:flutter/services.dart';

class PengaturanBahasa {

  Future<String> getDataBahasa() async {
    String bahasa = await sharedPreferences().getBahasa();
    return bahasa;
  }

  Future<PageParentTabModel> parentTab() async {
    String jsonString;
    String bahasa = await sharedPreferences().getBahasa();
    jsonString = await rootBundle.loadString('assets/$bahasa/parent_tab.json');
    PageParentTabModel data = pageParentTabModelFromJson(jsonString);
    return data;
  }

  Future<PageButtonModel> button() async {
    String jsonString;
    String bahasa = await sharedPreferences().getBahasa();
    jsonString = await rootBundle.loadString('assets/$bahasa/template/button.json');
    PageButtonModel data = pageButtonModelFromJson(jsonString);
    return data;
  }

  Future<PageBahasaModel> language() async {
    String jsonString;
    String bahasa = await sharedPreferences().getBahasa();
    jsonString = await rootBundle.loadString('assets/$bahasa/bahasa.json');
    PageBahasaModel data = pageBahasaModelFromJson(jsonString);
    return data;
  }

  Future<PageNotifikasiModel> notifikasi() async {
    String jsonString;
    String bahasa = await sharedPreferences().getBahasa();
    jsonString = await rootBundle.loadString('assets/$bahasa/notifikasi.json');
    PageNotifikasiModel data = pageNotifikasiModelFromJson(jsonString);
    return data;
  }

  Future<MessagePageModel> messageData() async {
    String jsonString;
    String bahasa = await sharedPreferences().getBahasa();
    jsonString = await rootBundle.loadString('assets/$bahasa/message.json');
    MessagePageModel data = pageMessageModelFromJson(jsonString);
    return data;
  }

  Future<PageDashboardModel> dashboard() async {
    String jsonString;
    String bahasa = await sharedPreferences().getBahasa();
    jsonString = await rootBundle.loadString('assets/$bahasa/dashboard.json');
    PageDashboardModel data = pageDashboardModelFromJson(jsonString);
    return data;
  }

  Future<PageIzinModel> izin() async {
    String jsonString;
    String bahasa = await sharedPreferences().getBahasa();
    jsonString = await rootBundle.loadString('assets/$bahasa/izin.json');
    PageIzinModel data = pageIzinModelFromJson(jsonString);
    return data;
  }

  Future<PageInfoGajiModel> infoGaji() async {
    String jsonString;
    String bahasa = await sharedPreferences().getBahasa();
    jsonString = await rootBundle.loadString('assets/$bahasa/info_gaji.json');
    PageInfoGajiModel data = pageInfoGajiModelFromJson(jsonString);
    return data;
  }

  Future<PageSlipGajiModel> slipGaji() async {
    String jsonString;
    String bahasa = await sharedPreferences().getBahasa();
    jsonString = await rootBundle.loadString('assets/$bahasa/slip_gaji.json');
    PageSlipGajiModel data = pageSlipGajiModelFromJson(jsonString);
    return data;
  }

  Future<PageBeritaPengumumanModel> beritaPengumuman() async {
    String jsonString;
    String bahasa = await sharedPreferences().getBahasa();
    jsonString = await rootBundle.loadString('assets/$bahasa/berita.json');
    PageBeritaPengumumanModel data = pageBeritaPengumumanModelFromJson(
        jsonString);
    return data;
  }

  Future<PageAktivitasModel> aktivitas() async {
    String jsonString;
    String bahasa = await sharedPreferences().getBahasa();
    jsonString = await rootBundle.loadString('assets/$bahasa/aktivitas.json');
    PageAktivitasModel data = pageAktivitasModelFromJson(jsonString);
    return data;
  }

  Future<PageLemburModel> lembur() async {
    String jsonString;
    String bahasa = await sharedPreferences().getBahasa();
    jsonString = await rootBundle.loadString('assets/$bahasa/lembur.json');
    PageLemburModel data = pageLemburModelFromJson(jsonString);
    data.menuLembur!.locale = bahasa;
    return data;
  }

  Future<PageAbsensiModel> absensi() async {
    String jsonString;
    String bahasa = await sharedPreferences().getBahasa();
    jsonString = await rootBundle.loadString('assets/$bahasa/absensi/absensi.json');
    PageAbsensiModel data = pageAbsensiModelFromJson(jsonString);
    return data;
  }

  Future<PageDataAbsensiModel> dataAbsensi() async {
    String jsonString;
    String bahasa = await sharedPreferences().getBahasa();
    jsonString = await rootBundle.loadString('assets/$bahasa/absensi/data_absensi.json');
    PageDataAbsensiModel data = pageDataAbsensiModelFromJson(jsonString);
    data.menuDataAbsensi!.locale = bahasa;
    return data;
  }

  Future<PageDetailAbsensiModel> detailAbsensi() async {
    String jsonString;
    String bahasa = await sharedPreferences().getBahasa();
    jsonString = await rootBundle.loadString('assets/$bahasa/absensi/detail_absensi.json');
    PageDetailAbsensiModel data = pageDetailAbsensiModelFromJson(jsonString);
    return data;
  }

  Future<PageRangkumanAbsensiModel> rangkumanAbsensi() async {
    String jsonString;
    String bahasa = await sharedPreferences().getBahasa();
    jsonString = await rootBundle.loadString('assets/$bahasa/absensi/rangkuman_absensi.json');
    PageRangkumanAbsensiModel data = pageRangkumanAbsensiModelFromJson(jsonString);
    return data;
  }

  Future<PageRekapModel> rekap() async {
    String jsonString;
    String bahasa = await sharedPreferences().getBahasa();
    jsonString = await rootBundle.loadString('assets/$bahasa/rekap.json');
    PageRekapModel data = pageRekapModelFromJson(jsonString);
    return data;
  }

  Future<PageShiftModel> shift() async {
    String jsonString;
    String bahasa = await sharedPreferences().getBahasa();
    jsonString = await rootBundle.loadString('assets/$bahasa/shift.json');
    PageShiftModel data = pageShiftModelFromJson(jsonString);
    data.menuShift!.locale = bahasa;
    return data;
  }

  Future<PageTukarShiftModel> tukarShift() async {
    String jsonString;
    String bahasa = await sharedPreferences().getBahasa();
    jsonString = await rootBundle.loadString('assets/$bahasa/tukar_shift.json');
    PageTukarShiftModel data = pageTukarShiftModelFromJson(jsonString);
    data.menuTukarShift!.locale = bahasa;
    return data;
  }

  Future<PageReimbursementModel> reimbursement() async {
    String jsonString;
    String bahasa = await sharedPreferences().getBahasa();
    jsonString = await rootBundle.loadString('assets/$bahasa/reimbursement.json');
    PageReimbursementModel data = pageReimbursementModelFromJson(jsonString);
    data.menuReimbursement!.locale = bahasa;
    return data;
  }

  Future<PageAkunModel> akun() async {
    String jsonString;
    String bahasa = await sharedPreferences().getBahasa();
    jsonString = await rootBundle.loadString('assets/$bahasa/akun.json');
    PageAkunModel data = pageAkunModelFromJson(jsonString);
    data.menuAkun!.locale = bahasa;
    return data;
  }

  Future<PageDataDiriModel> dataDiri() async {
    String jsonString;
    String bahasa = await sharedPreferences().getBahasa();
    jsonString = await rootBundle.loadString('assets/$bahasa/data_diri.json');
    PageDataDiriModel data = pageDataDiriModelFromJson(jsonString);
    data.menuDataDiri!.locale = bahasa;
    return data;
  }

  Future<PageDataKeluargaModel> dataKeluarga() async {
    String jsonString;
    String bahasa = await sharedPreferences().getBahasa();
    jsonString = await rootBundle.loadString('assets/$bahasa/data_keluarga.json');
    PageDataKeluargaModel data = pageDataKeluargaModelFromJson(jsonString);
    data.menuDataKeluarga!.locale = bahasa;
    return data;
  }

  Future<PageDataPendidikanModel> dataPendidikan() async {
    String jsonString;
    String bahasa = await sharedPreferences().getBahasa();
    jsonString = await rootBundle.loadString('assets/$bahasa/data_pendidikan.json');
    PageDataPendidikanModel data = pageDataPendidikanModelFromJson(jsonString);
    data.menuDataPendidikan!.locale = bahasa;
    return data;
  }

  Future<PageDataPengalamanKerjaModel> dataPengalamanKerja() async {
    String jsonString;
    String bahasa = await sharedPreferences().getBahasa();
    jsonString = await rootBundle.loadString('assets/$bahasa/data_pengalaman_kerja.json');
    PageDataPengalamanKerjaModel data = pageDataPengalamanKerjaModelFromJson(jsonString);
    data.menuDataPengalamanKerja!.locale = bahasa;
    return data;
  }

  Future<PageDataKelengkapanFileModel> dataKelengkapanFile() async {
    String jsonString;
    String bahasa = await sharedPreferences().getBahasa();
    jsonString = await rootBundle.loadString('assets/$bahasa/data_kelengkapan_file.json');
    PageDataKelengkapanFileModel data = pageDataKelengkapanFileModelFromJson(jsonString);
    data.menuDataKelengkapanFile!.locale = bahasa;
    return data;
  }

  Future<PageUbahPasswordModel> ubahPassword() async {
    String jsonString;
    String bahasa = await sharedPreferences().getBahasa();
    jsonString = await rootBundle.loadString('assets/$bahasa/ubah_password.json');
    PageUbahPasswordModel data = pageUbahPasswordModelFromJson(jsonString);
    data.menuUbahPassword!.locale = bahasa;
    return data;
  }

  Future<PageLoginModel> login() async {
    String jsonString;
    String bahasa = await sharedPreferences().getBahasa();
    print("hai : $bahasa");
    jsonString = await rootBundle.loadString('assets/$bahasa/login.json');
    PageLoginModel data = pageLoginModelFromJson(jsonString);
    data.locale = bahasa;
    return data;
  }
  Future<PageMonitorAbsenModel> monitorAbsen() async {
    String jsonString;
    String bahasa = await sharedPreferences().getBahasa();
    if (bahasa == 'id') {
      jsonString = await rootBundle.loadString('assets/id/absensi/data_monitor_absensi.json');
    } else {
      jsonString = await rootBundle.loadString('assets/en/absensi/data_monitor_absensi.json');
    }
    PageMonitorAbsenModel data = pageMonitorAbsenModelFromJson(jsonString);
    data.menuMonitorAbsensi!.locale = bahasa;
    return data;
  }
  Future<PageKontakPegawaiModel> kontakPegawai() async {
    String jsonString;
    String bahasa = await sharedPreferences().getBahasa();
    if (bahasa == 'id') {
      jsonString = await rootBundle.loadString('assets/id/data_kontak_pegawai.json');
    } else {
      jsonString = await rootBundle.loadString('assets/en/data_kontak_pegawai.json');
    }
    PageKontakPegawaiModel data = pageKontakPegawaiModelFromJson(jsonString);
    data.menuDataKontakPegawai!.locale = bahasa;
    return data;
  }
  Future<PageCutiModel> cuti() async {
    String jsonString;
    String bahasa = await sharedPreferences().getBahasa();
    jsonString = await rootBundle.loadString('assets/$bahasa/cuti.json');
    PageCutiModel data = pageCutiModelFromJson(jsonString);
    return data;
  }
  Future<PagePatroliModel> patroli() async {
    String jsonString;
    String bahasa = await sharedPreferences().getBahasa();
    jsonString = await rootBundle.loadString('assets/$bahasa/patroli.json');
    PagePatroliModel data = pagePatroliModelFromJson(jsonString);
    return data;
  }
  Future<PageSosModel> sos() async {
    String jsonString;
    String bahasa = await sharedPreferences().getBahasa();
    jsonString = await rootBundle.loadString('assets/$bahasa/sos.json');
    PageSosModel data = pageSosModelFromJson(jsonString);
    return data;
  }
  Future<PagePkwtModel> pkwt() async {
    String jsonString;
    String bahasa = await sharedPreferences().getBahasa();
    jsonString = await rootBundle.loadString('assets/$bahasa/pkwt.json');
    PagePkwtModel data = pagePkwtModelFromJson(jsonString);
    return data;
  }
}