import 'package:absenkuv3/Bloc/AuthBloc.dart';
import 'package:absenkuv3/Repository/Model/mLogin.dart';
import 'package:absenkuv3/Repository/Model/mSplashScreen.dart';
import 'package:absenkuv3/Repository/Model/mSsoLogin.dart';
import 'package:absenkuv3/Repository/Model/mUser.dart';
import 'package:absenkuv3/Setting/Header.dart';
import 'package:dio/dio.dart';
import 'package:firebase_messaging/firebase_messaging.dart';
import 'dart:convert';
import 'package:crypto/crypto.dart';
import 'package:pretty_dio_logger/pretty_dio_logger.dart';
import '../sharedPreference.dart';
import 'serviceInfo.dart';

class UserApi {
  Dio dio = ServerInfo().getConnection();
  var idKaryawan = "";
  var idCompany = "";

  Future<LoginRespon> login(AuthEvent event) async {
    // var respon = await dio.get("users/login", queryParameters: {
    //   "username": event.username,
    //   "password": event.password,
    //   "token_fcm": event.mDeviceInfo.tokenFCM,
    //   "emulator" : !event.mDeviceInfo.emulator,
    //   "os"       : event.mDeviceInfo.os,
    //   "versi_os" : event.mDeviceInfo.versiOS,
    //   "base_os"  : event.mDeviceInfo.baseOS,
    //   "brand"    : event.mDeviceInfo.brand,
    //   "model"    : event.mDeviceInfo.model,
    //   "device_id" : event.mDeviceInfo.deviceId
    // });
    var respon = await dio.get("users/login",
        queryParameters: {
          sha1
                  .convert(utf8.encode(sha1
                      .convert(utf8.encode(
                          md5.convert(utf8.encode("username")).toString()))
                      .toString()))
                  .toString():
              sha1
                  .convert(utf8.encode(sha1
                      .convert(utf8.encode(
                          md5.convert(utf8.encode(event.username!)).toString()))
                      .toString()))
                  .toString(),
          sha1
                  .convert(utf8.encode(sha1
                      .convert(utf8.encode(
                          md5.convert(utf8.encode("password")).toString()))
                      .toString()))
                  .toString():
              sha1
                  .convert(utf8.encode(sha1
                      .convert(utf8.encode(
                          md5.convert(utf8.encode(event.password!)).toString()))
                      .toString()))
                  .toString(),
          sha1
              .convert(utf8.encode(sha1
                  .convert(utf8
                      .encode(md5.convert(utf8.encode("token_fcm")).toString()))
                  .toString()))
              .toString(): event.mDeviceInfo.tokenFCM,
          sha1
              .convert(utf8.encode(sha1
                  .convert(utf8
                      .encode(md5.convert(utf8.encode("emulator")).toString()))
                  .toString()))
              .toString(): !event.mDeviceInfo.emulator,
          sha1
              .convert(utf8.encode(sha1
                  .convert(
                      utf8.encode(md5.convert(utf8.encode("os")).toString()))
                  .toString()))
              .toString(): event.mDeviceInfo.os,
          sha1
              .convert(utf8.encode(sha1
                  .convert(utf8
                      .encode(md5.convert(utf8.encode("versi_os")).toString()))
                  .toString()))
              .toString(): event.mDeviceInfo.versiOS,
          sha1
              .convert(utf8.encode(sha1
                  .convert(utf8
                      .encode(md5.convert(utf8.encode("base_os")).toString()))
                  .toString()))
              .toString(): event.mDeviceInfo.baseOS,
          sha1
              .convert(utf8.encode(sha1
                  .convert(
                      utf8.encode(md5.convert(utf8.encode("brand")).toString()))
                  .toString()))
              .toString(): event.mDeviceInfo.brand,
          sha1
              .convert(utf8.encode(sha1
                  .convert(
                      utf8.encode(md5.convert(utf8.encode("model")).toString()))
                  .toString()))
              .toString(): event.mDeviceInfo.model,
          sha1
              .convert(utf8.encode(sha1
                  .convert(utf8
                      .encode(md5.convert(utf8.encode("device_id")).toString()))
                  .toString()))
              .toString(): event.mDeviceInfo.deviceId
        },
        options: Options(headers: await Header().getHeader()));
    if (respon.statusCode == 200) {
      return loginResponFromJson(respon.data);
    } else {
      return LoginRespon(success: false);
    }
  }

  Future<LoginRespon> getUserDataTerkini() async {
    LoginRespon? login = await sharedPreferences().getUserData();
    String? token = await FirebaseMessaging.instance.getToken();
    var respon = await dio.get("auth/cek-user",
        queryParameters: {
          "id_karyawan": login != null ? login.dataLogin!.idKaryawan : '',
          "id_company": login != null ? login.dataLogin!.idCompany : '',
          "token_fcm": token,
        },
        options: Options(headers: await Header().getHeader()));
    if (respon.statusCode == 200) {
      return loginResponFromJson(respon.data);
    } else {
      return LoginRespon(success: false);
    }
  }

  Future<BasicRespon> logout() async {
    LoginRespon? data = await sharedPreferences().getUserData();
    var respon = await dio.get("auth/logout",
        queryParameters: {
          "id_karyawan": data != null ? data.dataLogin!.idKaryawan : '',
        },
        options: Options(headers: await Header().getHeader()));
    if (respon.statusCode == 200) {
      return basicResponFromJson(respon.data);
    } else {
      return BasicRespon(success: false);
    }
  }

  Future<BasicRespon> updateBahasa(bahasa) async {
    var respon = await dio.patch("users/update-bahasa",
        queryParameters: {
          "lang": bahasa,
        },
        options: Options(headers: await Header().getHeader()));
    if (respon.statusCode == 200) {
      return basicResponFromJson(respon.data);
    } else {
      return BasicRespon(success: false);
    }
  }

  Future<BasicRespon> changePassword(passwordLama, passwordBaru) async {
    var respon = await dio.patch("users/ubah-password",
        queryParameters: {
          "password_lama": passwordLama,
          "password_baru": passwordBaru
        },
        options: Options(headers: await Header().getHeader()));
    if (respon.statusCode == 200) {
      return basicResponFromJson(respon.data);
    } else {
      return BasicRespon(success: false);
    }
  }

  Future<BasicRespon> uploadFotoProfil(String imageBase64) async {
    LoginRespon data = await sharedPreferences().getUserData();
    var respon = await dio.post("users/upload-foto",
        data: {
          "foto": imageBase64,
          "token_fcm": await FirebaseMessaging.instance.getToken(),
          "id_company": data.dataLogin!.idCompany
        },
        options: Options(headers: await Header().getHeader()));

    if (respon.statusCode == 200) {
      return basicResponFromJson(respon.data);
    } else {
      return BasicRespon(success: false);
    }
  }

  Future<BasicRespon> ubahProfil(noTelp) async {
    String? token = await FirebaseMessaging.instance.getToken();
    var respon = await dio.patch("users/ubah-telp",
        queryParameters: {"token_fcm": token, "no_telp": noTelp},
        options: Options(headers: await Header().getHeader()));
    if (respon.statusCode == 200) {
      return basicResponFromJson(respon.data);
    } else {
      return BasicRespon(success: false);
    }
  }

  Future<BasicRespon> cekPassword(String password) async {
    var respon = await dio.get("users/cek-password",
        queryParameters: {
          "token_fcm": await FirebaseMessaging.instance.getToken(),
          "password": password
        },
        options: Options(headers: await Header().getHeader()));
    if (respon.statusCode == 200) {
      return basicResponFromJson(respon.data);
    } else {
      return BasicRespon(success: false);
    }
  }

  Future<BasicRespon> resetPassword(email) async {
    var respon = await dio.patch("users/reset-password",
        data: {"email": "$email"},
        options: Options(headers: await Header().getHeader()));
    if (respon.statusCode == 200) {
      return basicResponFromJson(respon.data);
    } else {
      return BasicRespon(success: false);
    }
  }

  Future<BasicRespon?> loginPayroll(username, password) async {
    var respon = await dio.post("users/login-payroll",
        data: {"username": username, "password": password},
        options: Options(headers: await Header().getHeader()));
    if (respon.statusCode == 200) {
      return basicResponFromJson(respon.data);
    } else {
      return null;
    }
  }

  Future<MasterDetailUser?> detailUser() async {
    var respon = await dio.get("user/detail",
        queryParameters: {
          "id_company": "$idCompany",
          "id_karyawan": "$idKaryawan"
        },
        options: Options(headers: await Header().getHeader()));
    if (respon.statusCode == 200) {
      return masterDetailUserFromJson(respon.data);
    } else {
      return null;
    }
  }

  Future<BasicRespon> faceRegistration(List? data, String base64) async {
    var respon = await dio.post("users/face-registration",
        data: {
          "token_fcm": await FirebaseMessaging.instance.getToken(),
          "face_data": data.toString(),
          "image": base64
        },
        options: Options(headers: await Header().getHeader()));
    if (respon.statusCode == 200) {
      return basicResponFromJson(respon.data);
    } else {
      return BasicRespon(success: false);
    }
  }

  Future<FaceRespon?> getFaceData() async {
    var respon = await dio.get("users/face-data",
        queryParameters: {
          "token_fcm": await FirebaseMessaging.instance.getToken(),
        },
        options: Options(headers: await Header().getHeader()));
    if (respon.statusCode == 200) {
      return faceResponFromJson(respon.data);
    } else {
      return null;
    }
  }

  Future<LoginRespon> loginSSo(String token) async {
    // var dio = Dio();
    dio.options.headers = {
      'Authorization': 'Bearer $token',
    };
    // dio.interceptors.add(PrettyDioLogger());
    try {
      var respon = await dio.get("auth/sso-azzure", queryParameters: {
        "token_fcm": await FirebaseMessaging.instance.getToken(),
      });
      // print(respon.data);
      if (respon.statusCode == 200) {
        return loginResponFromJson(respon.data);
        // return loginResponFromJson(jsonEncode(respon.data));
      } else {
        return LoginRespon(success: false);
      }
    } catch (e) {
      print('Http Error: ${e.toString()}');
      return LoginRespon(success: false);
    }
  }
}
