import 'package:absenkuv3/Repository/Model/mFilter.dart';
import 'package:absenkuv3/Repository/Model/mLogin.dart';
import 'package:absenkuv3/Repository/Model/mPengajuanSaya.dart';
import 'package:absenkuv3/Repository/Model/mPengaturan.dart';
import 'package:absenkuv3/Repository/Model/mShift2.dart';
import 'package:absenkuv3/Repository/Model/mShiftTeman.dart';
import 'package:absenkuv3/Repository/Model/mSplashScreen.dart';
import 'package:absenkuv3/Repository/Model/mTukarShift.dart';
import 'package:absenkuv3/Repository/Service/serviceInfo.dart';
import 'package:absenkuv3/Repository/sharedPreference.dart';
import 'package:dio/dio.dart';
import 'package:flutter/material.dart';
import '../../Setting/Header.dart';
import 'package:intl/intl.dart';

class TukarShiftApi {
  final dateFormat = new DateFormat('yyyy-MM-dd');
  final monthYearFormat = new DateFormat('yyyy-MM');
  Dio dio = ServerInfo().getConnection();

  Future<Pengaturan> pengaturan() async {
    // print('pengaturan');
    var respon = await dio.get("tukar-shift-new/pengaturan-shift",
        options: Options(headers: await Header().getHeader()));
    // print(respon.data);
    // print('waaaaw');
    if (respon.statusCode == 200) {
      return pengaturanFromJson(respon.data);
    } else {
      return Pengaturan(success: false);
    }
  }
    Future<ShiftRespon> getDataShift(offset, ModelFilter? modelFilter) async {
    print('TRIGGERED');
    // debugPrint(offset);
    // debugPrint(modelFilter.toString());
    LoginRespon data = await sharedPreferences().getUserData();
    var respon = await dio.get("tukar-shift-new/data-shift",
        queryParameters: {
          "id_karyawan": modelFilter != null && modelFilter.idPegawai != null
              ? modelFilter.idPegawai
              : data.dataLogin!.idKaryawan,
          "limit": ServerInfo.limit,
          "offset": offset,
          "id_company": data.dataLogin!.idCompany,
          "id_departemen": data.dataLogin!.idDepartemen,
          "id_cabang": data.dataLogin!.idCabang,
          "level": data.dataLogin!.level,
          "konteks": 'shiftSaya',
          "month_year": modelFilter != null && modelFilter.monthYear != null
              ? monthYearFormat.format(modelFilter.monthYear!).toString()
              : null,
          "range_tanggal_mulai":
              modelFilter != null && modelFilter.dateRange != null
                  ? dateFormat.format(modelFilter.dateRange![0]).toString()
                  : null,
          "range_tanggal_selesai":
              modelFilter != null && modelFilter.dateRange != null
                  ? dateFormat.format(modelFilter.dateRange![1]).toString()
                  : null,
        },
        options: Options(headers: await Header().getHeader()));
        print(respon.data);
    if (respon.statusCode == 200) {
      return shiftResponFromJson(respon.data);
    } else {
      return ShiftRespon(success: false);
    }
  }


  Future<PengajuanSaya> getDataPengajuanSaya(limit,offset) async {
    print('TRIGGERED');
    var respon = await dio.get("tukar-shift-new/tukar-shift-new/pengajuan-saya",
    queryParameters: {
      'limit':limit,
      'offset':offset,
    },
        options: Options(headers: await Header().getHeader()));
    print(respon.data);
    if (respon.statusCode == 200) {
      return pengajuanSayaFromJson(respon.data);
    } else {
      return PengajuanSaya(success: false);
    }
  }

    Future<PengajuanSaya> getPengajuanSayaDetail(String? idPengajuan, String konteks) async {
    print('TRIGGERED');
    // print("idPengajuan: $idPengajuan");
    var respon = await dio.get("tukar-shift-new/tukar-shift-new/pengajuan-saya-detail",
    queryParameters: {
      "id_pengajuan": idPengajuan,
      // "konteks": konteks
    },
        options: Options(headers: await Header().getHeader()));
    print(respon.data);
    if (respon.statusCode == 200) {
      return pengajuanSayaFromJson(respon.data);
    } else {
      return PengajuanSaya(success: false);
    }
  }


  Future<PengajuanSaya> getDataPermintan( limit, offset) async {
    print('permintaan');
    var respon = await dio.get("tukar-shift-new/tukar-shift-new/permintaan",
    queryParameters: {
      'limit':limit,
      'offset':offset
    },
        options: Options(headers: await Header().getHeader()));
    print(respon.data);
    if (respon.statusCode == 200) {
      return pengajuanSayaFromJson(respon.data);
    } else {
      return PengajuanSaya(success: false);
    }
  }

  Future<BasicRespon> setujui(String idPengajuan) async {
    print('setujui');
    var respon = await dio.patch("tukar-shift-new/setujui/${idPengajuan}",
        options: Options(headers: await Header().getHeader()));
    print(respon.data);
    if (respon.statusCode == 200) {
      return basicResponFromJson(respon.data);
    } else {
      return BasicRespon(success: false);
    }
  }

  Future<BasicRespon> tolak(String idPengajuan) async {
    print('tolak');
    var respon = await dio.patch("tukar-shift-new/tolak/${idPengajuan}",
        options: Options(headers: await Header().getHeader()));
    print(respon.data);
    if (respon.statusCode == 200) {
      return basicResponFromJson(respon.data);
    } else {
      return BasicRespon(success: false);
    }
  }

  Future<PengajuanSaya> getDataHistory() async {
    print('history');
    var respon = await dio.get("tukar-shift-new/tukar-shift-new/history",
        options: Options(headers: await Header().getHeader()));
    print(respon.data);
    if (respon.statusCode == 200) {
      return pengajuanSayaFromJson(respon.data);
    } else {
      return PengajuanSaya(success: false);
    }
  }

  Future<ShiftTeman> getTeman(String tanggal, String keyword,offset,limit) async {
    debugPrint('keyword' + keyword);
    print("HEADER ${await Header().getHeader()}");
    var respon = await dio.get("tukar-shift-new/get-teman",
        queryParameters: {'tgl_shift': tanggal, 'keywords': keyword,  'offset': offset,
      'limit': limit,},
        options: Options(headers: await Header().getHeader()));
    print(respon.data);
    if (respon.statusCode == 200) {
      return shiftTemanFromJson(respon.data);
    } else {
      return ShiftTeman(success: false);
    }
  }

  Future<ShiftTeman> getSendiri(String tanggal) async {
    print("HEADER ${await Header().getHeader()}");
    var respon = await dio.get("tukar-shift-new/get-sendiri",
        queryParameters: {'tgl_shift': tanggal},
        options: Options(headers: await Header().getHeader()));
    print(respon.data);
    if (respon.statusCode == 200) {
      return shiftTemanFromJson(respon.data);
    } else {
      return ShiftTeman(success: false);
    }
  }

  Future<ShiftTeman> getShift(String tanggal) async {
    print("HEADER ${await Header().getHeader()}");
    var respon = await dio.get("tukar-shift-new/get-raw",
        queryParameters: {'tgl_shift': tanggal},
        options: Options(headers: await Header().getHeader()));
    print(respon.data);
    if (respon.statusCode == 200) {
      return shiftTemanFromJson(respon.data);
    } else {
      return ShiftTeman(success: false);
    }
  }

  Future<BasicRespon> pengajuan(ModelTukarShift model) async {
    print("HEADER ${await Header().getHeader()}");
    print(model.jenis);
    Map<String, dynamic>? parameters;
    parameters = {
      'tgl_shift': model.tglShift,
      'kode_shift_awal': model.kodeShiftAwal,
      'nama_shift_awal': model.namaShiftAwal,
      'masuk_awal': model.masukAwal,
      'pulang_awal': model.pulangAwal,
      'id_karyawan_tukar': model.nipApv,
      'kode_shift_baru': model.kodeShiftBaru,
      'nama_shift_baru': model.namaShiftBaru,
      'masuk_baru': model.masukBaru,
      'pulang_baru': model.pulangBaru,
      'keterangan': model.keterangan,
    };
    print(parameters);
    var respon = await dio.post('tukar-shift-new/pengajuan',
        data: parameters,
        options: Options(headers: await Header().getHeader()));
    print(respon.data);
    if (respon.statusCode == 200) {
      return basicResponFromJson(respon.data);
    } else {
      return BasicRespon(success: false);
    }
  }
}
