import 'package:absenkuv3/Repository/Model/mFilter.dart';
import 'package:absenkuv3/Repository/Model/mReimbursement.dart';
import 'package:absenkuv3/Repository/Model/mSplashScreen.dart';
import 'package:dio/dio.dart';
import 'package:flutter/foundation.dart';
import 'package:intl/intl.dart';
import '../../Setting/Header.dart';
import 'serviceInfo.dart';

class ReimbursementApi {
  final monthYearFormat = new DateFormat('yyyy-MM');
  final dateFormat = new DateFormat('yyyy-MM-dd');
  Dio dio = ServerInfo().getConnection();

  Future<ReimbursementRespon> getDataReimbursementSaya(
      ModelFilter? modelFilter, offset) async {
    var respon = await dio.get("reimbursement/data",
        queryParameters: {
          "konteks": 'reimbursementSaya',
          "month_year": modelFilter != null && modelFilter.monthYear != null
              ? monthYearFormat.format(modelFilter.monthYear!).toString()
              : null,
          "range_tanggal_mulai":
              modelFilter != null && modelFilter.dateRange != null
                  ? dateFormat.format(modelFilter.dateRange![0]).toString()
                  : null,
          "range_tanggal_selesai":
              modelFilter != null && modelFilter.dateRange != null
                  ? dateFormat.format(modelFilter.dateRange![1]).toString()
                  : null,
          "limit": ServerInfo.limit,
          "offset": offset
        },
        options: Options(headers: await Header().getHeader()));
    if (respon.statusCode == 200) {
      return reimbursementResponFromJson(respon.data);
    } else {
      return ReimbursementRespon(success: false);
    }
  }

  Future<ReimbursementRespon> getDataRekapReimbursementSaya(
      ModelFilter? modelFilter, offset) async {
    var respon = await dio.get("reimbursement/data",
        queryParameters: {
          "konteks": 'rekapSaya',
          "month_year": modelFilter != null && modelFilter.monthYear != null
              ? monthYearFormat.format(modelFilter.monthYear!).toString()
              : null,
          "range_tanggal_mulai":
              modelFilter != null && modelFilter.dateRange != null
                  ? dateFormat.format(modelFilter.dateRange![0]).toString()
                  : null,
          "range_tanggal_selesai":
              modelFilter != null && modelFilter.dateRange != null
                  ? dateFormat.format(modelFilter.dateRange![1]).toString()
                  : null,
          "limit": ServerInfo.limit,
          "offset": offset
        },
        options: Options(headers: await Header().getHeader()));
    if (respon.statusCode == 200) {
      return reimbursementResponFromJson(respon.data);
    } else {
      return ReimbursementRespon(success: false);
    }
  }

  Future<ReimbursementRespon> getDataReimbursementKaryawan(
      ModelFilter? modelFilter, offset) async {
    // print('status ${modelFilter != null ? modelFilter.status ?? null : null}');
    var respon = await dio.get("reimbursement/data",
        queryParameters: {
          "konteks": 'reimbursementKaryawan',
          "filter_departemen":
              modelFilter != null ? modelFilter.idDepartemen ?? null : null,
          "filter_cabang":
              modelFilter != null ? modelFilter.idCabang ?? null : null,
          "filter_id_karyawan":
              modelFilter != null ? modelFilter.idPegawai ?? null : null,
          "month_year": modelFilter != null && modelFilter.monthYear != null
              ? monthYearFormat.format(modelFilter.monthYear!).toString()
              : null,
          "range_tanggal_mulai":
              modelFilter != null && modelFilter.dateRange != null
                  ? dateFormat.format(modelFilter.dateRange![0]).toString()
                  : null,
          "range_tanggal_selesai":
              modelFilter != null && modelFilter.dateRange != null
                  ? dateFormat.format(modelFilter.dateRange![1]).toString()
                  : null,
          "status": modelFilter != null ? modelFilter.status ?? null : null,
          "limit": ServerInfo.limit,
          "offset": offset
        },
        options: Options(headers: await Header().getHeader()));
    if (respon.statusCode == 200) {
      return reimbursementResponFromJson(respon.data);
    } else {
      return ReimbursementRespon(success: false);
    }
  }

  Future<ReimbursementRespon> getDataRekapReimbursementKaryawan(
      ModelFilter? modelFilter, offset) async {
    var respon = await dio.get("reimbursement/data",
        queryParameters: {
          "konteks": 'rekapKaryawan',
          "filter_departemen":
              modelFilter != null ? modelFilter.idDepartemen ?? null : null,
          "filter_cabang":
              modelFilter != null ? modelFilter.idCabang ?? null : null,
          "filter_id_karyawan":
              modelFilter != null ? modelFilter.idPegawai ?? null : null,
          "month_year": modelFilter != null && modelFilter.monthYear != null
              ? monthYearFormat.format(modelFilter.monthYear!).toString()
              : null,
          "range_tanggal_mulai":
              modelFilter != null && modelFilter.dateRange != null
                  ? dateFormat.format(modelFilter.dateRange![0]).toString()
                  : null,
          "range_tanggal_selesai":
              modelFilter != null && modelFilter.dateRange != null
                  ? dateFormat.format(modelFilter.dateRange![1]).toString()
                  : null,
          "limit": ServerInfo.limit,
          "offset": offset
        },
        options: Options(headers: await Header().getHeader()));
    if (respon.statusCode == 200) {
      return reimbursementResponFromJson(respon.data);
    } else {
      return ReimbursementRespon(success: false);
    }
  }

  Future<ReimbursementRespon> getDataReimbursementDetail(
      String? idPengajuan) async {
    // print(idPengajuan);
    var respon = await dio.get("reimbursement/data",
        queryParameters: {
          "konteks": 'reimbursementDetail',
          "id_pengajuan": idPengajuan,
          "limit": ServerInfo.limit,
          "offset": 0
        },
        options: Options(headers: await Header().getHeader()));
    if (respon.statusCode == 200) {
      return reimbursementResponFromJson(respon.data);
    } else {
      return ReimbursementRespon(success: false);
    }
  }

  Future<ReimbursementRespon> getDataReimbursementAdminPengajuan(
      ModelFilter? modelFilter, offset) async {
    var respon = await dio.get("reimbursement/data-admin-pengajuan",
        queryParameters: {
          "konteks": 'rekapKaryawan',
          "filter_departemen":
              modelFilter != null ? modelFilter.idDepartemen ?? null : null,
          "filter_cabang":
              modelFilter != null ? modelFilter.idCabang ?? null : null,
          "filter_id_karyawan":
              modelFilter != null ? modelFilter.idPegawai ?? null : null,
          "month_year": modelFilter != null && modelFilter.monthYear != null
              ? monthYearFormat.format(modelFilter.monthYear!).toString()
              : null,
          "range_tanggal_mulai":
              modelFilter != null && modelFilter.dateRange != null
                  ? dateFormat.format(modelFilter.dateRange![0]).toString()
                  : null,
          "range_tanggal_selesai":
              modelFilter != null && modelFilter.dateRange != null
                  ? dateFormat.format(modelFilter.dateRange![1]).toString()
                  : null,
          "limit": ServerInfo.limit,
          "offset": offset
        },
        options: Options(headers: await Header().getHeader()));
    if (respon.statusCode == 200) {
      return reimbursementResponFromJson(respon.data);
    } else {
      return ReimbursementRespon(success: false);
    }
  }

  Future<ReimbursementRespon> getDataReimbursementAdminPengajuanDetail(
      String? idPengajuan) async {
    // print(idPengajuan);
    var respon = await dio.get("reimbursement/data-admin-pengajuan",
        queryParameters: {
          "konteks": 'rekapAdminDetail',
          "id_pengajuan": idPengajuan,
          "limit": ServerInfo.limit,
          "offset": 0
        },
        options: Options(headers: await Header().getHeader()));
    if (respon.statusCode == 200) {
      return reimbursementResponFromJson(respon.data);
    } else {
      return ReimbursementRespon(success: false);
    }
  }

  Future<ReimbursementItemTempRespon> getDataReimbursementItemTemp(
      offset) async {
    if (kDebugMode) {
      // print(await Header().getHeader());
    }
    var respon = await dio.get("reimbursement/data-item",
        options: Options(headers: await Header().getHeader()));
    if (respon.statusCode == 200) {
      return reimbursementItemTempResponFromJson(respon.data);
    } else {
      return ReimbursementItemTempRespon(success: false);
    }
  }

  Future<BasicRespon> tambahItemTemp(ListItemTemp listItemTemp) async {
    // print(listItemTemp.keterangan);
    Map<String, dynamic> parameters;
    parameters = {
      "id_jenis_reimbursement": listItemTemp.idJenisPlafon,
      "nominal": listItemTemp.nominal,
      "tgl_nota": listItemTemp.tglBukti,
      "keterangan": listItemTemp.keterangan,
      "image": listItemTemp.file,
    };

    var respon = await dio.post("reimbursement/tambah-item",
        data: parameters,
        options: Options(headers: await Header().getHeader()));
    if (respon.statusCode == 200) {
      return basicResponFromJson(respon.data);
    } else {
      return BasicRespon(success: false);
    }
  }

  Future<BasicRespon> cekAkunReimbursment() async {
    var respon = await dio.get("reimbursement/cek-anggota-adm",
        options: Options(headers: await Header().getHeader()));
    if (respon.statusCode == 200) {
      return basicResponFromJson(respon.data);
    } else {
      return BasicRespon(success: false);
    }
  }

  Future<BasicRespon> editItemTemp(ListItemTemp listItemTemp) async {
    Map<String, dynamic> parameters;
    parameters = {
      "id": listItemTemp.id,
      "id_jenis_reimbursement": listItemTemp.idJenisPlafon,
      "nominal": listItemTemp.nominal,
      "tgl_nota": listItemTemp.tglBukti,
      "keterangan": listItemTemp.keterangan,
      "image": listItemTemp.file,
    };

    var respon = await dio.post("reimbursement/edit-item",
        data: parameters,
        options: Options(headers: await Header().getHeader()));
    if (respon.statusCode == 200) {
      return basicResponFromJson(respon.data);
    } else {
      return BasicRespon(success: false);
    }
  }

  Future<BasicRespon> pengajuanReimbursement(String keterangan) async {
    Map<String, dynamic> parameters;
    parameters = {
      "keterangan": keterangan,
    };

    var respon = await dio.post("reimbursement/pengajuan",
        data: parameters,
        options: Options(headers: await Header().getHeader()));
    if (respon.statusCode == 200) {
      return basicResponFromJson(respon.data);
    } else {
      return BasicRespon(success: false);
    }
  }

  Future<BasicRespon> hapusItemTemp(String? idItemTemp) async {
    var respon = await dio.patch("reimbursement/hapus-item/$idItemTemp",
        options: Options(headers: await Header().getHeader()));
    if (respon.statusCode == 200) {
      return basicResponFromJson(respon.data);
    } else {
      return BasicRespon(success: false);
    }
  }

  Future<BasicRespon> submitApprovalReimbursement(
      List<ApprovalReimbursementModel> listApprovalReimbursementModel,
      idPengajuan) async {
    Map<String, dynamic> parameters;
    parameters = {
      "jumlah_item": listApprovalReimbursementModel.length,
      "id_pengajuan": idPengajuan
    };
    for (int i = 0; i < listApprovalReimbursementModel.length; i++) {
      parameters.addAll({"id_item$i": listApprovalReimbursementModel[i].id});
      parameters.addAll({"status$i": listApprovalReimbursementModel[i].status});
      parameters
          .addAll({"nominal$i": listApprovalReimbursementModel[i].nominal});
      parameters.addAll(
          {"keterangan$i": listApprovalReimbursementModel[i].keterangan});
    }

    // print("parameter : $parameters");
    var respon = await dio.post("reimbursement/update-status",
        data: parameters,
        options: Options(headers: await Header().getHeader()));
    // print("respon ${respon}");
    if (respon.statusCode == 200) {
      return basicResponFromJson(respon.data);
    } else {
      return BasicRespon(success: false);
    }
  }

  Future<BasicRespon> submitRevisiReimbursement(
      List<DataItem> listRevisiReimbursementModel, idPengajuan) async {
    Map<String, dynamic> parameters;
    parameters = {
      "jumlah_item": listRevisiReimbursementModel.length,
      "id_pengajuan": idPengajuan
    };
    for (int i = 0; i < listRevisiReimbursementModel.length; i++) {
      parameters.addAll({"id_item$i": listRevisiReimbursementModel[i].idItem});
      parameters.addAll({"jenis$i": listRevisiReimbursementModel[i].idJenis});
      parameters.addAll({"nominal$i": listRevisiReimbursementModel[i].nominal});
      parameters
          .addAll({"tgl_nota$i": listRevisiReimbursementModel[i].tglNota});
      parameters
          .addAll({"keterangan$i": listRevisiReimbursementModel[i].keterangan});
      parameters.addAll({"file$i": listRevisiReimbursementModel[i].file});
    }

    // print("parameter : $parameters");
    var respon = await dio.post("reimbursement/revisi",
        data: parameters,
        options: Options(headers: await Header().getHeader()));
    // print("respon ${respon}");
    if (respon.statusCode == 200) {
      return basicResponFromJson(respon.data);
    } else {
      return BasicRespon(success: false);
    }
  }
}
