import 'package:absenkuv3/Repository/Model/mBadge.dart';
import 'package:absenkuv3/Repository/Model/mBadgepercolumn.dart';
import 'package:absenkuv3/Repository/Model/mDataNotif.dart';
import 'package:absenkuv3/Repository/Model/mSplashScreen.dart';
import 'package:absenkuv3/Setting/Header.dart';
import 'package:dio/dio.dart';
import 'package:flutter/material.dart';
import 'serviceInfo.dart';

class NotifApi {
  Dio dio = ServerInfo().getConnection();
  Future<Datanotif> notifData(String konteks, $offset) async {
    var respon = await dio.get("notif/data",
        queryParameters: {
          "jenis": konteks,
          "limit": ServerInfo.limit,
          "offset": $offset,
        },
        options: Options(headers: await Header().getHeader()));
    // debugPrint('respon notif ' + respon.data);
    if (respon.statusCode == 200) {
      return datanotifFromJson(respon.data);
    } else {
      return Datanotif(success: false);
    }
  }

  Future<BasicRespon> baca(String? idNotif, String? jenis) async {
    // print("kkk : $idNotif");
    // print("ppp : $jenis");
    var respon = await dio.patch("notif/baca",
        queryParameters: {
          "jenis": jenis,
          "id_notif": idNotif,
        },
        options: Options(headers: await Header().getHeader()));
    // debugPrint('Iqro' + respon.data);
    if (respon.statusCode == 200) {
      return basicResponFromJson(respon.data);
    } else {
      return BasicRespon(success: false);
    }
  }
  Future<BasicRespon> bacaKpi(String? id_karyawan, String? id_company,
      int? bulan, int? tahun, String? status) async {
    var respon = await dio.patch("notif/bacaKpi",
        queryParameters: {
          "id_karyawan": id_karyawan,
          "id_company": id_company,
          "bulan": bulan,
          "tahun": tahun,
          "status": status
        },
        options: Options(headers: await Header().getHeader()));
    debugPrint('Iqro' + respon.data);
    if (respon.statusCode == 200) {
      return basicResponFromJson(respon.data);
    } else {
      return BasicRespon(success: false);
    }
  }

  Future<JumlahBadge> badgeNotif() async {
    // debugPrint('masuk badgeeeee');
    var respon = await dio.get("notif/badge",
        options: Options(headers: await Header().getHeader()));
    // debugPrint('badge' + respon.data);
    if (respon.statusCode == 200) {
      return jumlahBadgeFromJson(respon.data);
    } else {
      return JumlahBadge(success: false);
    }
  }

  Future<Badgepercolumn> badgeNotifperColumn() async {
    // debugPrint('masuk badge per column');
    var respon = await dio.get("notif/badge-per-column",
        options: Options(headers: await Header().getHeader()));
    // debugPrint('badge' + respon.data);
    if (respon.statusCode == 200) {
      return badgepercolumnFromJson(respon.data);
    } else {
      return Badgepercolumn(success: false);
    }
  }
}
