import 'package:absenkuv3/Repository/Model/mFilter.dart';
import 'package:absenkuv3/Repository/Model/mIzin.dart';
import 'package:absenkuv3/Repository/Model/mLogin.dart';
import 'package:absenkuv3/Repository/Model/mSplashScreen.dart';
import 'package:absenkuv3/Repository/sharedPreference.dart';
import 'package:dio/dio.dart';
import 'package:flutter/material.dart';
import 'package:intl/intl.dart';
import '../../Setting/Header.dart';
import 'serviceInfo.dart';

class IzinApi {
  final dateFormat = new DateFormat('yyyy-MM-dd');
  final monthYearFormat = new DateFormat('yyyy-MM');
  Dio dio = ServerInfo().getConnection();

  Future<JenisIzinRespon> getJenisIzin() async {
    var respon = await dio.get("izin/jenis",
        options: Options(headers: await Header().getHeader()));
    if (respon.statusCode == 200) {
      return jenisIzinResponFromJson(respon.data);
    } else {
      return JenisIzinRespon(success: false);
    }
  }

  Future<IzinRespon> getDataIzin(
      offset, konteks, ModelFilter? modelFilter) async {
    var respon = await dio.get("izin/data",
        queryParameters: {
          "id_karyawan_select":
              modelFilter != null ? modelFilter.idPegawai ?? null : null,
          "id_cabang":
              modelFilter != null ? modelFilter.idCabang ?? null : null,
          "id_departemen":
              modelFilter != null ? modelFilter.idDepartemen ?? null : null,
          "limit": ServerInfo.limit,
          "offset": offset,
          "konteks": konteks,
          "month_year": modelFilter != null && modelFilter.monthYear != null
              ? monthYearFormat.format(modelFilter.monthYear!).toString()
              : null,
          "range_tanggal_mulai":
              modelFilter != null && modelFilter.dateRange != null
                  ? dateFormat.format(modelFilter.dateRange![0]).toString()
                  : null,
          "range_tanggal_selesai":
              modelFilter != null && modelFilter.dateRange != null
                  ? dateFormat.format(modelFilter.dateRange![1]).toString()
                  : null,
          "status": modelFilter != null && modelFilter.status != null
              ? modelFilter.status
              : null
        },
        options: Options(headers: await Header().getHeader()));
    if (respon.statusCode == 200) {
      return izinResponFromJson(respon.data);
    } else {
      return IzinRespon(success: false);
    }
  }

  Future<IzinRespon> getDataIzinDetail(idIzin, konteks) async {
    var respon = await dio.get("izin/data",
        queryParameters: {
          "limit": ServerInfo.limit,
          "offset": 0,
          "konteks": konteks,
          "id_izin": idIzin,
        },
        options: Options(headers: await Header().getHeader()));
    print(respon.data);
    if (respon.statusCode == 200) {
      return izinResponFromJson(respon.data);
    } else {
      return IzinRespon(success: false);
    }
  }

  Future<BasicSimpleRespon> getSisaCuti({String? idKaryawan}) async {
    LoginRespon data = await sharedPreferences().getUserData();
    var respon = await dio.get("izin/sisa_cuti",
        queryParameters: {
          "id_karyawan": idKaryawan ?? data.dataLogin!.idKaryawan,
        },
        options: Options(headers: await Header().getHeader()));
    if (respon.statusCode == 200) {
      return basicSimpleResponFromJson(respon.data);
    } else {
      return BasicSimpleRespon(success: false);
    }
  }

  Future<BasicSimpleRespon> getJumlahIzin(
      String? tanggalMulai, String? tanggalSelesai, String? flagKalender) async {
        debugPrint(flagKalender);
        debugPrint('flag kalender');
    var respon = await dio.get("izin/jumlah_izin",
        queryParameters: {
          "tanggal_mulai": tanggalMulai,
          "tanggal_selesai": tanggalSelesai,
          "flag_kalender": flagKalender,
        },
        options: Options(headers: await Header().getHeader()));
    if (respon.statusCode == 200) {
      return basicSimpleResponFromJson(respon.data);
    } else {
      return BasicSimpleRespon(success: false);
    }
  }

  Future<BasicRespon> pengajuanIzin(ModelIzin modelIzin) async {
    // print(modelIzin.idJenisIzin);
    Map<String, dynamic> parameters;
    // print('kode_izin : ${modelIzin.idJenisIzin}');
    // print('jenis_izin : ${modelIzin.jenisIzin}');
    // print('tgl_mulai_izin : ${modelIzin.tanggalMulai}');
    // print('tgl_selesai_izin : ${modelIzin.tanggalSelesai}');
    // print('nama_izin : ${modelIzin.namaJenisIzin}');
    // print('ket_izin : ${modelIzin.keterangan}');
    // print('jumlah_izin : ${modelIzin.jumlahIzin}');
    // print('sisa_cuti : ${modelIzin.sisaCuti}');
    // print('flag : ${modelIzin.flag}');
    parameters = {
      "kode_izin": modelIzin.idJenisIzin,
      "jenis_izin": modelIzin.jenisIzin,
      "tgl_mulai_izin": modelIzin.tanggalMulai,
      "tgl_selesai_izin": modelIzin.tanggalSelesai,
      "nama_izin": modelIzin.namaJenisIzin,
      "ket_izin": modelIzin.keterangan,
      "jumlah_izin": modelIzin.jumlahIzin,
      "flag": modelIzin.flag,
      "sisa_cuti": modelIzin.sisaCuti
    };

    if (modelIzin.listImage != null) {
      int imageCount = 0;
      for (int i = 0; i < modelIzin.listImage!.length; i++) {
        imageCount++;
        parameters.putIfAbsent(
            'image${i + 1}', () => modelIzin.listImage![i].base64);
      }
      parameters.putIfAbsent('image_count', () => imageCount);
    }

    var respon = await dio.post("izin/pengajuan",
        data: parameters,
        options: Options(headers: await Header().getHeader()));
    // print(respon);
    if (respon.statusCode == 200) {
      return basicResponFromJson(respon.data);
    } else {
      return BasicRespon(success: false);
    }
  }

  Future<BasicRespon> batalkanIzin(String? idIzin) async {
    var respon = await dio.patch("izin/batalkan/$idIzin",
        options: Options(headers: await Header().getHeader()));
    if (respon.statusCode == 200) {
      return basicResponFromJson(respon.data);
    } else {
      return BasicRespon(success: false);
    }
  }

  Future<BasicRespon> setujuiIzin(String? idIzin) async {
    // print('setujui biasa');
    var respon = await dio.patch("izin/setujui/$idIzin",
        options: Options(headers: await Header().getHeader()));
    if (respon.statusCode == 200) {
      return basicResponFromJson(respon.data);
    } else {
      return BasicRespon(success: false);
    }
  }

  Future<BasicRespon> MewakiliSetujuiIzin(String? idIzin) async {
    // print('mewakili');
    var respon = await dio.patch("izin/hrd_mewakili_setujui/$idIzin",
        options: Options(headers: await Header().getHeader()));
    if (respon.statusCode == 200) {
      return basicResponFromJson(respon.data);
    } else {
      return BasicRespon(success: false);
    }
  }

  Future<BasicRespon> tolakIzin(String? idIzin) async {
    var respon = await dio.patch("izin/tolak/$idIzin",
        options: Options(headers: await Header().getHeader()));
    if (respon.statusCode == 200) {
      return basicResponFromJson(respon.data);
    } else {
      return BasicRespon(success: false);
    }
  }

  Future<BasicRespon> MewakiliTolakIzin(String? idIzin) async {
    var respon = await dio.patch("izin/hrd_mewakili_tolak/$idIzin",
        options: Options(headers: await Header().getHeader()));
    if (respon.statusCode == 200) {
      return basicResponFromJson(respon.data);
    } else {
      return BasicRespon(success: false);
    }
  }
}
