import 'package:absenkuv3/Repository/Model/mAktivitas.dart';
import 'package:absenkuv3/Repository/Model/mFilter.dart';
import 'package:absenkuv3/Repository/Model/mLembur.dart';
import 'package:absenkuv3/Repository/Model/mSplashScreen.dart';
import 'package:dio/dio.dart';
import 'package:intl/intl.dart';
import '../../Setting/Header.dart';
import 'serviceInfo.dart';

class ActivitasApi {
  final dateFormat = new DateFormat('yyyy-MM-dd');
  final monthYearFormat = new DateFormat('yyyy-MM');
  Dio dio = ServerInfo().getConnection();

  Future<AktivitasRespon> getDataAktivitas(
      offset, ModelFilter? modelFilter) async {
    var respon = await dio.get("aktivitas/data",
        queryParameters: {
          "limit": ServerInfo.limit,
          "offset": offset,
          "konteks": 'aktivitasSaya',
          "range_tanggal_mulai":
              modelFilter != null && modelFilter.dateRange != null
                  ? dateFormat.format(modelFilter.dateRange![0]).toString()
                  : null,
          "range_tanggal_selesai":
              modelFilter != null && modelFilter.dateRange != null
                  ? dateFormat.format(modelFilter.dateRange![1]).toString()
                  : null,
        },
        options: Options(headers: await Header().getHeader()));
    if (respon.statusCode == 200) {
      return aktivitasResponFromJson(respon.data);
    } else {
      return AktivitasRespon(success: false);
    }
  }

  Future<AktivitasRespon> getDataAktivitasPegawai(
      offset, ModelFilter? modelFilter) async {
    var respon = await dio.get("aktivitas/data",
        queryParameters: {
          "id_cabang":
              modelFilter != null ? modelFilter.idCabang ?? null : null,
          "id_departemen":
              modelFilter != null ? modelFilter.idDepartemen ?? null : null,
          "id_karyawan_select":
              modelFilter != null ? modelFilter.idPegawai ?? null : null,
          "limit": ServerInfo.limit,
          "offset": offset,
          "konteks": 'aktivitasPegawai',
          "month_year": modelFilter != null && modelFilter.monthYear != null
              ? monthYearFormat.format(modelFilter.monthYear!).toString()
              : null,
          "range_tanggal_mulai":
              modelFilter != null && modelFilter.dateRange != null
                  ? dateFormat.format(modelFilter.dateRange![0]).toString()
                  : null,
          "range_tanggal_selesai":
              modelFilter != null && modelFilter.dateRange != null
                  ? dateFormat.format(modelFilter.dateRange![1]).toString()
                  : null,
        },
        options: Options(headers: await Header().getHeader()));
    if (respon.statusCode == 200) {
      return aktivitasResponFromJson(respon.data);
    } else {
      return AktivitasRespon(success: false);
    }
  }

  Future<AktivitasRespon> getDataDetailAktivitas(idAktivitas) async {
    var respon = await dio.get("aktivitas/data",
        queryParameters: {
          "limit": ServerInfo.limit,
          "offset": 0,
          "konteks": 'detailAktivitas',
          "id_aktivitas": idAktivitas,
        },
        options: Options(headers: await Header().getHeader()));
    if (respon.statusCode == 200) {
      return aktivitasResponFromJson(respon.data);
    } else {
      return AktivitasRespon(success: false);
    }
  }

  //ABSENSI LEMBUR POST
  Future<BasicRespon> tambahAktivitas(DataAbsensi dataAbsensi) async {
    var respon = await dio.post("aktivitas/tambah",
        data: {
          "lokasi_absen": dataAbsensi.lokasiAbsen,
          "jenis_lembur": dataAbsensi.jenisAbsen,
          "latitude": dataAbsensi.latitude,
          "longitude": dataAbsensi.longitude,
          "keterangan": dataAbsensi.keteranganAbsen,
          "image": dataAbsensi.foto,
        },
        options: Options(headers: await Header().getHeader()));
    if (respon.statusCode == 200) {
      return basicResponFromJson(respon.data);
    } else {
      return BasicRespon(success: false);
    }
  }

  //CEK LOKASI
  Future<CekLokasiRespon?> cekLokasi(DataAbsensi data) async {
    // print('wkwk');
    var respon = await dio.get("aktivitas/lokasi",
        queryParameters: {
          "latitude": data.latitude,
          "longitude": data.longitude,
        },
        options: Options(headers: await Header().getHeader()));
    // print(respon.data);
    if (respon.statusCode == 200) {
      return cekLokasiResponFromJson(respon.data);
    } else {
      return null;
    }
  }
}
