import 'dart:convert';

import 'package:absenkuv3/Repository/Model/Akun/mKontakPegawai.dart';
import 'package:absenkuv3/Repository/Model/mFilter.dart';
import 'package:absenkuv3/Repository/Service/serviceInfo.dart';
import 'package:dio/dio.dart';
import 'package:intl/intl.dart';
import 'package:absenkuv3/Setting/Header.dart';

class DataKontakSemuaPegawaiApi {
  final dateFormat = new DateFormat('yyyy-MM-dd');
  final monthYearFormat = new DateFormat('yyyy-MM');
  Dio dio = ServerInfo().getConnection();
  Future<KontakPegawaiRespon> getListKontakSemuaPegawai(
      offset, String? konteks, String? cari, ModelFilter? modelFilter) async {
    var respon = await dio.get("kontak-pegawai/data",
        queryParameters: {
          "offset": offset,
          "limit": ServerInfo.limit,
          "konteks": konteks,
          "cari": cari,
          "id_cabang": modelFilter != null && modelFilter.idCabang != null
              ? modelFilter.idCabang
              : null,
          "id_departemen":
              modelFilter != null && modelFilter.idDepartemen != null
                  ? modelFilter.idDepartemen
                  : null
        },
        options: Options(headers: await Header().getHeader()));
    if (respon.statusCode == 200) {
      return kontakPegawaiResponFromJson(respon.data);
    } else {
      return KontakPegawaiRespon();
    }
  }
}
