import 'package:absenkuv3/Repository/Model/Akun/KelengkapanFile/mKelengkapanFile.dart';
import 'package:absenkuv3/Repository/Model/Akun/mNotifikasiAkun.dart';
import 'package:absenkuv3/Repository/Model/mSplashScreen.dart';
import 'package:absenkuv3/Repository/Service/serviceInfo.dart';
import 'package:absenkuv3/Setting/Header.dart';
import 'package:absenkuv3/UI/Template/MultiImagePicker/Model/MultiImagePickerModel.dart';
import 'package:dio/dio.dart';
import 'package:intl/intl.dart';

class DataKelengkapanFileApi {
  final dateFormat = new DateFormat('yyyy-MM-dd');
  final monthYearFormat = new DateFormat('yyyy-MM');
  Dio dio = ServerInfo().getConnection();




  Future<DataKelengkapanFileRespon> getDataKelengkapanFileTerferifikasi() async {
    var respon = await dio.get("data_kelengkapan_file/data", options: Options(headers: await Header().getHeader()));
    if (respon.statusCode == 200) {
      return dataKelengkapanFileResponFromJson(respon.data);
    } else {
      return DataKelengkapanFileRespon(success: false);
    }
  }

  Future<DataKelengkapanFileRespon> getDataKelengkapanFilePengajuan() async {
    var respon = await dio.get("data_kelengkapan_file/data-pengajuan", options: Options(headers: await Header().getHeader()));
    print(respon.data);
    if (respon.statusCode == 200) {
      return dataKelengkapanFileResponFromJson(respon.data);
    } else {
      return DataKelengkapanFileRespon(success: false);
    }
  }

  Future<DataKelengkapanFileRespon> getDataPKelengkapanFilePengajuanById(idKelengkapanFile, konteks) async {
    var respon = await dio.get("data_kelengkapan_file/data-pengajuan-by-id",
        queryParameters: {
          "id_kelengkapan_file": idKelengkapanFile,
          "konteks": konteks
        }, options: Options(headers: await Header().getHeader()));
    print(respon.data);
    if (respon.statusCode == 200) {
      return dataKelengkapanFileResponFromJson(respon.data);
    } else {
      return DataKelengkapanFileRespon(success: false);
    }
  }

  Future<BasicRespon> pengajuanTambahDataKelengkapanFile(DataDatakelengkapanfile datakelengkapanfile, List<MultiImagePickerModel>? file) async {
    var respon = await dio.post("data_kelengkapan_file/tambah", data: {
      "nama_dokumen": datakelengkapanfile.namaDokumen,
      "file": file == null
              ? null
              : file.length == 0
                  ? null
                  : file[0].base64,
    }, options: Options(headers: await Header().getHeader()));
    if (respon.statusCode == 200) {
      return basicResponFromJson(respon.data);
    } else {
      return BasicRespon(success: false);
    }
  }

  Future<BasicRespon> editPengajuanDataKelengkapanFile(DataDatakelengkapanfile datakelengkapanfile, List<MultiImagePickerModel>? file) async {
    var respon = await dio.post("data_kelengkapan_file/edit-pengajuan", data: {
      "id_kelengkapan_file": datakelengkapanfile.idKelengkapanFile,
      "nama_dokumen" : datakelengkapanfile.namaDokumen,
      "file_old" : datakelengkapanfile.file,
      "file": file == null
              ? null
              : file.length == 0
                  ? null
                  : file[0].base64,
    }, options: Options(headers: await Header().getHeader()));
    if (respon.statusCode == 200) {
      return basicResponFromJson(respon.data);
    } else {
      return BasicRespon(success: false);
    }
  }

  Future<BasicRespon> editDataKelengkapanFile(DataDatakelengkapanfile datakelengkapanfile, List<MultiImagePickerModel>? file) async {
    var respon = await dio.post("data_kelengkapan_file/edit", data: {
      "id_kelengkapan_file": datakelengkapanfile.idKelengkapanFile,
      "nama_dokumen" : datakelengkapanfile.namaDokumen,
      "file_old" : datakelengkapanfile.file,
      "file": file == null
              ? null
              : file.length == 0
                  ? null
                  : file[0].base64,
    }, options: Options(headers: await Header().getHeader()));
    if (respon.statusCode == 200) {
      return basicResponFromJson(respon.data);
    } else {
      return BasicRespon(success: false);
    }
  }

  Future<BasicRespon> deleteDataKelengkapanFile(String idKelengkapanFile) async {
    var respon = await dio.delete("data_kelengkapan_file/delete", queryParameters: {
      "id_kelengkapan_file": idKelengkapanFile
    }, options: Options(headers: await Header().getHeader()));
    if (respon.statusCode == 200) {
      return basicResponFromJson(respon.data);
    } else {
      return BasicRespon(success: false);
    }
  }

  Future<BasicRespon> deletePengajuanDataKelengkapanFile(String idKelengkapanFile) async {
    var respon = await dio.delete("data_kelengkapan_file/delete-pengajuan", queryParameters: {
      "id_kelengkapan_file": idKelengkapanFile
    }, options: Options(headers: await Header().getHeader()));
    if (respon.statusCode == 200) {
      return basicResponFromJson(respon.data);
    } else {
      return BasicRespon(success: false);
    }
  }

  Future<DataKelengkapanFileRespon> getDetailDataKelengkapanFileById(DataNotifikasiAkun data) async {
    var respon = await dio.get("data_kelengkapan_file/data-detail-by-id",
        queryParameters: { "id": data.id, "konteks": data.jenis }, options: Options(headers: await Header().getHeader()));
    print(respon.data);
    if (respon.statusCode == 200) {
      return dataKelengkapanFileResponFromJson(respon.data);
    } else {
      return DataKelengkapanFileRespon(success: false);
    }
  }


}
