import 'package:absenkuv3/Repository/Model/Akun/View/mDataDataDiri.dart';
import 'package:absenkuv3/Repository/Model/Akun/View/mDataEditDataDiri.dart';
import 'package:absenkuv3/Repository/Model/Akun/mDataDiri.dart';
import 'package:absenkuv3/Repository/Model/Akun/mNotifikasiAkun.dart';
import 'package:absenkuv3/Repository/Model/mLogin.dart';
import 'package:absenkuv3/Repository/Model/mSplashScreen.dart';
import 'package:absenkuv3/Repository/Service/serviceInfo.dart';
import 'package:absenkuv3/Repository/sharedPreference.dart';
import 'package:absenkuv3/Setting/Header.dart';
import 'package:dio/dio.dart';
import 'package:intl/intl.dart';

class DataDiriApi {
  final dateFormat = new DateFormat('yyyy-MM-dd');
  final monthYearFormat = new DateFormat('yyyy-MM');
  Dio dio = ServerInfo().getConnection();




  Future<DataDataDiriRespon> getDataDiri() async {
    var respon = await dio.get("data_diri/data", options: Options(headers: await Header().getHeader()));
    if (respon.statusCode == 200) {
      return dataDataDiriResponFromJson(respon.data);
    } else {
      return DataDataDiriRespon();
    }
  }

  Future<DataEditDataDiriRespon> getDataEditDataDiri() async {
    LoginRespon data = await sharedPreferences().getUserData();
    print("id karyawan : ${data.dataLogin!.idKaryawan}");
    print("id idCompany : ${data.dataLogin!.idCompany}");
    var respon = await dio.get("data_diri/data-edit",queryParameters: {
      "id_karyawan" : data.dataLogin!.idKaryawan,
      "id_company"  : data.dataLogin!.idCompany
    }, options: Options(headers: await Header().getHeader()));
    print(respon.data);
    if (respon.statusCode == 200) {
      return dataEditDataDiriResponFromJson(respon.data);
    } else {
      return DataEditDataDiriRespon();
    }
  }

  Future<DataEditDataDiriRespon> getDataPengajuanEditDataDiri() async {
    var respon = await dio.get("data_diri/data-pengajuan-edit", options: Options(headers: await Header().getHeader()));
    if (respon.statusCode == 200) {
      return dataEditDataDiriResponFromJson(respon.data);
    } else {
      return DataEditDataDiriRespon();
    }
  }

  Future<DataDataDiriRespon> getDataPengajuanDataDiri() async {
    var respon = await dio.get("data_diri/data-pengajuan", options: Options(headers: await Header().getHeader()));
    if (respon.statusCode == 200) {
      return dataDataDiriResponFromJson(respon.data);
    } else {
      return DataDataDiriRespon();
    }
  }

  Future<BasicRespon> pengajuanPerubahanDataDiri(DataDatadiri data) async {
    var respon = await dio.post("data_diri/pengajuan", data: {
      "nik"             : data.nik,
      "nama_lengkap"    : data.namaLengkap,
      "gelar_depan"     : data.gelarDepan,
      "gelar_belakang"  : data.gelarBelakang,
      "jenis_kelamin"   : data.jenisKelamin,
      "golongan_darah"  : data.golonganDarah,
      "agama"           : data.agama,
      "tempat_lahir"    : data.tempatLahir,
      "tgl_lahir"       : data.tglLahir,
      "alamat_domisili" : data.alamatDomisili,
      "rt"              : data.rt,
      "rw"              : data.rw,
      "id_kel"          : data.namaKelurahan,
      "id_kec"          : data.namaKecamatan,
      "id_kab"          : data.namaKabupaten,
      "id_prov"         : data.namaProvinsi,
      "kode_pos"        : data.kodePos,
      "telepon"         : data.telepon,
      "email"           : data.email,
      "pendidikan"      : data.pendidikanTerakhir,
      "no_ktp"          : data.noKtp,
      "no_bpjs_kes"     : data.noBpjsKes,
      "no_asuransi"     : data.noAsuransi
    }, options: Options(headers: await Header().getHeader()));
    if (respon.statusCode == 200) {
      return basicResponFromJson(respon.data);
    } else {
      return BasicRespon(success: false);
    }
  }

  Future<BasicRespon> EditPengajuanPerubahanDataDiri(DataDatadiri data) async {
    var respon = await dio.post("data_diri/edit-pengajuan", data: {
      "nik"             : data.nik,
      "nama_lengkap"    : data.namaLengkap,
      "gelar_depan"     : data.gelarDepan,
      "gelar_belakang"  : data.gelarBelakang,
      "jenis_kelamin"   : data.jenisKelamin,
      "golongan_darah"  : data.golonganDarah,
      "agama"           : data.agama,
      "tempat_lahir"    : data.tempatLahir,
      "tgl_lahir"       : data.tglLahir,
      "alamat_domisili" : data.alamatDomisili,
      "rt"              : data.rt,
      "rw"              : data.rw,
      "id_kel"          : data.namaKelurahan,
      "id_kec"          : data.namaKecamatan,
      "id_kab"          : data.namaKabupaten,
      "id_prov"         : data.namaProvinsi,
      "kode_pos"        : data.kodePos,
      "telepon"         : data.telepon,
      "email"           : data.email,
      "pendidikan"      : data.pendidikanTerakhir,
      "no_ktp"          : data.noKtp,
      "no_bpjs_kes"     : data.noBpjsKes,
      "no_asuransi"     : data.noAsuransi
    }, options: Options(headers: await Header().getHeader()));
    if (respon.statusCode == 200) {
      return basicResponFromJson(respon.data);
    } else {
      return BasicRespon(success: false);
    }
  }

  Future<BasicRespon> deletePengajuanDataDiri() async {
    var respon = await dio.delete("data_diri/delete-pengajuan", options: Options(headers: await Header().getHeader()));
    if (respon.statusCode == 200) {
      return basicResponFromJson(respon.data);
    } else {
      return BasicRespon(success: false);
    }
  }

  Future<DataDataDiriRespon> getDetailDataDiriById(DataNotifikasiAkun data) async {
    var respon = await dio.get("data_diri/data-detail-by-id",
        queryParameters: { "id":  data.id, "konteks" : data.jenis}, options: Options(headers: await Header().getHeader()));
    print(respon.data);
    if (respon.statusCode == 200) {
      return dataDataDiriResponFromJson(respon.data);
    } else {
      return DataDataDiriRespon(success: false);
    }
  }

}
