// To parse this JSON data, do
//
//     final masterDetailUser = masterDetailUserFromJson(jsonString);

import 'dart:convert';

MasterDetailUser masterDetailUserFromJson(String str) =>
    MasterDetailUser.fromJson(json.decode(str));

String masterDetailUserToJson(MasterDetailUser data) =>
    json.encode(data.toJson());

class MasterDetailUser {
  MasterDetailUser({
    this.success,
    this.data,
  });

  bool? success;
  DetailUser? data;

  factory MasterDetailUser.fromJson(Map<String, dynamic> json) =>
      MasterDetailUser(
        success: json["success"],
        data: DetailUser.fromJson(json["data"]),
      );

  Map<String, dynamic> toJson() => {
        "success": success,
        "data": data!.toJson(),
      };
}

class DetailUser {
  DetailUser({
    this.namaKaryawan,
    this.jenisKelamin,
    this.tempatLahir,
    this.tglLahir,
    this.telepon,
    this.email,
    this.company,
    this.cabang,
    this.departemen,
    this.jabatan,
  });

  String? namaKaryawan;
  String? jenisKelamin;
  String? tempatLahir;
  String? tglLahir;
  String? telepon;
  String? email;
  String? company;
  String? cabang;
  String? departemen;
  String? jabatan;

  factory DetailUser.fromJson(Map<String, dynamic> json) => DetailUser(
        namaKaryawan: json["nama_karyawan"],
        jenisKelamin: json["jenis_kelamin"],
        tempatLahir: json["tempat_lahir"],
        tglLahir: json["tgl_lahir"],
        telepon: json["telepon"],
        email: json["email"],
        company: json["company"],
        cabang: json["cabang"],
        departemen: json["departemen"],
        jabatan: json["jabatan"],
      );

  Map<String, dynamic> toJson() => {
        "nama_karyawan": namaKaryawan,
        "jenis_kelamin": jenisKelamin,
        "tempat_lahir": tempatLahir,
        "tgl_lahir": tglLahir,
        "telepon": telepon,
        "email": email,
        "company": company,
        "cabang": cabang,
        "departemen": departemen,
        "jabatan": jabatan,
      };
}






FaceRespon faceResponFromJson(String str) => FaceRespon.fromJson(json.decode(str));

String faceResponToJson(FaceRespon data) => json.encode(data.toJson());

class FaceRespon {
  FaceRespon({
    this.success,
    this.message,
    this.faceData,
  });

  bool? success;
  String? message;
  String? faceData;

  factory FaceRespon.fromJson(Map<String, dynamic> json) => FaceRespon(
    success: json["success"] == null ? null : json["success"],
    message: json["message"] == null ? null : json["message"],
    faceData: json["data"] == null ? null : json["data"],
  );

  Map<String, dynamic> toJson() => {
    "success": success == null ? null : success,
    "message": message == null ? null : message,
    "data": faceData == null ? null : faceData,
  };
}

