// To parse this JSON data, do
//
//     final sosRespon = sosResponFromJson(jsonString);

import 'dart:convert';

import 'package:absenkuv3/UI/Template/MultiImagePicker/Model/MultiImagePickerModel.dart';

// SosRespon sosResponFromJson(String str) => SosRespon.fromJson(json.decode(str));

// String sosResponToJson(SosRespon data) => json.encode(data.toJson());

SosRespon sosResponFromJson(String str) => SosRespon.fromJson(json.decode(str));

String sosResponToJson(SosRespon data) => json.encode(data.toJson());

class SosRespon {
  SosRespon({
    this.success,
    this.message,
    this.dataSos,
  });

  bool? success;
  String? message;
  List<DataSo>? dataSos;

  factory SosRespon.fromJson(Map<String, dynamic> json) => SosRespon(
        success: json["success"],
        message: json["message"],
        dataSos: json["data"] == null
            ? null
            : List<DataSo>.from(json["data"].map((x) => DataSo.fromJson(x))),
      );

  Map<String, dynamic> toJson() => {
        "success": success,
        "message": message,
        "data": dataSos == null
            ? []
            : List<dynamic>.from(dataSos!.map((x) => x.toJson())),
      };
}

class DataSo {
  DataSo({
    this.idSos,
    this.idKaryawan,
    this.tanggal,
    this.keterangan,
    this.nama,
    this.listImage,
  });

  String? idSos;
  String? idKaryawan;
  String? tanggal;
  String? keterangan;
  String? nama;
  List<ListImage>? listImage;

  factory DataSo.fromJson(Map<String, dynamic> json) => DataSo(
        idSos: json["id"],
        idKaryawan: json["id_karyawan"],
        tanggal: json["tanggal"],
        keterangan: json["keterangan"],
        nama: json["nama"],
        listImage: List<ListImage>.from(
            json["list_image"].map((x) => ListImage.fromJson(x))),
      );

  Map<String, dynamic> toJson() => {
        "id": idSos,
        "id_karyawan": idKaryawan,
        "tanggal": tanggal,
        "keterangan": keterangan,
        "nama": nama,
        "list_image": List<dynamic>.from(listImage!.map((x) => x.toJson())),
      };
}

class ListImage {
  ListImage({
    this.file,
  });

  String? file;

  factory ListImage.fromJson(Map<String, dynamic> json) => ListImage(
        file: json["file"],
      );

  Map<String, dynamic> toJson() => {
        "file": file,
      };
}

class ModelPengajuanSos {
  String? keterangan;
  List<MultiImagePickerModel>? listImage;
  ModelPengajuanSos(
    this.keterangan,
    this.listImage,
  );
}
