import 'dart:convert';

PkwtRespon pwktResponFromJson(String str) =>
    PkwtRespon.fromJson(json.decode(str));

String pkwtResponToJson(PkwtRespon data) => json.encode(data.toJson());

class PkwtRespon {
  bool? success;
  String? message;
  List<DataPkwt>? data;

  PkwtRespon({this.success, this.message, this.data});
  factory PkwtRespon.fromJson(Map<String, dynamic> json) => PkwtRespon(
        success: json["success"] == null ? null : json["success"],
        message: json["message"] == null ? null : json["message"],
        data: json["data"] == null
            ? null
            : List<DataPkwt>.from(
                json["data"].map((x) => DataPkwt.fromJson(x))),
      );

  Map<String, dynamic> toJson() => {
        "success": success == null ? null : success,
        "message": message == null ? null : message,
        "data": data == null
            ? null
            : List<dynamic>.from(data!.map((x) => x.toJson())),
      };
}

class DataPkwt {
  String? idPkwt;
  String? noPkwt;
  String? nik;
  String? nmLevelUser;
  String? nmJabatan;
  String? nmCabang;
  String? nmDepartemen;
  String? ketTolak;
  List<ListApproval>? listApproval;
  String? nmKaryawan;
  String? tglPkwt;
  String? urlFile;
  String? urlDownload;
  String? statusHandle;
  String? status;
  String? warnaStatus;
  String? warnaFont;
  bool? aksi;

  DataPkwt(
      {this.idPkwt,
      this.noPkwt,
      this.nik,
      this.nmLevelUser,
      this.nmJabatan,
      this.nmCabang,
      this.nmDepartemen,
      this.ketTolak,
      this.listApproval,
      this.nmKaryawan,
      this.statusHandle,
      this.status,
      this.tglPkwt,
      this.urlFile,
      this.urlDownload,
      this.aksi,
      this.warnaStatus,
      this.warnaFont});

  factory DataPkwt.fromJson(Map<String, dynamic> json) => DataPkwt(
        idPkwt: json["id_pkwt"] == null ? null : json["id_pkwt"],
        noPkwt: json["no_pkwt"] == null ? null : json["no_pkwt"],
        nik: json["nik"],
        nmLevelUser:
            json["nm_level_user"] == null ? null : json["nm_level_user"],
        nmJabatan: json["nm_jabatan"] == null ? null : json["nm_jabatan"],
        nmCabang: json["nm_cabang"] == null ? null : json["nm_cabang"],
        nmDepartemen:
            json["nm_departemen"] == null ? null : json["nm_departemen"],
        ketTolak: json["ket_tolak"] == null ? null : json["ket_tolak"],
        tglPkwt: json["tgl_pkwt"] == null ? null : json["tgl_pkwt"],
        nmKaryawan: json["nm_karyawan"] == null ? null : json["nm_karyawan"],
        statusHandle:
            json["status_handle"] == null ? null : json["status_handle"],
        status: json["status"] == null ? null : json["status"],
        urlFile: json["url_file"] == null ? null : json["url_file"],
        urlDownload: json["url_file_download"] == null
            ? null
            : json["url_file_download"],
        warnaStatus: json["warna_status"] == null ? null : json["warna_status"],
        warnaFont: json["warna_font"] == null ? null : json["warna_font"],
        aksi: json["aksi"] == null ? null : json["aksi"],
        listApproval: json["list_approval"] == null
            ? null
            : List<ListApproval>.from(
                json["list_approval"].map((x) => ListApproval.fromJson(x))),
      );
  Map<String, dynamic> toJson() => {
        "id_pkwt": idPkwt == null ? null : idPkwt,
        "no_pkwt": noPkwt == null ? null : noPkwt,
        "nik": nik == null ? null : nik,
        "nm_level_user": nmLevelUser == null ? null : nmLevelUser,
        "nm_jabatan": nmJabatan == null ? null : nmJabatan,
        "nm_cabang": nmCabang == null ? null : nmCabang,
        "nm_departemen": nmDepartemen == null ? null : nmDepartemen,
        "ket_tolak": ketTolak == null ? null : ketTolak,
        "tgl_pkwt": tglPkwt == null ? null : tglPkwt,
        "nm_karyawan": nmKaryawan == null ? null : nmKaryawan,
        "status_handle": statusHandle == null ? null : statusHandle,
        "url_file": urlFile == null ? null : urlFile,
        "url_file_download": urlDownload == null ? null : urlDownload,
        "status": status == null ? null : status,
        "warna_status": warnaStatus == null ? null : warnaStatus,
        "warna_font": warnaFont == null ? null : warnaFont,
        "aksi": aksi == null ? null : aksi,
      };
  DataPkwt copyWith({
    String? status,
    String? warnaFont,
    String? warnaStatus,
    String? idPkwt,
    String? noPkwt,
    String? nik,
    String? nmLevelUser,
    String? nmJabatan,
    String? nmCabang,
    String? nmDepartemen,
    String? ketTolak,
    List<ListApproval>? listApproval,
    String? nmKaryawan,
    String? tglPkwt,
    String? urlFile,
    String? urlDownload,
    String? statusHandle,
    bool? aksi,
  }) {
    return DataPkwt(
      status: status ?? this.status,
      warnaFont: warnaFont ?? this.warnaFont,
      warnaStatus: warnaStatus ?? this.warnaStatus,
      idPkwt: idPkwt ?? this.idPkwt,
      noPkwt: noPkwt ?? this.noPkwt,
      nik: nik ?? this.nik,
      nmLevelUser: nmLevelUser ?? this.nmLevelUser,
      nmJabatan: nmJabatan ?? this.nmJabatan,
      nmCabang: nmCabang ?? this.nmCabang,
      nmDepartemen: nmDepartemen ?? this.nmDepartemen,
      ketTolak: ketTolak ?? this.ketTolak,
      listApproval: listApproval ?? this.listApproval,
      nmKaryawan: nmKaryawan ?? this.nmKaryawan,
      tglPkwt: tglPkwt ?? this.tglPkwt,
      urlFile: urlFile ?? this.urlFile,
      urlDownload: urlDownload ?? this.urlDownload,
      statusHandle: statusHandle ?? this.statusHandle,
      aksi: aksi ?? this.aksi,
    );
  }
}

class ListApproval {
  ListApproval(
      {this.statusApproval,
      this.tanggalApproval,
      this.warnaStatus,
      this.warnaFont});

  String? statusApproval;
  dynamic tanggalApproval;
  String? warnaStatus;
  String? warnaFont;

  factory ListApproval.fromJson(Map<String, dynamic> json) => ListApproval(
        statusApproval:
            json["status_approval"] == null ? null : json["status_approval"],
        tanggalApproval: json["tanggal_approval"],
        warnaStatus: json["warna_status"] == null ? null : json["warna_status"],
        warnaFont: json["warna_font"] == null ? null : json["warna_font"],
      );

  Map<String, dynamic> toJson() => {
        "status_approval": statusApproval == null ? null : statusApproval,
        "tanggal_approval": tanggalApproval,
        "warna_status": warnaStatus == null ? null : warnaStatus,
        "warna_font": warnaFont == null ? null : warnaFont,
      };
}

class TolakPkwtModel {
  String id_pkwt;
  String alasanTolak;
  TolakPkwtModel({
    required this.id_pkwt,
    required this.alasanTolak,
  });
}

class SetujuiPkwtModel {
  String id_pkwt;
  String image;
  String no_pkwt;
  SetujuiPkwtModel(
      {required this.id_pkwt, required this.image, required this.no_pkwt});
}

// To parse this JSON data, do
//
//     final badgePkwt = badgePkwtFromJson(jsonString);

BadgePkwt badgePkwtFromJson(String str) => BadgePkwt.fromJson(json.decode(str));

String badgePkwtToJson(BadgePkwt data) => json.encode(data.toJson());

class BadgePkwt {
  bool? success;
  String? message;
  int? data;

  BadgePkwt({
    this.success,
    this.message,
    this.data,
  });

  factory BadgePkwt.fromJson(Map<String, dynamic> json) => BadgePkwt(
        success: json["success"],
        message: json["message"],
        data: json["data"],
      );

  Map<String, dynamic> toJson() => {
        "success": success,
        "message": message,
        "data": data,
      };
}
