import 'dart:convert';

import 'package:absenkuv3/UI/Template/MultiImagePicker/Model/MultiImagePickerModel.dart';

class ModelIzin {
  String? idJenisIzin;
  String? namaJenisIzin;
  String? jenisIzin;
  String? tanggalMulai;
  String? tanggalSelesai;
  String keterangan;
  String jumlahIzin;
  String? sisaCuti;
  String? flag;
  List<MultiImagePickerModel>? listImage;
  ModelIzin(
      this.idJenisIzin,
      this.namaJenisIzin,
      this.jenisIzin,
      this.tanggalMulai,
      this.tanggalSelesai,
      this.keterangan,
      this.listImage,
      this.jumlahIzin,
      {this.sisaCuti,
      this.flag});
}

IzinRespon izinResponFromJson(String str) =>
    IzinRespon.fromJson(json.decode(str));

String izinResponToJson(IzinRespon data) => json.encode(data.toJson());

class IzinRespon {
  IzinRespon({
    this.success,
    this.message,
    this.data,
  });

  bool? success;
  String? message;
  List<DataIzin>? data;

  factory IzinRespon.fromJson(Map<String, dynamic> json) => IzinRespon(
        success: json["success"] == null ? null : json["success"],
        message: json["message"] == null ? null : json["message"],
        data: json["data"] == null
            ? null
            : List<DataIzin>.from(
                json["data"].map((x) => DataIzin.fromJson(x))),
      );

  Map<String, dynamic> toJson() => {
        "success": success == null ? null : success,
        "message": message == null ? null : message,
        "data": data == null
            ? null
            : List<dynamic>.from(data!.map((x) => x.toJson())),
      };
}

class DataIzin {
  DataIzin(
      {this.idIzin,
      this.idKaryawan,
      this.jumlahIzin,
      this.status,
      this.warnaStatus,
      this.tglPengajuan,
      this.namaIzin,
      this.jenisIzin,
      this.warnaBgIzin,
      this.warnaFontIzin,
      this.nama,
      this.jabatan,
      this.cabang,
      this.departemen,
      this.ketIzin,
      this.tglIzin,
      this.tglMulaiIzin,
      this.tglSelesaiIzin,
      this.listApproval,
      this.listImage,
      this.aksi,
      this.buttonApprovalHrd,
      this.aksiBatalkan,
      this.flag});

  String? idIzin;
  String? idKaryawan;
  String? jumlahIzin;
  String? status;
  String? warnaStatus;
  String? tglPengajuan;
  String? namaIzin;
  String? jenisIzin;
  String? warnaBgIzin;
  String? warnaFontIzin;
  String? nama;
  String? jabatan;
  String? cabang;
  String? departemen;
  String? ketIzin;
  String? tglIzin;
  String? tglMulaiIzin;
  String? tglSelesaiIzin;
  List<ListApproval>? listApproval;
  List<ListImage>? listImage;
  bool? aksi;
  bool? aksiBatalkan;
  bool? buttonApprovalHrd;
  String? flag;

  factory DataIzin.fromJson(Map<String, dynamic> json) => DataIzin(
        idIzin: json["id_izin"] == null ? null : json["id_izin"],
        idKaryawan: json["id_karyawan"] == null ? null : json["id_karyawan"],
        jumlahIzin: json["jumlah_izin"] == null ? null : json["jumlah_izin"],
        status: json["status"] == null ? null : json["status"],
        warnaStatus: json["warna_status"] == null ? null : json["warna_status"],
        buttonApprovalHrd: json["button_approval_hrd"] == null
            ? null
            : json["button_approval_hrd"],
        tglPengajuan:
            json["tgl_pengajuan"] == null ? null : json["tgl_pengajuan"],
        namaIzin: json["nama_izin"] == null ? null : json["nama_izin"],
        jenisIzin: json["jenis_izin"] == null ? null : json["jenis_izin"],
        warnaBgIzin:
            json["warna_bg_izin"] == null ? null : json["warna_bg_izin"],
        warnaFontIzin:
            json["warna_font_izin"] == null ? null : json["warna_font_izin"],
        nama: json["nama"] == null ? null : json["nama"],
        jabatan: json["jabatan"] == null ? null : json["jabatan"],
        cabang: json["cabang"] == null ? null : json["cabang"],
        departemen: json["departemen"] == null ? null : json["departemen"],
        ketIzin: json["ket_izin"] == null ? null : json["ket_izin"],
        tglIzin: json["tgl_izin"] == null ? null : json["tgl_izin"],
        tglMulaiIzin:
            json["tgl_mulai_izin"] == null ? null : json["tgl_mulai_izin"],
        tglSelesaiIzin:
            json["tgl_selesai_izin"] == null ? null : json["tgl_selesai_izin"],
        listApproval: json["list_approval"] == null
            ? null
            : List<ListApproval>.from(
                json["list_approval"].map((x) => ListApproval.fromJson(x))),
        listImage: json["list_image"] == null
            ? null
            : List<ListImage>.from(
                json["list_image"].map((x) => ListImage.fromJson(x))),
        aksi: json["aksi"] == null ? null : json["aksi"],
        aksiBatalkan:
            json["aksi_batalkan"] == null ? null : json["aksi_batalkan"],
        flag:
            json["flag"] == null ? null : json["flag"],
      );

  Map<String, dynamic> toJson() => {
        "id_izin": idIzin == null ? null : idIzin,
        "status": status == null ? null : status,
        "warna_status": warnaStatus == null ? null : warnaStatus,
        "button_approval_hrd":
            buttonApprovalHrd == null ? null : buttonApprovalHrd,
        "tgl_pengajuan": tglPengajuan == null ? null : tglPengajuan,
        "nama_izin": namaIzin == null ? null : namaIzin,
        "jenis_izin": jenisIzin == null ? null : jenisIzin,
        "warna_bg_izin": warnaBgIzin == null ? null : warnaBgIzin,
        "warna_font_izin": warnaFontIzin == null ? null : warnaFontIzin,
        "nama": nama == null ? null : nama,
        "jabatan": jabatan == null ? null : jabatan,
        "cabang": cabang == null ? null : cabang,
        "departemen": departemen == null ? null : departemen,
        "ket_izin": ketIzin == null ? null : ketIzin,
        "tgl_izin": tglIzin == null ? null : tglIzin,
        "tgl_mulai_izin": tglMulaiIzin == null ? null : tglMulaiIzin,
        "tgl_selesai_izin": tglSelesaiIzin == null ? null : tglSelesaiIzin,
        "list_approval": listApproval == null
            ? null
            : List<dynamic>.from(listApproval!.map((x) => x.toJson())),
        "list_image": listImage == null
            ? null
            : List<dynamic>.from(listImage!.map((x) => x.toJson())),
        "aksi": aksi == null ? null : aksi,
        "aksi_batalkan": aksiBatalkan == null ? null : aksiBatalkan,
        "flag": flag == null ? null : flag,
      };
}

class ListApproval {
  ListApproval(
      {this.statusApproval,
      this.tanggalApproval,
      this.warnaStatus,
      this.warnaFont});

  String? statusApproval;
  dynamic tanggalApproval;
  String? warnaStatus;
  String? warnaFont;

  factory ListApproval.fromJson(Map<String, dynamic> json) => ListApproval(
        statusApproval:
            json["status_approval"] == null ? null : json["status_approval"],
        tanggalApproval: json["tanggal_approval"],
        warnaStatus: json["warna_status"] == null ? null : json["warna_status"],
        warnaFont: json["warna_font"] == null ? null : json["warna_font"],
      );

  Map<String, dynamic> toJson() => {
        "status_approval": statusApproval == null ? null : statusApproval,
        "tanggal_approval": tanggalApproval,
        "warna_status": warnaStatus == null ? null : warnaStatus,
        "warna_font": warnaFont == null ? null : warnaFont,
      };
}

class ListImage {
  ListImage({
    this.file,
  });

  String? file;

  factory ListImage.fromJson(Map<String, dynamic> json) => ListImage(
        file: json["file"] == null ? null : json["file"],
      );

  Map<String, dynamic> toJson() => {
        "file": file == null ? null : file,
      };
}

JenisIzinRespon jenisIzinResponFromJson(String str) =>
    JenisIzinRespon.fromJson(json.decode(str));

String jenisIzinResponToJson(JenisIzinRespon data) =>
    json.encode(data.toJson());

class JenisIzinRespon {
  JenisIzinRespon({
    this.success,
    this.message,
    this.data,
  });

  bool? success;
  String? message;
  List<DataJenisIzin>? data;

  factory JenisIzinRespon.fromJson(Map<String, dynamic> json) =>
      JenisIzinRespon(
        success: json["success"] == null ? null : json["success"],
        message: json["message"] == null ? null : json["message"],
        data: json["data"] == null
            ? null
            : List<DataJenisIzin>.from(
                json["data"].map((x) => DataJenisIzin.fromJson(x))),
      );

  Map<String, dynamic> toJson() => {
        "success": success == null ? null : success,
        "message": message == null ? null : message,
        "data": data == null
            ? null
            : List<dynamic>.from(data!.map((x) => x.toJson())),
      };
}

class DataJenisIzin {
  DataJenisIzin(
      {this.id,
      this.nama,
      this.jenisIzin,
      this.flag,
      this.backDate,
      this.flagKalender,
      this.flagFile,
      this.informasi});

  String? id;
  String? nama;
  String? jenisIzin;
  String? flag;
  int? backDate;
  String? flagKalender;
  String? flagFile;
  Informasi? informasi;
  factory DataJenisIzin.fromJson(Map<String, dynamic> json) => DataJenisIzin(
        id: json["id"] == null ? null : json["id"],
        nama: json["nama"] == null ? null : json["nama"],
        jenisIzin: json["jenis_izin"] == null ? null : json["jenis_izin"],
        flag: json["flag"] == null ? null : json["flag"],
        backDate: json["back_date"] == null ? null : json["back_date"],
        flagKalender:
            json["flag_kalender"] == null ? null : json["flag_kalender"],
        flagFile: json["flag_file"] == null ? null : json["flag_file"],
        informasi: Informasi.fromJson(json["informasi"]),
      );

  Map<String, dynamic> toJson() => {
        "id": id == null ? null : id,
        "nama": nama == null ? null : nama,
        "jenis_izin": jenisIzin == null ? null : jenisIzin,
        "back_date": backDate == null ? null : backDate,
        "flag_kalender": flagKalender == null ? null : flagKalender,
        "flag_file": flagFile == null ? null : flagFile,
        "informasi": informasi!.toJson(),
      };
}

SisaCutiRespon sisaCutiResponFromJson(String str) =>
    SisaCutiRespon.fromJson(json.decode(str));

String sisaCutiResponToJson(SisaCutiRespon data) => json.encode(data.toJson());

class SisaCutiRespon {
  SisaCutiRespon({
    this.success,
    this.message,
    this.sisaCuti,
  });

  bool? success;
  String? message;
  int? sisaCuti;

  factory SisaCutiRespon.fromJson(Map<String, dynamic> json) => SisaCutiRespon(
        success: json["success"] == null ? null : json["success"],
        message: json["message"] == null ? null : json["message"],
        sisaCuti: json["sisa_cuti"] == null ? null : json["sisa_cuti"],
      );

  Map<String, dynamic> toJson() => {
        "success": success == null ? null : success,
        "message": message == null ? null : message,
        "sisa_cuti": sisaCuti == null ? null : sisaCuti,
      };
}

class Informasi {
    String? maksimalIzin;
    String? kalender;
    String? fileUpload;
    String? backDate;
    String? mengurangiCuti;

    Informasi({
        this.maksimalIzin,
        this.kalender,
        this.fileUpload,
        this.backDate,
        this.mengurangiCuti,
    });

    factory Informasi.fromJson(Map<String, dynamic> json) => Informasi(
        maksimalIzin: json["maksimal_izin"],
        kalender: json["kalender"],
        fileUpload: json["file_upload"],
        backDate: json["back_date"],
        mengurangiCuti: json["mengurangi_cuti"],
    );

    Map<String, dynamic> toJson() => {
        "maksimal_izin": maksimalIzin,
        "kalender": kalender,
        "file_upload": fileUpload,
        "back_date": backDate,
        "mengurangi_cuti": mengurangiCuti,
    };
}