// To parse this JSON data, do
//
//     final filterHeader = filterHeaderFromJson(jsonString);

import 'dart:convert';

FilterHeader filterHeaderFromJson(String str) =>
    FilterHeader.fromJson(json.decode(str));

String filterHeaderToJson(FilterHeader data) => json.encode(data.toJson());

class FilterHeader {
  bool? success;
  String? message;
  List<Data>? data;

  FilterHeader({
    this.success,
    this.message,
    this.data,
  });

  factory FilterHeader.fromJson(Map<String, dynamic> json) => FilterHeader(
        success: json["success"],
        message: json["message"],
        data: List<Data>.from(
            json["data"].map((x) => Data.fromJson(x))),
      );

  Map<String, dynamic> toJson() => {
        "success": success,
        "message": message,
        "data": List<dynamic>.from(data!.map((x) => x.toJson())),
      };
}

class Data {
  String? nama;
  String? value;

  Data({
    this.nama,
    this.value,
  });

  factory Data.fromJson(Map<String, dynamic> json) => Data(
        nama: json["nama"],
        value: json["value"],
      );

  Map<String, dynamic> toJson() => {
        "nama": nama,
        "value": value,
      };
}
