// To parse this JSON data, do
//
//     final aktivitasRespon = aktivitasResponFromJson(jsonString);

import 'dart:convert';

AktivitasRespon aktivitasResponFromJson(String str) => AktivitasRespon.fromJson(json.decode(str));

String aktivitasResponToJson(AktivitasRespon data) => json.encode(data.toJson());

class AktivitasRespon {
  bool? success;
  String? message;
  List<DataAktivitas>? data;

  AktivitasRespon({this.success, this.message, this.data});

  AktivitasRespon.fromJson(Map<String, dynamic> json) {
    success = json['success'];
    message = json['message'];
    if (json['data'] != null) {
      data = <DataAktivitas>[];
      json['data'].forEach((v) {
        data!.add(new DataAktivitas.fromJson(v));
      });
    }
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['success'] = this.success;
    data['message'] = this.message;
    if (this.data != null) {
      data['data'] = this.data!.map((v) => v.toJson()).toList();
    }
    return data;
  }
}

class DataAktivitas {
  String? idAktivitas;
  String? idKaryawan;
  String? namaKaryawan;
  String? tanggalRaw;
  String? hari;
  String? tanggal;
  String? bulan;
  String? waktu;
  String? namajabatan;
  String? namaDepartemen;
  String? namaCabang;
  String? lokasi;
  String? latitude;
  String? longitude;
  String? keterangan;
  String? image;

  DataAktivitas(
      {this.idAktivitas,
        this.idKaryawan,
        this.namaKaryawan,
        this.tanggalRaw,
        this.hari,
        this.tanggal,
        this.bulan,
        this.waktu,
        this.namajabatan,
        this.namaDepartemen,
        this.namaCabang,
        this.lokasi,
        this.latitude,
        this.longitude,
        this.keterangan,
        this.image});

  DataAktivitas.fromJson(Map<String, dynamic> json) {
    idAktivitas = json['id_aktivitas'];
    idKaryawan = json['id_karyawan'];
    namaKaryawan = json['nama_karyawan'];
    tanggalRaw = json['tanggal_raw'];
    hari = json['hari'];
    tanggal = json['tanggal'];
    bulan = json['bulan'];
    waktu = json['waktu'];
    namajabatan = json['namajabatan'];
    namaDepartemen = json['nama_departemen'];
    namaCabang = json['nama_cabang'];
    lokasi = json['lokasi'];
    latitude = json['latitude'];
    longitude = json['longitude'];
    keterangan = json['keterangan'];
    image = json['image'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['id_aktivitas'] = this.idAktivitas;
    data['id_karyawan'] = this.idKaryawan;
    data['nama_karyawan'] = this.namaKaryawan;
    data['tanggal_raw'] = this.tanggalRaw;
    data['hari'] = this.hari;
    data['tanggal'] = this.tanggal;
    data['bulan'] = this.bulan;
    data['waktu'] = this.waktu;
    data['namajabatan'] = this.namajabatan;
    data['nama_departemen'] = this.namaDepartemen;
    data['nama_cabang'] = this.namaCabang;
    data['lokasi'] = this.lokasi;
    data['latitude'] = this.latitude;
    data['longitude'] = this.longitude;
    data['keterangan'] = this.keterangan;
    data['image'] = this.image;
    return data;
  }
}




CekLokasiRespon cekLokasiResponFromJson(String str) => CekLokasiRespon.fromJson(json.decode(str));

String cekLokasiResponToJson(CekLokasiRespon data) => json.encode(data.toJson());

class CekLokasiRespon {
  CekLokasiRespon({
    this.success,
    this.message,
    this.tanggal,
    this.cekLokasi,
  });

  bool? success;
  String? message;
  String? tanggal;
  CekLokasi? cekLokasi;

  factory CekLokasiRespon.fromJson(Map<String, dynamic> json) => CekLokasiRespon(
    success: json["success"] == null ? null : json["success"],
    message: json["message"] == null ? null : json["message"],
    tanggal: json["tanggal"] == null ? null : json["tanggal"],
    cekLokasi: json["CekLokasi"] == null ? null : CekLokasi.fromJson(json["CekLokasi"]),
  );

  Map<String, dynamic> toJson() => {
    "success": success == null ? null : success,
    "message": message == null ? null : message,
    "tanggal": tanggal == null ? null : tanggal,
    "CekLokasi": cekLokasi == null ? null : cekLokasi!.toJson(),
  };
}

class CekLokasi {
  CekLokasi({
    this.status,
    this.lockLokasi,
    this.bolehAbsen,
    this.namaLokasi,
    this.ketLokasi,
  });

  bool? status;
  bool? lockLokasi;
  bool? bolehAbsen;
  String? namaLokasi;
  String? ketLokasi;

  factory CekLokasi.fromJson(Map<String, dynamic> json) => CekLokasi(
    status: json["status"] == null ? null : json["status"],
    lockLokasi: json["lock_lokasi"] == null ? null : json["lock_lokasi"],
    bolehAbsen: json["boleh_absen"] == null ? null : json["boleh_absen"],
    namaLokasi: json["nama_lokasi"] == null ? null : json["nama_lokasi"],
    ketLokasi: json["ket_lokasi"] == null ? null : json["ket_lokasi"],
  );

  Map<String, dynamic> toJson() => {
    "status": status == null ? null : status,
    "lock_lokasi": lockLokasi == null ? null : lockLokasi,
    "boleh_absen": bolehAbsen == null ? null : bolehAbsen,
    "nama_lokasi": namaLokasi == null ? null : namaLokasi,
    "ket_lokasi": ketLokasi == null ? null : ketLokasi,
  };
}

