import 'dart:convert';

TotalKanbanRespon totalKanbanResponFromJson(String str) => TotalKanbanRespon.fromJson(json.decode(str));

String totalKanbanResponToJson(TotalKanbanRespon data) => json.encode(data.toJson());

class TotalKanbanRespon {
  bool? success;
  String? message;
  DataTotal? dataTotal;

  TotalKanbanRespon({this.success, this.message, this.dataTotal});

  TotalKanbanRespon.fromJson(Map<String, dynamic> json) {
    success = json['success'];
    message = json['message'];
    dataTotal = json['data_total'] != null
        ? new DataTotal.fromJson(json['data_total'])
        : null;
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['success'] = this.success;
    data['message'] = this.message;
    if (this.dataTotal != null) {
      data['data_total'] = this.dataTotal!.toJson();
    }
    return data;
  }
}

class DataTotal {
  String? totalLead;
  String? totalNominal;

  DataTotal({this.totalLead, this.totalNominal});

  DataTotal.fromJson(Map<String, dynamic> json) {
    totalLead = json['total_lead'];
    totalNominal = json['total_nominal'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['total_lead'] = this.totalLead;
    data['total_nominal'] = this.totalNominal;
    return data;
  }
}
