import 'dart:convert';

TargetSalesRespon targetSalesResponFromJson(String str) => TargetSalesRespon.fromJson(json.decode(str));

String targetSalesResponToJson(TargetSalesRespon data) => json.encode(data.toJson());

class TargetSalesRespon {
  bool? success;
  String? message;
  DataTarget? dataTarget;

  TargetSalesRespon({this.success, this.message, this.dataTarget});

  TargetSalesRespon.fromJson(Map<String, dynamic> json) {
    success = json['success'];
    message = json['message'];
    dataTarget = json['data_target'] != null
        ? new DataTarget.fromJson(json['data_target'])
        : null;
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['success'] = this.success;
    data['message'] = this.message;
    if (this.dataTarget != null) {
      data['data_target'] = this.dataTarget!.toJson();
    }
    return data;
  }
}

class DataTarget {
  TargetNominalBulanan? targetNominalBulanan;
  String? targetPointHarian;
  String? realisasiPointHarian;

  DataTarget(
      {this.targetNominalBulanan,
        this.targetPointHarian,
        this.realisasiPointHarian});

  DataTarget.fromJson(Map<String, dynamic> json) {
    targetNominalBulanan = json['target_nominal_bulanan'] != null
        ? new TargetNominalBulanan.fromJson(json['target_nominal_bulanan'])
        : null;
    targetPointHarian = json['target_point_harian'];
    realisasiPointHarian = json['realisasi_point_harian'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    if (this.targetNominalBulanan != null) {
      data['target_nominal_bulanan'] = this.targetNominalBulanan!.toJson();
    }
    data['target_point_harian'] = this.targetPointHarian;
    data['realisasi_point_harian'] = this.realisasiPointHarian;
    return data;
  }
}

class TargetNominalBulanan {
  String? nominalRealisasi;
  String? jumlahPo;
  String? nominalTarget;

  TargetNominalBulanan(
      {this.nominalRealisasi, this.jumlahPo, this.nominalTarget});

  TargetNominalBulanan.fromJson(Map<String, dynamic> json) {
    nominalRealisasi = json['nominal_realisasi'];
    jumlahPo = json['jumlah_po'];
    nominalTarget = json['nominal_target'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['nominal_realisasi'] = this.nominalRealisasi;
    data['jumlah_po'] = this.jumlahPo;
    data['nominal_target'] = this.nominalTarget;
    return data;
  }
}

