import 'dart:convert';

PerusahaanRespon perusahaanResponFromJson(String str) => PerusahaanRespon.fromJson(json.decode(str));

String perusahaanResponToJson(PerusahaanRespon data) => json.encode(data.toJson());

class PerusahaanRespon {
  bool? success;
  String? message;
  List<DataPerusahaan>? data;

  PerusahaanRespon({this.success, this.message, this.data});

  PerusahaanRespon.fromJson(Map<String, dynamic> json) {
    success = json['success'];
    message = json['message'];
    if (json['data'] != null) {
      data = <DataPerusahaan>[];
      json['data'].forEach((v) {
        data!.add(new DataPerusahaan.fromJson(v));
      });
    }
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['success'] = this.success;
    data['message'] = this.message;
    if (this.data != null) {
      data['data'] = this.data!.map((v) => v.toJson()).toList();
    }
    return data;
  }
}

class DataPerusahaan {
  String? title;
  String? keterangan;
  String? idSalesBawahan;
  String? idPelanggan;
  String? namaPerusahaan;
  String? alamat;
  String? picNama;
  String? picEmail;
  String? picTelp;
  JenisPerusahaan? jenisPerusahaan;
  LeadSource? leadSource;
  Provinsi? provinsi;
  Kota? kota;
  Kecamatan? kecamatan;
  Kelurahan? kelurahan;
  bool? pelangganBaru;
  String? kategoriPelanggan;

  DataPerusahaan(
      {this.title,
        this.keterangan,
        this.idSalesBawahan,
        this.idPelanggan,
        this.namaPerusahaan,
        this.alamat,
        this.picNama,
        this.picEmail,
        this.picTelp,
        this.jenisPerusahaan,
        this.leadSource,
        this.provinsi,
        this.kota,
        this.kecamatan,
        this.kelurahan,
        this.pelangganBaru,
        this.kategoriPelanggan});

  DataPerusahaan.fromJson(Map<String, dynamic> json) {
    title = json['title'];
    keterangan = json['keterangan'];
    idSalesBawahan = json['id_sales_bawahan'];
    idPelanggan = json['id_pelanggan'];
    namaPerusahaan = json['nama_perusahaan'];
    alamat = json['alamat'];
    picNama = json['pic_nama'];
    picEmail = json['pic_email'];
    picTelp = json['pic_telp'];
    jenisPerusahaan = json['jenis_perusahaan'] != null
        ? new JenisPerusahaan.fromJson(json['jenis_perusahaan'])
        : null;
    leadSource = json['lead_source'] != null
        ? new LeadSource.fromJson(json['lead_source'])
        : null;
    provinsi = json['provinsi'] != null
        ? new Provinsi.fromJson(json['provinsi'])
        : null;
    kota = json['kota'] != null ? new Kota.fromJson(json['kota']) : null;
    kecamatan = json['kecamatan'] != null ? new Kecamatan.fromJson(json['kecamatan']) : null;
    kelurahan = json['kelurahan'] != null ? new Kelurahan.fromJson(json['kelurahan']) : null;
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['title'] = this.title;
    data['keterangan'] = this.keterangan;
    data['id_sales_bawahan'] = this.idSalesBawahan;
    data['id_pelanggan'] = this.idPelanggan;
    data['nama_perusahaan'] = this.namaPerusahaan;
    data['alamat'] = this.alamat;
    data['pic_nama'] = this.picNama;
    data['pic_email'] = this.picEmail;
    data['pic_telp'] = this.picTelp;
    if (this.jenisPerusahaan != null) {
      data['jenis_perusahaan'] = this.jenisPerusahaan!.toJson();
    }
    if (this.leadSource != null) {
      data['lead_source'] = this.leadSource!.toJson();
    }
    if (this.provinsi != null) {
      data['provinsi'] = this.provinsi!.toJson();
    }
    if (this.kota != null) {
      data['kota'] = this.kota!.toJson();
    }
    if (this.kecamatan != null) {
      data['kecamatan'] = this.kecamatan!.toJson();
    }
    if (this.kelurahan != null) {
      data['kelurahan'] = this.kelurahan!.toJson();
    }
    return data;
  }
}

class JenisPerusahaan {
  String? idJenisPerusahaanM;
  String? namaJenisPerusahaan;

  JenisPerusahaan({this.idJenisPerusahaanM, this.namaJenisPerusahaan});

  JenisPerusahaan.fromJson(Map<String, dynamic> json) {
    idJenisPerusahaanM = json['id_jenis_perusahaan_m'];
    namaJenisPerusahaan = json['nama_jenis_perusahaan'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['id_jenis_perusahaan_m'] = this.idJenisPerusahaanM;
    data['nama_jenis_perusahaan'] = this.namaJenisPerusahaan;
    return data;
  }
}

class LeadSource {
  String? idLeadM;
  String? namaLeadM;

  LeadSource({this.idLeadM, this.namaLeadM});

  LeadSource.fromJson(Map<String, dynamic> json) {
    idLeadM = json['id_lead_m'];
    namaLeadM = json['nama_lead_m'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['id_lead_m'] = this.idLeadM;
    data['nama_lead_m'] = this.namaLeadM;
    return data;
  }
}

class Provinsi {
  int? idProvinsi;
  String? namaProvinsi;

  Provinsi({this.idProvinsi, this.namaProvinsi});

  Provinsi.fromJson(Map<String, dynamic> json) {
    idProvinsi = json['id_provinsi'];
    namaProvinsi = json['nama_provinsi'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['id_provinsi'] = this.idProvinsi;
    data['nama_provinsi'] = this.namaProvinsi;
    return data;
  }
}

class Kota {
  int? idKota;
  String? namaKota;

  Kota({this.idKota, this.namaKota});

  Kota.fromJson(Map<String, dynamic> json) {
    idKota = json['id_kota'];
    namaKota = json['nama_kota'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['id_kota'] = this.idKota;
    data['nama_kota'] = this.namaKota;
    return data;
  }
}

class Kecamatan {
  int? idKecamatan;
  String? namaKecamatan;

  Kecamatan({this.idKecamatan, this.namaKecamatan});

  Kecamatan.fromJson(Map<String, dynamic> json) {
    idKecamatan = json['id_kecamatan'];
    namaKecamatan = json['nama_kecamatan'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['id_kecamatan'] = this.idKecamatan;
    data['nama_kecamatan'] = this.namaKecamatan;
    return data;
  }
}

class Kelurahan {
  int? idKelurahan;
  String? namaKelurahan;

  Kelurahan({this.idKelurahan, this.namaKelurahan});

  Kelurahan.fromJson(Map<String, dynamic> json) {
    idKelurahan = json['id_kelurahan'] == null ? null : json['id_kelurahan'];
    namaKelurahan = json['nama_kelurahan'] == null ? null : json['nama_kelurahan'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['id_kelurahan'] = this.idKelurahan;
    data['nama_kelurahan'] = this.namaKelurahan;
    return data;
  }
}