import 'dart:convert';
import 'package:absenkuv3/Repository/Model/SalesActivity/mDataLayanan.dart';
import 'package:absenkuv3/Repository/Model/SalesActivity/mTotalDataLayananDetail.dart';

DataLayananDetailRespon dataLayananDetailResponFromJson(String str) => DataLayananDetailRespon.fromJson(json.decode(str));

String dataLayananDetailResponToJson(DataLayananDetailRespon data) => json.encode(data.toJson());

class DataLayananDetailRespon {
  bool? success;
  String? message;
  TotalDataLayananDetail? totalDataLayananDetail;
  List<Layanan>? dataLayananDetail;

  DataLayananDetailRespon({this.success, this.message, this.dataLayananDetail});

  DataLayananDetailRespon.fromJson(Map<String, dynamic> json) {
    success = json['success'];
    message = json['message'];
    totalDataLayananDetail = json['total_data_layanan_detail'] != null
        ? new TotalDataLayananDetail.fromJson(json['total_data_layanan_detail'])
        : null;
    if (json['data_layanan_detail'] != null) {
      dataLayananDetail = <Layanan>[];
      json['data_layanan_detail'].forEach((v) {
        dataLayananDetail!.add(new Layanan.fromJson(v));
      });
    }
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['success'] = this.success;
    data['message'] = this.message;
    if (this.totalDataLayananDetail != null) {
      data['total_data_layanan_detail'] = this.totalDataLayananDetail!.toJson();
    }
    if (this.dataLayananDetail != null) {
      data['data_layanan_detail'] =
          this.dataLayananDetail!.map((v) => v.toJson()).toList();
    }
    return data;
  }
}

// class DataLayananDetail {
//   String? idPipelineMain;
//   String? idPipelineLayanan;
//   String? idProductM;
//   String? kode;
//   String? namaProduct;
//   String? harga;
//   String? jumlah;
//   String? diskon;
//   String? hargaTotal;
//   String? jumlahHarga;
//   String? jumlahDiskon;
//   String? idCompany;
//
//   DataLayananDetail(
//       {this.idPipelineMain,
//         this.idPipelineLayanan,
//         this.idProductM,
//         this.kode,
//         this.namaProduct,
//         this.harga,
//         this.jumlah,
//         this.diskon,
//         this.hargaTotal,
//         this.jumlahHarga,
//         this.jumlahDiskon,
//         this.idCompany});
//
//   DataLayananDetail.fromJson(Map<String, dynamic> json) {
//     idPipelineMain = json['id_pipeline_main'];
//     idPipelineLayanan = json['id_pipeline_layanan'];
//     idProductM = json['id_product_m'];
//     kode = json['kode'];
//     namaProduct = json['nama_product'];
//     harga = json['harga'];
//     jumlah = json['jumlah'];
//     diskon = json['diskon'];
//     hargaTotal = json['harga_total'];
//     jumlahHarga = json['jumlah_harga'];
//     jumlahDiskon = json['jumlah_diskon'];
//     idCompany = json['id_company'];
//   }
//
//   Map<String, dynamic> toJson() {
//     final Map<String, dynamic> data = new Map<String, dynamic>();
//     data['id_pipeline_main'] = this.idPipelineMain;
//     data['id_pipeline_layanan'] = this.idPipelineLayanan;
//     data['id_product_m'] = this.idProductM;
//     data['kode'] = this.kode;
//     data['nama_product'] = this.namaProduct;
//     data['harga'] = this.harga;
//     data['jumlah'] = this.jumlah;
//     data['diskon'] = this.diskon;
//     data['harga_total'] = this.hargaTotal;
//     data['jumlah_harga'] = this.jumlahHarga;
//     data['jumlah_diskon'] = this.jumlahDiskon;
//     data['id_company'] = this.idCompany;
//     return data;
//   }
// }

