import 'dart:convert';

PageShiftModel pageShiftModelFromJson(String str) => PageShiftModel.fromJson(json.decode(str));

String pageShiftModelToJson(PageShiftModel data) => json.encode(data.toJson());

class PageShiftModel {
  MenuShift? menuShift;

  PageShiftModel({this.menuShift});

  PageShiftModel.fromJson(Map<String, dynamic> json) {
    menuShift = json['menu_shift'] != null
        ? new MenuShift.fromJson(json['menu_shift'])
        : null;
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    if (this.menuShift != null) {
      data['menu_shift'] = this.menuShift!.toJson();
    }
    return data;
  }
}

class MenuShift {
  String? title;
  String? tabJadwalSaya;
  String? tabJadwalTeman;
  String? tabJadwalKaryawan;
  String? tabPengajuanSaya;
  String? tabPengajuanKaryawan;
  String? locale;

  MenuShift(
      {this.title,
        this.tabJadwalSaya,
        this.tabJadwalTeman,
        this.tabJadwalKaryawan,
        this.tabPengajuanSaya,
        this.tabPengajuanKaryawan,
        this.locale});

  MenuShift.fromJson(Map<String, dynamic> json) {
    title = json['title'];
    tabJadwalSaya = json['tab_jadwal_saya'];
    tabJadwalTeman = json['tab_jadwal_teman'];
    tabJadwalKaryawan = json['tab_jadwal_karyawan'];
    tabPengajuanSaya = json['tab_pengajuan_saya'];
    tabPengajuanKaryawan = json['tab_pengajuan_karyawan'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['title'] = this.title;
    data['tab_jadwal_saya'] = this.tabJadwalSaya;
    data['tab_jadwal_teman'] = this.tabJadwalTeman;
    data['tab_jadwal_karyawan'] = this.tabJadwalKaryawan;
    data['tab_pengajuan_saya'] = this.tabPengajuanSaya;
    data['tab_pengajuan_karyawan'] = this.tabPengajuanKaryawan;
    return data;
  }
}
