import 'dart:convert';

PagePkwtModel pagePkwtModelFromJson(String str) =>
    PagePkwtModel.fromJson(json.decode(str));

String pagePkwtModelToJson(PagePkwtModel data) => json.encode(data.toJson());

class PagePkwtModel {
  MenuPkwt? menuPkwt;

  PagePkwtModel({this.menuPkwt});

  PagePkwtModel.fromJson(Map<String, dynamic> json) {
    menuPkwt = json['menu_pkwt'] != null
        ? new MenuPkwt.fromJson(json['menu_pkwt'])
        : null;
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    if (this.menuPkwt != null) {
      data['menu_pkwt'] = this.menuPkwt!.toJson();
    }
    return data;
  }
}

class MenuPkwt {
  Title? title;
  Data? data;
  PesanKonfirmasi? pesanKonfirmasi;
  Button? button;

  MenuPkwt({this.title, this.data, this.pesanKonfirmasi, this.button});

  MenuPkwt.fromJson(Map<String, dynamic> json) {
    title = json['title'] != null ? new Title.fromJson(json['title']) : null;
    data = json['data'] != null ? new Data.fromJson(json['data']) : null;
    pesanKonfirmasi = json['pesan_konfirmasi'] != null
        ? new PesanKonfirmasi.fromJson(json['pesan_konfirmasi'])
        : null;
    button =
        json['button'] != null ? new Button.fromJson(json['button']) : null;
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    if (this.title != null) {
      data['title'] = this.title!.toJson();
    }
    if (this.data != null) {
      data['data'] = this.data!.toJson();
    }
    if (this.pesanKonfirmasi != null) {
      data['pesan_konfirmasi'] = this.pesanKonfirmasi!.toJson();
    }
    return data;
  }
}

class Data {
  String? keterangan;
  String? oleh;
  String? tanggal;
  String? namaKaryawan;
  String? jabatan;
  String? cabangDepartment;
  String? detailPkwt;
  String? docPkwtTitle;
  String? lihatDokumen;
  String? downloadDokumen;
  String? persetujuanPKWT;
  String? penolakanPKWT;
  String? infoPKWT;
  String? ketMandatoryTTD;
  String? hintPenolakan;
  String? ketMandatoryPenolakan;
  String? statusSetuju;
  String? statusDitolak;

  Data(
      {this.keterangan,
      this.oleh,
      this.tanggal,
      this.namaKaryawan,
      this.jabatan,
      this.cabangDepartment,
      this.detailPkwt,
      this.docPkwtTitle,
      this.lihatDokumen,
      this.downloadDokumen,
      this.persetujuanPKWT,
      this.penolakanPKWT,
      this.infoPKWT,
      this.ketMandatoryTTD,
      this.hintPenolakan,
      this.ketMandatoryPenolakan,
      this.statusSetuju,
      this.statusDitolak});
  Data.fromJson(Map<String, dynamic> json) {
    keterangan = json['keterangan'];
    oleh = json['oleh'];
    tanggal = json['tanggal'];
    namaKaryawan = json['namaKaryawan'];
    jabatan = json['jabatan'];
    cabangDepartment = json['cabangDepartment'];
    detailPkwt = json['detailPkwt'];
    docPkwtTitle = json['docPkwtTitle'];
    lihatDokumen = json['lihatDokumen'];
    downloadDokumen = json['downloadDokumen'];
    persetujuanPKWT = json['persetujuanPKWT'];
    penolakanPKWT = json['penolakanPKWT'];
    infoPKWT = json['infoPKWT'];
    ketMandatoryTTD = json['ketMandatoryTTD'];
    hintPenolakan = json['hintPenolakan'];
    ketMandatoryPenolakan = json['ketMandatoryPenolakan'];
    statusSetuju = json['statusSetuju'];
    statusDitolak = json['statusDitolak'];
  }

  // Konversi Data ke JSON
  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = <String, dynamic>{};
    data['keterangan'] = keterangan;
    data['oleh'] = oleh;
    data['tanggal'] = tanggal;
    data['namaKaryawan'] = namaKaryawan;
    data['jabatan'] = jabatan;
    data['cabangDepartment'] = cabangDepartment;
    data['detailPkwt'] = detailPkwt;
    data['docPkwtTitle'] = docPkwtTitle;
    data['lihatDokumen'] = lihatDokumen;
    data['downloadDokumen'] = downloadDokumen;
    data['persetujuanPKWT'] = persetujuanPKWT;
    data['penolakanPKWT'] = penolakanPKWT;
    data['infoPKWT'] = infoPKWT;
    data['ketMandatoryTTD'] = ketMandatoryTTD;
    data['hintPenolakan'] = hintPenolakan;
    data['ketMandatoryPenolakan'] = ketMandatoryPenolakan;
    data['statusSetuju'] = statusSetuju;
    data['statusDitolak'] = statusDitolak;

    return data;
  }
}

class Title {
  String? parentTitle;
  String? titleDetail;
  String? titleRekap;
  String? tabSaya;
  String? tabKaryawan;
  Title({
    this.parentTitle,
    this.titleDetail,
    this.titleRekap,
    this.tabSaya,
    this.tabKaryawan,
  });

  Title.fromJson(Map<String, dynamic> json) {
    parentTitle = json['parent_title'];
    titleDetail = json['title_detail'];
    titleRekap = json['title_rekap'];
    tabSaya = json['tab_saya'];
    tabKaryawan = json['tab_karyawan'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['parent_title'] = this.parentTitle;
    data['title_detail'] = this.titleDetail;
    data['title_rekap'] = this.titleRekap;
    data['tab_saya'] = this.tabSaya;
    data['tab_karyawan'] = this.tabKaryawan;
    return data;
  }
}

class PesanKonfirmasi {
  String? emptyTTD;
  String? emptyTolak;

  PesanKonfirmasi({this.emptyTTD, this.emptyTolak});

  PesanKonfirmasi.fromJson(Map<String, dynamic> json) {
    emptyTTD = json['emptyTTD'];
    emptyTolak = json['emptyTolak'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['emptyTTD'] = this.emptyTTD;
    data['emptyTolak'] = this.emptyTolak;
    return data;
  }
}

class Button {
  String? btnTolak;
  String? btnBatal;
  String? btnSetujui;
  String? btnTddUlang;

  Button({this.btnTolak, this.btnBatal, this.btnSetujui, this.btnTddUlang});

  Button.fromJson(Map<String, dynamic> json) {
    btnTolak = json['btnTolak'];
    btnBatal = json['btnBatal'];
    btnSetujui = json['btnSetujui'];
    btnTddUlang = json['btnTddUlang'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['btnTolak'] = this.btnTolak;
    data['btnBatal'] = this.btnBatal;
    data['btnSetujui'] = this.btnSetujui;
    data['btnTddUlang'] = this.btnTddUlang;
    return data;
  }
}
