import 'dart:convert';

PageMonitorAbsenModel pageMonitorAbsenModelFromJson(String str) =>
    PageMonitorAbsenModel.fromJson(json.decode(str));

String pageMonitorAbsenModelToJson(PageMonitorAbsenModel data) =>
    json.encode(data.toJson());

class PageMonitorAbsenModel {
  MenuMonitorAbsen? menuMonitorAbsensi;

  PageMonitorAbsenModel({this.menuMonitorAbsensi});

  PageMonitorAbsenModel.fromJson(Map<String, dynamic> json) {
    menuMonitorAbsensi = json['menu_data_monitor_absen'] != null
        ? new MenuMonitorAbsen.fromJson(json['menu_data_monitor_absen'])
        : null;
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    if (this.menuMonitorAbsensi != null) {
      data['menu_data_monitor_absen'] = this.menuMonitorAbsensi!.toJson();
    }
    return data;
  }
}

class MenuMonitorAbsen {
  String? title;
  String? titleIzin;
  String? tabSaya;
  String? tabKaryawan;
  Data? data;
  String? locale;

  MenuMonitorAbsen({this.title,this.tabSaya,this.titleIzin, this.tabKaryawan, this.data});

  MenuMonitorAbsen.fromJson(Map<String, dynamic> json) {
    title = json['title'];
    titleIzin = json['title_izin'];
    data = json['data'] != null ? new Data.fromJson(json['data']) : null;
    locale = json['locale'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['title'] = this.title;
    data['title_izin'] = this.titleIzin;
    if (this.data != null) {
      data['data'] = this.data!.toJson();
    }
    data['locale'] = this.locale;
    return data;
  }
}

class Data {
  String? namaKaryawan;
  String? masuk;
  String? pulang;
  String? tanggalPengajuan;
  String? hari;
  String? periode;
  String? buttonLihatSemua;
  String? jamKerja;

  Data(
      {this.namaKaryawan,
      this.masuk,
      this.pulang,
      this.tanggalPengajuan,
      this.hari,
      this.periode,
      this.buttonLihatSemua,
      this.jamKerja
      });

  Data.fromJson(Map<String, dynamic> json) {
    namaKaryawan = json['nama_karyawan'];
    masuk = json['masuk'];
    pulang = json['pulang'];
    tanggalPengajuan = json['tanggalPengajuan'];
    hari = json['hari'];
    periode = json['periode'];
    buttonLihatSemua = json['button_lihat_semua'];
    jamKerja=json['jamKerja'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['nama_karyawan'] = this.namaKaryawan;
    data['masuk'] = this.masuk;
    data['pulang'] = this.pulang;
    data['tanggalPengajuan'] = this.tanggalPengajuan;
    data['hari'] = this.hari;
    data['periode'] = this.periode;
    data['button_lihat_semua'] = this.buttonLihatSemua;
    data['jamKerja'] = this.jamKerja;
    return data;
  }
}
