import 'dart:convert';

PageCutiModel pageCutiModelFromJson(String str) =>
    PageCutiModel.fromJson(json.decode(str));

String pageCutiModelToJson(PageCutiModel data) => json.encode(data.toJson());

class PageCutiModel {
  MenuCuti? menuCuti;

  PageCutiModel({this.menuCuti});

  PageCutiModel.fromJson(Map<String, dynamic> json) {
    menuCuti = json['menu_cuti'] != null
        ? new MenuCuti.fromJson(json['menu_cuti'])
        : null;
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    if (this.menuCuti != null) {
      data['menu_cuti'] = this.menuCuti!.toJson();
    }
    return data;
  }
}

class MenuCuti {
  Title? title;
  Data? data;
  Button? button;
  PesanKonfirmasi? pesanKonfirmasi;

  MenuCuti({this.title, this.data, this.button, this.pesanKonfirmasi});

  MenuCuti.fromJson(Map<String, dynamic> json) {
    title = json['title'] != null ? new Title.fromJson(json['title']) : null;
    data = json['data'] != null ? new Data.fromJson(json['data']) : null;
    button =
        json['button'] != null ? new Button.fromJson(json['button']) : null;
    pesanKonfirmasi = json['pesan_konfirmasi'] != null
        ? new PesanKonfirmasi.fromJson(json['pesan_konfirmasi'])
        : null;
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    if (this.title != null) {
      data['title'] = this.title!.toJson();
    }
    if (this.data != null) {
      data['data'] = this.data!.toJson();
    }
    if (this.button != null) {
      data['button'] = this.button!.toJson();
    }
    if (this.pesanKonfirmasi != null) {
      data['pesan_konfirmasi'] = this.pesanKonfirmasi!.toJson();
    }
    return data;
  }
}

class Title {
  String? parentTitle;
  String? titleDetail;
  String? titleRekap;
  String? tabSaya;
  String? tabKaryawan;
  String? titleCuti;
  Title(
      {this.parentTitle,
      this.titleDetail,
      this.titleRekap,
      this.tabSaya,
      this.tabKaryawan,
      this.titleCuti});

  Title.fromJson(Map<String, dynamic> json) {
    parentTitle = json['parent_title'];
    titleDetail = json['title_detail'];
    titleRekap = json['title_rekap'];
    tabSaya = json['tab_saya'];
    tabKaryawan = json['tab_karyawan'];
    titleCuti = json['title_cuti'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['parent_title'] = this.parentTitle;
    data['title_detail'] = this.titleDetail;
    data['title_rekap'] = this.titleRekap;
    data['tab_saya'] = this.tabSaya;
    data['tab_karyawan'] = this.tabKaryawan;
    data['title_cuti'] = this.titleCuti;
    return data;
  }
}

class Data {
  String? saldoCuti;
  String? berlakuHingga;
  String? sudahDigunakan;
  String? diTambahkan;
  String? riwayatCuti;
  String? riwayatSaldo;

  Data({this.sudahDigunakan, this.diTambahkan, this.riwayatCuti,this.riwayatSaldo,this.saldoCuti});

  Data.fromJson(Map<String, dynamic> json) {
    saldoCuti = json['saldo_cuti'];
    berlakuHingga = json['berlaku_hingga'];
    sudahDigunakan = json['sudah_digunakan'];
    diTambahkan = json['ditambahkan'];
    riwayatCuti = json['riwayat_cuti'];
    riwayatSaldo = json['riwayat_saldo'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['saldo_cuti'] = this.saldoCuti;
    data['berlaku_hingga'] = this.berlakuHingga;
    data['sudah_digunakan'] = this.sudahDigunakan;
    data['ditambahkan'] = this.diTambahkan;
    data['riwayat_cuti'] = this.riwayatCuti;
    data['riwayat_saldo'] = this.riwayatSaldo;
    return data;
  }
}

class Button {
  String? detail;
  String? batalkan;
  String? setujui;
  String? tolak;
  String? setujuiSemua;
  String? tolakSemua;
  String? btnSubmit;

  Button(
      {this.detail,
      this.batalkan,
      this.setujui,
      this.tolak,
      this.setujuiSemua,
      this.tolakSemua,
      this.btnSubmit});

  Button.fromJson(Map<String, dynamic> json) {
    detail = json['detail'];
    batalkan = json['batalkan'];
    setujui = json['setujui'];
    tolak = json['tolak'];
    setujuiSemua = json['setujui_semua'];
    tolakSemua = json['tolak_semua'];
    btnSubmit = json['btn_submit'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['detail'] = this.detail;
    data['batalkan'] = this.batalkan;
    data['setujui'] = this.setujui;
    data['tolak'] = this.tolak;
    data['setujui_semua'] = this.setujuiSemua;
    data['tolak_semua'] = this.tolakSemua;
    data['btn_submit'] = this.btnSubmit;
    return data;
  }
}

class PesanKonfirmasi {
  String? tolak;
  String? tolakSemua;
  String? setujui;
  String? setujuiSemua;
  String? batalkan;
  String? jenisIsEmpty;
  String? tanggalIsEmpty;
  String? fileIsEmpty;
  String? ketIsEmpty;
  String? tidakAdaLampiran;

  PesanKonfirmasi(
      {this.tolak,
      this.tolakSemua,
      this.setujui,
      this.setujuiSemua,
      this.batalkan,
      this.jenisIsEmpty,
      this.tanggalIsEmpty,
      this.fileIsEmpty,
      this.ketIsEmpty,
      this.tidakAdaLampiran});

  PesanKonfirmasi.fromJson(Map<String, dynamic> json) {
    tolak = json['tolak'];
    tolakSemua = json['tolak_semua'];
    setujui = json['setujui'];
    setujuiSemua = json['setujui_semua'];
    batalkan = json['batalkan'];
    jenisIsEmpty = json['jenis_is_empty'];
    tanggalIsEmpty = json['tanggal_is_empty'];
    fileIsEmpty = json['file_is_empty'];
    ketIsEmpty = json['ket_is_empty'];
    tidakAdaLampiran = json['tidak_ada_lampiran'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['tolak'] = this.tolak;
    data['tolak_semua'] = this.tolakSemua;
    data['setujui'] = this.setujui;
    data['setujui_semua'] = this.setujuiSemua;
    data['batalkan'] = this.batalkan;
    data['jenis_is_empty'] = this.jenisIsEmpty;
    data['tanggal_is_empty'] = this.tanggalIsEmpty;
    data['file_is_empty'] = this.fileIsEmpty;
    data['ket_is_empty'] = this.ketIsEmpty;
    data['tidak_ada_lampiran'] = this.tidakAdaLampiran;
    return data;
  }
}
