import 'dart:convert';

DataPengajuanAspekKepribadian dataPengajuanAspekKepribadianFromJson(
        String str) =>
    DataPengajuanAspekKepribadian.fromJson(json.decode(str));

String dataPengajuanAspekKepribadianToJson(
        DataPengajuanAspekKepribadian data) =>
    json.encode(data.toJson());

class DataPengajuanAspekKepribadian {
  bool? success;
  String? message;
  List<DataAspekKepribadian>? data;

  DataPengajuanAspekKepribadian({
    this.success,
    this.message,
    this.data,
  });

  factory DataPengajuanAspekKepribadian.fromJson(Map<String, dynamic> json) =>
      DataPengajuanAspekKepribadian(
        success: json["success"],
        message: json["message"],
        data: json['data'] == null ? null :List<DataAspekKepribadian>.from(
            json["data"].map((x) => DataAspekKepribadian.fromJson(x))),
      );

  Map<String, dynamic> toJson() => {
        "success": success,
        "message": message,
        "data": data == null ? null :List<dynamic>.from(data!.map((x) => x.toJson())),
      };
}

class DataAspekKepribadian {
  String? idKaryawan;
  int? tahun;
  int? bulan;
  String? idAspekKepribadian;
  String? idAspekKepribadianM;
  String? personalAspek;
  String? keterangan;
  int? bobot;
  String? levelUser;
  String? poin1;
  String? poin2;
  String? poin3;
  String? poin4;
  String? poin5;
  int? noUrut;
  int? actualPoinApproval;
  String? idCompany;
  String? userInput;
  String? tglInput;
  String? userUpdate;
  String? tglUpdate;

  DataAspekKepribadian({
    this.idKaryawan,
    this.tahun,
    this.bulan,
    this.idAspekKepribadian,
    this.idAspekKepribadianM,
    this.personalAspek,
    this.keterangan,
    this.bobot,
    this.levelUser,
    this.poin1,
    this.poin2,
    this.poin3,
    this.poin4,
    this.poin5,
    this.noUrut,
    this.actualPoinApproval,
    this.idCompany,
    this.userInput,
    this.tglInput,
    this.userUpdate,
    this.tglUpdate,
  });

  factory DataAspekKepribadian.fromJson(Map<String, dynamic> json) =>
      DataAspekKepribadian(
        idKaryawan: json["id_karyawan"],
        tahun: json["tahun"],
        bulan: json["bulan"],
        idAspekKepribadian: json["id_aspek_kepribadian"],
        idAspekKepribadianM: json["id_aspek_kepribadian_m"],
        personalAspek: json["personal_aspek"],
        keterangan: json["keterangan"],
        bobot: json["bobot"],
        levelUser: json["level_user"],
        poin1: json["poin_1"],
        poin2: json["poin_2"],
        poin3: json["poin_3"],
        poin4: json["poin_4"],
        poin5: json["poin_5"],
        noUrut: json["no_urut"],
        actualPoinApproval: json["actual_poin_approval"],
        idCompany: json["id_company"],
        userInput: json["user_input"],
        tglInput: json["tgl_input"],
        userUpdate: json["user_update"],
        tglUpdate: json["tgl_update"],
      );

  Map<String, dynamic> toJson() => {
        "id_karyawan": idKaryawan,
        "tahun": tahun,
        "bulan": bulan,
        "id_aspek_kepribadian": idAspekKepribadian,
        "id_aspek_kepribadian_m": idAspekKepribadianM,
        "personal_aspek": personalAspek,
        "keterangan": keterangan,
        "bobot": bobot,
        "level_user": levelUser,
        "poin_1": poin1,
        "poin_2": poin2,
        "poin_3": poin3,
        "poin_4": poin4,
        "poin_5": poin5,
        "no_urut": noUrut,
        "actual_poin_approval": actualPoinApproval,
        "id_company": idCompany,
        "user_input": userInput,
        "tgl_input": tglInput,
        "user_update": userUpdate,
        "tgl_update": tglUpdate,
      };
}
