// To parse this JSON data, do
//
//     final responPeriodeCuti = responPeriodeCutiFromJson(jsonString);

import 'dart:convert';

ResponPeriodeCuti responPeriodeCutiFromJson(String str) => ResponPeriodeCuti.fromJson(json.decode(str));

String responPeriodeCutiToJson(ResponPeriodeCuti data) => json.encode(data.toJson());

class ResponPeriodeCuti {
    bool? success;
    String? message;
    Data? data;

    ResponPeriodeCuti({
        this.success,
        this.message,
        this.data,
    });

    factory ResponPeriodeCuti.fromJson(Map<String, dynamic> json) => ResponPeriodeCuti(
        success: json["success"],
        message: json["message"],
        data: Data.fromJson(json["data"]),
    );

    Map<String, dynamic> toJson() => {
        "success": success,
        "message": message,
        "data": data!.toJson(),
    };
}

class Data {
    String? periodeAwal;
    String? periodeAkhir;

    Data({
        this.periodeAwal,
        this.periodeAkhir,
    });

    factory Data.fromJson(Map<String, dynamic> json) => Data(
        periodeAwal: json["periode_awal"],
        periodeAkhir: json["periode_akhir"],
    );

    Map<String, dynamic> toJson() => {
        "periode_awal": periodeAwal,
        "periode_akhir": periodeAkhir,
    };
}
